/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CanvasServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ViewServiceImpl
implements ViewService {
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private CanvasSchemaService canvasSchemaService;

    @Override
    @Transactional
    public FormDesignResponse<Boolean> save(FormViewSchema formViewSchema) throws Exception {
        FormDesignResponse<Boolean> updateForm = this.viewSchemaService.saveOrUpdate(formViewSchema);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formViewSchema.getFormId());
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u4fdd\u5b58\u5931\u8d25");
        }
        this.formOperateService.publish(formViewSchema.getFormId());
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<FormViewSchema> get(String formId) {
        FormViewSchema view = (FormViewSchema)this.viewSchemaService.get(formId).getData();
        if (HussarUtils.isEmpty((Object)view)) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25");
        }
        FormDesignResponse<FormCanvasSchema> canvasRes = this.canvasSchemaService.get(formId);
        if (HussarUtils.isEmpty((Object)canvasRes.getData())) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        List<Widget> widgetsWithSys = ((FormCanvasSchema)((Object)canvasRes.getData())).widgetsWithSys();
        if ("1".equals(((FormCanvasSchema)((Object)canvasRes.getData())).getFormType())) {
            ViewServiceImpl.addFlow(widgetsWithSys);
        }
        view.setColumns(widgetsWithSys);
        return FormDesignResponse.success((Object)view);
    }

    public static void addFlow(List<Widget> widgets) {
        List processWidget = JSON.parseArray((String)ToolUtil.loadResource(CanvasServiceImpl.class, (String)"/process_info_widgets.json"), Widget.class);
        List processTaskWidget = JSON.parseArray((String)ToolUtil.loadResource(CanvasServiceImpl.class, (String)"/process_task_info_widgets.json"), Widget.class);
        widgets.addAll(processWidget);
        widgets.addAll(processTaskWidget);
    }
}

