/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.BuilderCtx;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.flow.FlowFormVO;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.ModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeModelHandler;
import com.jxdinfo.hussar.formdesign.no.code.tool.PageBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class FormOperateImpl
implements FormOperateService {
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private ViewService viewService;

    @Override
    public void publish(String formId) throws Exception {
        FormDesignResponse<FormSchema> form = this.get(formId);
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)form.getData());
        DataModelBase dataModelBase = builder.direct();
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        noCodeModelHandler.sync(dataModelBase);
        noCodeModelHandler.generate(dataModelBase);
    }

    @Override
    public void delete(String formId) throws Exception {
        FormDesignResponse<FormSchema> form = this.get(formId);
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)form.getData());
        DataModelBase dataModelBase = builder.direct();
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        noCodeModelHandler.delete(dataModelBase);
    }

    @Override
    public FormDesignResponse<FormSchema> get(String formId) throws Exception {
        FormSchema.Builder builder = new FormSchema.Builder();
        builder.formPage((FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData())).setting((FormSettingSchema)((Object)((SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class)).get(formId).getData())).view((FormViewSchema)this.viewService.get(formId).getData()).build();
        return FormDesignResponse.success((Object)builder.build());
    }

    @Override
    public FormDesignResponse<List<WidgetField>> widgetsForFlow(String formId, boolean isFlow) {
        FormDesignResponse<FormCanvasSchema> formCanvasSchema = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)formCanvasSchema.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        List<Widget> widgets = canvas.widgets();
        widgets.addAll(canvas.childTables());
        ArrayList<WidgetField> widgetFields = new ArrayList<WidgetField>();
        WidgetTool.ofWidgetFields(widgetFields, widgets, widget -> false);
        return FormDesignResponse.success(widgetFields);
    }

    @Override
    public FormDesignResponse<List<WidgetField>> widgetsForAuth(String formId) {
        FormDesignResponse<FormCanvasSchema> formCanvasSchema = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)formCanvasSchema.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        List<Widget> widgets = canvas.widgetsWithSys();
        widgets.addAll(canvas.childTables());
        ArrayList<WidgetField> widgetFields = new ArrayList<WidgetField>();
        WidgetTool.ofWidgetFields(widgetFields, widgets, widget -> WidgetTool.anyMatch(widget.getName(), WidgetTool.excludeFields()));
        return FormDesignResponse.success(widgetFields);
    }

    @Override
    public FormDesignResponse<List<WidgetField>> widgetsForSetting(String formId) {
        FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u7528\u6237\u53ef\u9009\u7684\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u7528\u6237\u53ef\u9009\u7684\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        List<Widget> widgets = canvas.widgetsWithSys();
        List<Widget> filterWidgets = WidgetTool.settingWidgets(widgets);
        ArrayList<WidgetField> widgetFields = new ArrayList<WidgetField>();
        WidgetTool.ofWidgetFields(widgetFields, filterWidgets, widget -> false);
        return FormDesignResponse.success(widgetFields);
    }

    @Override
    public FormDesignResponse<FlowFormVO> info(String formId) throws Exception {
        FormDesignResponse<FormSchema> formResponse = this.get(formId);
        if (HussarUtils.isEmpty((Object)formResponse.getData())) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u57fa\u7840\u4fe1\u606f ==> \u83b7\u53d6\u8868\u5355\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((int)10001, null, (String)"\u83b7\u53d6\u8868\u5355\u57fa\u7840\u4fe1\u606f ==> \u83b7\u53d6\u8868\u5355\u5931\u8d25");
        }
        FormSchema form = (FormSchema)formResponse.getData();
        FormCanvasSchema canvas = form.getFormCanvas();
        if (HussarUtils.isEmpty((Object)((Object)canvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u57fa\u7840\u4fe1\u606f ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u57fa\u7840\u4fe1\u606f ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        FlowFormVO formVO = new FlowFormVO();
        if ("1".equals(canvas.getFormType())) {
            DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder(form);
            builder.direct();
            FlowFormVO flowFormVO = builder.getFlowFormVO();
            BeanUtils.copyProperties((Object)((Object)flowFormVO), (Object)((Object)formVO));
        }
        BeanUtils.copyProperties((Object)((Object)canvas), (Object)((Object)formVO));
        return FormDesignResponse.success((Object)((Object)formVO));
    }

    @Override
    public FormDesignResponse<Boolean> upgrade(String formId) throws Exception {
        BuilderCtx ctx = new BuilderCtx();
        FormDesignResponse<FormSchema> form = this.get(formId);
        if (form.getErrorCode() != ResultCode.SUCCESS.getCode() || HussarUtils.isEmpty(form) || HussarUtils.isEmpty((Object)form.getData())) {
            ToolUtil.getLogger(this.getClass()).error("\u96f6\u8f6c\u4f4e ==> \u83b7\u53d6\u8868\u5355\u57fa\u7840\u4fe1\u606f\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u96f6\u8f6c\u4f4e ==> \u83b7\u53d6\u8868\u5355\u57fa\u7840\u4fe1\u606f\u5931\u8d25");
        }
        DataModelBuilder modelBuilder = ModelBuilderAdapter.adaptBuilder((FormSchema)form.getData());
        modelBuilder.build(ctx);
        ctx.setForm((FormSchema)form.getData());
        PageBuilder builder = PageBuilderFactory.strategy("form.page.builder");
        builder.init(ctx);
        builder.direct();
        FormViewSchema view = ctx.getForm().getView();
        if (HussarUtils.isNotEmpty((Object)view) && HussarUtils.isNotEmpty(view.getViews())) {
            for (DataView dataView : view.getViews()) {
                ctx.setCurrentView(dataView);
            }
        }
        return null;
    }
}

