/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.base.portal.form.model.SysForm;
import com.jxdinfo.hussar.base.portal.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.base.portal.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.DataFilterType;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControlSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.FormCanvasSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.FieldControlUnitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.FormViewSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SettingService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.constant.FilterType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.FormCleaner;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.ModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeModelHandler;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FormOperateExposedImpl
implements FormOperateExposedService {
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private ViewService viewService;
    @Resource
    private SettingService settingService;
    @Resource
    private FormOperateService formOperate;
    @Resource
    private FormCleaner formCleaner;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private ISysApplicationExternalService externalService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormOperateExposedImpl.class);
    private static final String BASE_FORM = "0";
    private static final String FLOW_FORM = "1";

    @HussarTransactional
    public ApiResponse<Boolean> create(BaseForm baseForm, String appId) throws Exception {
        String formId = baseForm.getId();
        AppContextUtil.setAppId((String)appId);
        FormCanvasSchema canvas = this.initCanvas(baseForm);
        FormSchema formSchema = new FormSchema.Builder().formPage(canvas).build();
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder(formSchema);
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        DataModelBase dataModelBase = builder.direct();
        noCodeModelHandler.updateTable(dataModelBase, builder.createContrast());
        FormViewSchema view = this.initView(canvas);
        FormSettingSchema setting = this.initSetting(formId);
        this.canvasSchemaService.saveOrUpdate(canvas);
        this.viewSchemaService.saveOrUpdate(view);
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
        settingSchemaService.saveOrUpdate(setting, formId);
        this.formOperate.publish(formId);
        return ApiResponse.success((Object)true);
    }

    @HussarTransactional
    public ApiResponse<Boolean> delete(String formId, String appId) throws Exception {
        AppContextUtil.setAppId((String)appId);
        this.formOperate.delete(formId);
        FormDesignResponse<Boolean> response = this.formCleaner.formClean(formId);
        if (((Boolean)response.getData()).booleanValue()) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.fail((String)response.getErrorMsg());
    }

    @HussarTransactional
    public ApiResponse<Boolean> appClean(String appId, List<String> formIds) {
        FormDesignResponse<Boolean> response;
        AppContextUtil.setAppId((String)appId);
        ApiResponse formRes = this.externalService.getFormListByAppId(Long.valueOf(appId));
        if (HussarUtils.isEmpty((Object)formRes.getData())) {
            return ApiResponse.success((Object)true);
        }
        List haveGroupList = ((SysSiftGroupList)formRes.getData()).getHaveGroupList();
        List noGroupList = ((SysSiftGroupList)formRes.getData()).getNoGroupList();
        ArrayList forms = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)haveGroupList)) {
            for (SysFormGroupVo sysFormGroupVo : haveGroupList) {
                List sysFormList = sysFormGroupVo.getSysFormList();
                if (!HussarUtils.isNotEmpty((Object)sysFormList)) continue;
                sysFormList.forEach(sysForm -> forms.add(String.valueOf(sysForm.getId())));
            }
        }
        if (HussarUtils.isNotEmpty((Object)noGroupList)) {
            noGroupList.forEach(sysForm -> forms.add(String.valueOf(sysForm.getId())));
        }
        if (HussarUtils.isNotEmpty(forms)) {
            forms.forEach(id -> {
                try {
                    this.formOperate.delete((String)id);
                }
                catch (Exception e) {
                    LOGGER.error("\u5220\u9664\u89e3\u6790\u5f15\u64ce\u6570\u636e\u5f02\u5e38\uff1a{}", id);
                }
            });
        }
        if (((Boolean)(response = this.formCleaner.appClean()).getData()).booleanValue()) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.fail((String)"\u5220\u9664\u5e94\u7528\u8d44\u6e90\u5931\u8d25");
    }

    public ApiResponse<List<DataFilterType>> filters(String widget) {
        ArrayList<DataFilterType> types = new ArrayList<DataFilterType>();
        if (HussarUtils.isEmpty((Object)widget)) {
            for (FilterType value : FilterType.values()) {
                DataFilterType type = new DataFilterType();
                type.setWidget(value.getWidgetType());
                type.setFilterTypes(value.getFilterTypes());
                types.add(type);
            }
            return ApiResponse.success(types);
        }
        DataFilterType type = new DataFilterType();
        type.setWidget(widget);
        type.setFilterTypes(FilterType.getFilters(widget));
        return ApiResponse.success(Collections.singletonList(type));
    }

    public ApiResponse<FieldControlSchema> fieldControllers(String formId) {
        FormDesignResponse fieldControlResponse = ((SettingSchemaService)SpringUtil.getBean((String)"no.code.fieldControl", SettingSchemaService.class)).get(formId);
        return ApiResponse.success((Object)fieldControlResponse.getData());
    }

    public ApiResponse<List<WidgetField>> widgets(String formId) {
        FormDesignResponse<List<WidgetField>> formDesignResponse = this.formOperate.widgetsForAuth(formId);
        ApiResponse response = new ApiResponse();
        response.setCode(formDesignResponse.getErrorCode());
        response.setMsg(formDesignResponse.getErrorMsg());
        response.setData(formDesignResponse.getData());
        return response;
    }

    public FormCanvasSchema initCanvas(BaseForm baseForm) {
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)JSON.parseObject((String)JSON.toJSONString((Object)baseForm), FormCanvasSchema.class));
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("formLayout", "fixed");
        props.put("formWidth", 1000);
        props.put("fieldLayout", 0);
        props.put("labelAlign", "left");
        props.put("labelWidth", 84);
        canvas.setProps(props);
        canvas.setIsDetails(BASE_FORM);
        return canvas;
    }

    public FormViewSchema initView(FormCanvasSchema canvas) {
        FormViewSchema view = new FormViewSchema();
        if (BASE_FORM.equals(canvas.getFormType())) {
            view = (FormViewSchema)JSON.parseObject((String)ToolUtil.loadResource(this.getClass(), (String)"/default_view_schema.json"), FormViewSchema.class);
        }
        if (FLOW_FORM.equals(canvas.getFormType())) {
            view = (FormViewSchema)JSON.parseObject((String)ToolUtil.loadResource(this.getClass(), (String)"/default_flow_view_schema.json"), FormViewSchema.class);
        }
        this.common(canvas, view);
        return view;
    }

    public FormSettingSchema initSetting(String formId) {
        FormSettingSchema setting = (FormSettingSchema)((Object)JSON.parseObject((String)ToolUtil.loadResource(this.getClass(), (String)"/default_setting_schema.json"), FormSettingSchema.class));
        setting.setFormId(formId);
        return setting;
    }

    private void common(FormCanvasSchema canvas, FormViewSchema view) {
        view.setAppId(AppContextUtil.getAppId());
        view.setFormId(canvas.getId());
        view.setFormName(canvas.getName());
        view.setFormTitle(canvas.getTitle());
        view.setFormType(canvas.getFormType());
        view.setFormIcon(canvas.getIcon());
    }

    public String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        String formName = ((FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData())).getName();
        String url = FileUtil.posixPath((String[])new String[]{appId, formName, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }

    public ResponseEntity<ApiResponse<Object>> tableQuery(String formId, String viewId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, String.format("%s%s", "TableQuery", viewId));
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> formQuery(String formId, String id) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.GET.name(), appId, formId, "FormQuery");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> deleteBatch(String formId, String ids) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "DeleteBatch");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ids", ids);
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> formSave(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FormSave");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> flowFormSubmit(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FlowFormSubmit");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> flowFormRecall(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FlowFormRecall");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> initialNodeReject(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "InitialNodeReject");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> prevNodeReject(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "PrevNodeReject");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> taskEntrust(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TaskEntrust");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> endProcess(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "EndProcess");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public FormCanvasSchemaDTO getCanvas(String formId) {
        FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
        if (HussarUtils.isNotEmpty((Object)((Object)canvas))) {
            FormCanvasSchemaDTO canvasDto = new FormCanvasSchemaDTO();
            BeanUtils.copyProperties((Object)((Object)canvas), (Object)canvasDto);
            return canvasDto;
        }
        return null;
    }

    public FormViewSchemaDTO getView(String formId) throws Exception {
        FormDesignResponse<FormViewSchema> viewResponse = this.viewService.get(formId);
        FormViewSchema view = (FormViewSchema)viewResponse.getData();
        if (HussarUtils.isNotEmpty((Object)view)) {
            FormViewSchemaDTO viewDto = new FormViewSchemaDTO();
            BeanUtils.copyProperties((Object)view, (Object)viewDto);
            ISysApplicationExternalService iSysApplicationExternalService = (ISysApplicationExternalService)SpringUtil.getBean(ISysApplicationExternalService.class);
            SysForm formDetailById = iSysApplicationExternalService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
            if (HussarUtils.isEmpty((Object)formDetailById) || HussarUtils.isEmpty((Object)formDetailById.getFormStatus())) {
                ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u72b6\u6001\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
                return null;
            }
            viewDto.setFormStatus(formDetailById.getFormStatus());
            return viewDto;
        }
        return null;
    }

    public FieldControlUnitSchema getFieldControl(String formId) throws IOException {
        FormDesignResponse<FieldControlUnitSchema> fieldControlResponse = this.settingService.getFieldControl(formId);
        FieldControlUnitSchema fieldControl = (FieldControlUnitSchema)fieldControlResponse.getData();
        if (HussarUtils.isNotEmpty((Object)fieldControl)) {
            return fieldControl;
        }
        return null;
    }

    public SubmitSchema getSubmit(String formId) {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.submit", SettingSchemaService.class);
        FormDesignResponse submitResponse = settingSchemaService.get(formId);
        SubmitSchema submit = (SubmitSchema)submitResponse.getData();
        if (HussarUtils.isNotEmpty((Object)submit)) {
            return submit;
        }
        return null;
    }
}

