/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.controller;

import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControlSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.FieldControlUnitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SettingService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/form/setting"})
public class SettingController {
    @Resource
    private SettingService settingService;

    @PostMapping(value={"/title"})
    public FormDesignResponse<Boolean> saveTitle(@RequestBody TitleSchema titleSchema, @RequestParam(value="formId") String formId) throws Exception {
        return this.settingService.saveTitle(titleSchema, formId);
    }

    @GetMapping(value={"/title"})
    public FormDesignResponse<TitleSchema> getTitle(@RequestParam String formId) {
        return this.settingService.getTitle(formId);
    }

    @PostMapping(value={"/summary"})
    public FormDesignResponse<Boolean> saveSummary(@RequestBody List<String> dataSummary, @RequestParam(value="formId") String formId) throws Exception {
        return this.settingService.saveSummary(dataSummary, formId);
    }

    @GetMapping(value={"/summary"})
    public FormDesignResponse<List<String>> getSummary(@RequestParam String formId) {
        return this.settingService.getSummary(formId);
    }

    @PostMapping(value={"/fieldControl"})
    public FormDesignResponse<Boolean> saveFieldControl(@RequestBody FieldControlSchema fieldControlSchema, @RequestParam(value="formId") String formId) throws Exception {
        return this.settingService.saveFieldControl(fieldControlSchema, formId);
    }

    @GetMapping(value={"/fieldControl"})
    public FormDesignResponse<FieldControlUnitSchema> getFieldControl(@RequestParam String formId) throws IOException {
        return this.settingService.getFieldControl(formId);
    }

    @PostMapping(value={"/submit"})
    public FormDesignResponse<Boolean> saveSubmit(@RequestBody SubmitSchema submitSchema, @RequestParam(value="formId") String formId) throws Exception {
        return this.settingService.saveSubmit(submitSchema, formId);
    }

    @GetMapping(value={"/submit"})
    public FormDesignResponse<SubmitSchema> getSubmit(@RequestParam String formId) {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.submit", SettingSchemaService.class);
        return settingSchemaService.get(formId);
    }
}

