/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNSelectMulti")
public class JXDNSelectMulti
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleType.CLOB.name());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(255).build());
        fields.add(this.getLabelField(dbType, widget));
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = widget.getTitle();
        return new DataModelFieldBase.Builder().withId(name + "_label").withName(name + "_label").withComment(title + "-\u663e\u793a\u503c").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(255).build();
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("derived", String.format("%s%s", this.widget.getName(), "_label"));
    }

    @Override
    public Object getModelByWidgetType(String name, Map<String, SysUsers> mapUserNameSysUsers, Map<String, OrganizationBo> mapOrganNameSysOrgans, Map<Long, List<RegionVo>> parentIdRegionVoMap, Integer addressLevel) {
        ArrayList userObjects = Lists.newArrayListWithCapacity((int)5);
        if (HussarUtils.isNotEmpty((Object)name)) {
            String[] lables = this.getLables(name);
            for (int i = 0; i < lables.length; ++i) {
                String label = lables[i];
                userObjects.add(this.getModelValue(label));
            }
        }
        return userObjects;
    }

    private String[] getLables(String name) {
        String[] lables = name.contains(",") ? name.split(",") : (name.contains("\uff0c") ? name.split("\uff0c") : new String[]{name});
        return lables;
    }

    private JSONObject getModelValue(String nameValue) {
        JSONObject userObject = new JSONObject();
        if (HussarUtils.isEmpty((Object)nameValue)) {
            userObject.put("label", (Object)"");
            userObject.put("value", (Object)"");
        } else {
            userObject.put("label", (Object)nameValue);
            userObject.put("value", (Object)nameValue);
        }
        return userObject;
    }
}

