/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNAddress")
public class JXDNAddress
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.VARCHAR.name());
            this.put("ORACLE", OracleType.VARCHAR2.name());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name + "_code").withName(name + "_code").withComment(title + "-\u7701\u5e02\u533a\u7f16\u7801").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(20).build());
        fields.add(new DataModelFieldBase.Builder().withId(name + "_detailed").withName(name + "_detailed").withComment(title + "\u8be6\u7ec6").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(255).build());
        fields.add(this.getLabelField(dbType, widget));
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = widget.getTitle();
        return new DataModelFieldBase.Builder().withId(name + "_name").withName(name + "_label").withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(255).build();
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("derived", String.format("%s%s,%s%s", this.widget.getName(), "_label", this.widget.getName(), "_detailed"));
    }

    @Override
    public Object getModelByWidgetType(String name, Map<String, SysUsers> mapUserNameSysUsers, Map<String, OrganizationBo> mapOrganNameSysOrgans, Map<Long, List<RegionVo>> parentIdRegionVoMap, Integer addressLevel) {
        Long code = this.getCode(name, addressLevel, parentIdRegionVoMap);
        JSONObject userObject = new JSONObject();
        userObject.put("code", (Object)(HussarUtils.isEmpty((Object)code) ? "" : String.valueOf(code)));
        userObject.put("label", (Object)(HussarUtils.isEmpty((Object)code) ? "" : name));
        return userObject;
    }

    private Long getCode(String address, Integer addressLevel, Map<Long, List<RegionVo>> parentIdRegionVoMap) {
        RegionVo regionVo;
        Map nameRegionVoMap;
        List<RegionVo> regionVos;
        if (HussarUtils.isEmpty((Object)address)) {
            return null;
        }
        Long currentCode = null;
        String[] addressList = address.split("/");
        Long parentId = 0L;
        if (addressLevel >= 1) {
            if (addressList.length < 1) {
                return null;
            }
            String addressCurrent = addressList[0];
            List<RegionVo> regionVos2 = parentIdRegionVoMap.get(parentId);
            if (regionVos2 != null && regionVos2.size() > 0) {
                Map nameRegionVoMap2 = regionVos2.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1));
                RegionVo regionVo2 = (RegionVo)nameRegionVoMap2.get(addressCurrent);
                if (HussarUtils.isEmpty((Object)regionVo2)) {
                    return null;
                }
                parentId = currentCode = regionVo2.getId();
            }
        }
        if (addressLevel >= 2) {
            if (addressList.length < 2) {
                return null;
            }
            regionVos = parentIdRegionVoMap.get(parentId);
            if (regionVos != null && regionVos.size() > 0) {
                nameRegionVoMap = regionVos.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1));
                regionVo = (RegionVo)nameRegionVoMap.get(addressList[1]);
                if (HussarUtils.isEmpty((Object)regionVo)) {
                    return null;
                }
                parentId = currentCode = regionVo.getId();
            }
        }
        if (addressLevel >= 3) {
            if (addressList.length < 3) {
                return null;
            }
            regionVos = parentIdRegionVoMap.get(parentId);
            if (regionVos != null && regionVos.size() > 0) {
                nameRegionVoMap = regionVos.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1));
                regionVo = (RegionVo)nameRegionVoMap.get(addressList[2]);
                if (HussarUtils.isEmpty((Object)regionVo)) {
                    return null;
                }
                parentId = currentCode = regionVo.getId();
            }
        }
        if (addressLevel >= 4) {
            if (addressList.length < 4) {
                return null;
            }
            regionVos = parentIdRegionVoMap.get(parentId);
            if (HussarUtils.isNotEmpty(regionVos)) {
                nameRegionVoMap = regionVos.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1));
                regionVo = (RegionVo)nameRegionVoMap.get(addressList[3]);
                if (HussarUtils.isEmpty((Object)regionVo)) {
                    return null;
                }
                parentId = currentCode = regionVo.getId();
            }
        }
        return currentCode;
    }
}

