/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.storage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormIndexMeta;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnOfflineStorage.class})
public class ViewSchemaStorageImpl
implements ViewSchemaService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewSchemaStorageImpl.class);
    public static final String VIEW_PATH = "view";
    public static final String VIEW_SUFFIX = ".vd";
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private StorageService storage;
    @Resource
    private ISysApplicationExternalService applicationService;

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormViewSchema formViewSchema) throws JsonProcessingException {
        String formId = formViewSchema.getFormId();
        FormDesignResponse<FormCanvasSchema> response = this.canvasSchemaService.get(formId);
        if (HussarUtils.isEmpty((Object)response.getData())) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)response.getData());
        String path = FileUtil.posixPath((String[])new String[]{canvasSchema.getId(), VIEW_PATH, canvasSchema.getName() + VIEW_SUFFIX});
        String metaPath = path + ".meta";
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String viewId = formIndexMeta.getViewId();
        StorageResult viewJsonRes = this.storage.uploadByUuid(CategoryEnum.JSON, viewId, path, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)formViewSchema).getBytes(StandardCharsets.UTF_8), false);
        FormIndexMeta viewMeta = new FormIndexMeta();
        viewMeta.setId(viewId);
        viewMeta.setPath(metaPath);
        StorageResult viewMetaRes = this.storage.uploadByUuid(CategoryEnum.META, viewId, metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)viewMeta).getBytes(StandardCharsets.UTF_8), false);
        if (viewJsonRes.isSuccess() && viewMetaRes.isSuccess()) {
            String cacheKey = String.format("%s:%s:%s", AppContextUtil.getAppId(), formId, VIEW_PATH);
            HussarCacheUtil.evict((String)"vfg_no-code_schema", (Object)cacheKey);
            return FormDesignResponse.success((Object)true);
        }
        ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> Storage\u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> Storage\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<FormViewSchema> get(String formId) {
        String cacheKey;
        FormViewSchema settingSchema;
        String appId = AppContextUtil.getAppId();
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
        if (HussarUtils.isNotEmpty((Object)form)) {
            appId = Long.toString(form.getAppId());
        }
        if (HussarUtils.isNotEmpty((Object)(settingSchema = (FormViewSchema)HussarCacheUtil.get((String)"vfg_no-code_schema", (Object)(cacheKey = String.format("%s:%s:%s", appId, formId, VIEW_PATH)), FormViewSchema.class)))) {
            return FormDesignResponse.success((Object)settingSchema);
        }
        AppContextUtil.setAppId((String)appId);
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String viewId = formIndexMeta.getViewId();
        if (HussarUtils.isEmpty((Object)viewId)) {
            return FormDesignResponse.success(null);
        }
        AppContextUtil.setAppId((String)appId);
        StorageResult storageResult = this.storage.downloadByUuid(CategoryEnum.JSON, viewId);
        if (storageResult.isSuccess()) {
            FormViewSchema viewSource = (FormViewSchema)JSON.parseObject((byte[])((byte[])storageResult.getData()), FormViewSchema.class, (Feature[])new Feature[0]);
            if (HussarUtils.isNotEmpty((Object)form)) {
                LOGGER.info(">>>>>>>>>>>>>>>>>>>form\u4e0d\u4e3a\u7a7a:{}", (Object)JSONObject.toJSONString((Object)form));
                if (HussarUtils.isNotEmpty((Object)viewSource)) {
                    LOGGER.info(">>>>>>>>>>>>>>>>>viewSource\u4e0d\u4e3a\u7a7a:{}", (Object)JSONObject.toJSONString((Object)viewSource));
                    viewSource.setI18nKeys(form.getI18nKeys());
                }
            }
            HussarCacheUtil.put((String)"vfg_no-code_schema", (Object)cacheKey, (Object)viewSource);
            return FormDesignResponse.success((Object)viewSource);
        }
        return FormDesignResponse.success(null);
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String viewId = formIndexMeta.getViewId();
        if (HussarUtils.isEmpty((Object)viewId)) {
            return FormDesignResponse.success((Object)true);
        }
        StorageResult json = this.storage.deleteByUuid(CategoryEnum.JSON, viewId, false);
        StorageResult meta = this.storage.deleteByUuid(CategoryEnum.META, viewId, false);
        if (json.isSuccess() && meta.isSuccess()) {
            return FormDesignResponse.success((Object)true);
        }
        ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u6570\u636e\u89c6\u56fe ==> Storage\u5220\u9664\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)false, (String)"\u5220\u9664\u6570\u636e\u89c6\u56fe ==> Storage\u5220\u9664\u5931\u8d25");
    }
}

