/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SerialNumberService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumberCountVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Service
public class SerialNumberServiceImpl
implements SerialNumberService {
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private ISysCodeRuleService iSysCodeRuleService;

    public String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String url = FileUtil.posixPath((String[])new String[]{appId, formId, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }

    @Override
    public FormDesignResponse<Object> selectCount(String formId) {
        String appId = AppContextUtil.getAppId();
        HashMap params = new HashMap();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "SelectCount");
        Object data = ((ApiResponse)this.engineApiService.invokeByReturnEntity(businessId, null, params).getBody()).getData();
        if (data instanceof PageVo) {
            return FormDesignResponse.success(((PageVo)data).getData().get(0));
        }
        return FormDesignResponse.success((Object)data);
    }

    @Override
    public FormDesignResponse<String> reset(String formId) {
        FormCanvasSchema formSchema = (FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData());
        String ruleCode = formSchema.getName();
        String data = (String)this.iSysCodeRuleService.resetSerialNumber(ruleCode).getData();
        return FormDesignResponse.success((Object)data);
    }

    @Override
    public FormDesignResponse<SerialNumberCountVO> getCurrentCount(String formId) {
        FormCanvasSchema formSchema = (FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData());
        SerialNumberCountVO serialNumberCountVO = new SerialNumberCountVO();
        ApiResponse serialNumberCode = this.iSysCodeRuleService.getSerialNumberCode(formSchema.getName());
        serialNumberCountVO.setCurrent((Long)serialNumberCode.getData());
        return FormDesignResponse.success((Object)serialNumberCountVO);
    }
}

