/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganVo;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.formdesign.no.code.api.model.AuthorizationDTO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign"})
public class AuthenticationController {
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;

    @PostMapping(value={"/authorization/user/remote/lazyOrganUserTree"})
    public ApiResponse<List<OrganUserTreeVo>> lazyOrganUserTree(@RequestBody AuthorizationDTO data) {
        return ApiResponse.success((Object)this.hussarBaseUserBoService.lazyOrganUserTree(data.getParentOrganIds(), Boolean.valueOf(data.isNeedParentOrganInfo()), Integer.valueOf(data.getResultType())));
    }

    @PostMapping(value={"/authorization/user/remote/getUsersByOrganUser"})
    public ApiResponse<List<UserVo>> getUsersByOrganUser(@RequestBody AuthorizationDTO data) {
        return ApiResponse.success((Object)this.hussarBaseUserBoService.getUsersByOrganUser(data.getOrganIds(), data.getUserIds()));
    }

    @PostMapping(value={"authorization/permit/user/searchUser"})
    public ApiResponse<Page<SearchUserTreeVo>> searchUser(@RequestBody AuthorizationDTO data) {
        return ApiResponse.success((Object)this.hussarBaseUserBoService.searchUser(data.getPageInfo(), data.getSearchOrganUserDto()));
    }

    @PostMapping(value={"authorization/organ/searchOrgan"})
    public ApiResponse<Page<SearchOrganVo>> searchOrgan(@RequestBody AuthorizationDTO data) {
        return ApiResponse.success((Object)this.hussarBaseOrganizationBoService.searchOrgan(data.getPageInfo(), data.getSearchOrganUserDto()));
    }

    @GetMapping(value={"authorization/organ/remote/getAllSubOrgan"})
    public ApiResponse<List<OrganVo>> getAllSubOrgan(@RequestParam long organId) {
        return ApiResponse.success((Object)this.hussarBaseOrganizationBoService.getAllSubOrgan(Long.valueOf(organId)));
    }

    @GetMapping(value={"authorization/user/remote/getUserAndStaffInfo"})
    public ApiResponse<UserStaffVo> getUserAndStaffInfo(@RequestParam long userId) {
        return ApiResponse.success((Object)this.hussarBaseUserBoService.getUserAndStaffInfo(Long.valueOf(userId)));
    }

    @GetMapping(value={"authorization/user/remote/findOrganizationsByIds"})
    public ApiResponse<List<OrganizationBo>> findOrganizationsByIds(@RequestParam List<Long> ids) {
        return ApiResponse.success((Object)this.hussarBaseOrganizationBoService.findOrganizationsByIds(ids));
    }
}

