/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataitem.reference.QuoteBO;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.formcheck.ELFormCheckAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.runner.formcheck.FormCheckInfo;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StepVoidVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/step/el_step.ftl");
        Map dataParams = lcdpComponent.getRenderParamsToBind();
        this.renderData(lcdpComponent, ctx, dataParams);
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMethods(lcdpComponent, ctx, dataParams);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException {
        List tabList = JSON.parseArray((String)lcdpComponent.getProps().get("tabList").toString(), HashMap.class);
        String instanceKey = lcdpComponent.getInstanceKey();
        lcdpComponent.addRenderParam("tabs", (Object)tabList);
        lcdpComponent.addRenderParam("id", (Object)instanceKey);
        if (!lcdpComponent.getProps().get("stepSpace").toString().isEmpty()) {
            ctx.addData(instanceKey + "StepSpace: " + lcdpComponent.getProps().get("stepSpace").toString());
        } else {
            ctx.addData(instanceKey + "StepSpace: ''");
        }
        String activeTab = lcdpComponent.getProps().get("activeTab").toString();
        int activeStep = 0;
        for (int i = 0; i < tabList.size(); ++i) {
            if (!ToolUtil.isNotEmpty(((HashMap)tabList.get(i)).get("slotName")) || !((HashMap)tabList.get(i)).get("slotName").toString().equals(activeTab)) continue;
            activeStep = i;
        }
        ctx.addData(instanceKey + "ActiveStep: " + activeStep);
        ctx.addData(instanceKey + "DefaultTab: '" + activeTab + "'");
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        ctx.addData(lcdpComponent.getInstanceKey() + "TabList: " + lcdpComponent.getProps().get("tabList").toString());
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderMethods(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws Exception {
        ArrayList<String> params = new ArrayList<String>();
        params.add("jump");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("instanceKey", lcdpComponent.getInstanceKey());
        List tabList = JSON.parseArray((String)lcdpComponent.getProps().get("tabList").toString(), HashMap.class);
        dataMap.put("tabList", tabList);
        HashMap slotFlied = new HashMap();
        HashMap<String, String> slotForm = new HashMap<String, String>();
        for (HashMap tab : tabList) {
            String formId = tab.get("formVerifyId").toString();
            ArrayList<String> fliedNames = new ArrayList<String>();
            if (ToolUtil.isNotEmpty((Object)formId)) {
                List components;
                slotForm.put(tab.get("slotName").toString(), formId);
                LcdpComponent form = (LcdpComponent)ctx.getComponentMap().get(formId);
                HashMap<String, String> nexus = new HashMap<String, String>();
                List<JSONObject> checkRule = this.renderCheckRule(form, ctx);
                for (JSONObject rule : checkRule) {
                    if (!ToolUtil.isNotEmpty((Object)rule.get((Object)"verifyKeys"))) continue;
                    List verify = (List)rule.get((Object)"verifyKeys");
                    for (String s : verify) {
                        nexus.put(s.toString(), rule.get((Object)"field").toString());
                    }
                }
                ArrayList slotNexus = new ArrayList();
                if (ToolUtil.isNotEmpty((Object)lcdpComponent.getChildrenComponents()) && ToolUtil.isNotEmpty((Object)(components = (List)lcdpComponent.getChildrenComponents().get(tab.get("slotName"))))) {
                    for (LcdpComponent lcdp : components) {
                        String key = lcdp.getInstanceKey();
                        String flied = (String)nexus.get(key);
                        fliedNames.add(flied);
                    }
                }
            }
            if (!ToolUtil.isNotEmpty(fliedNames)) continue;
            slotFlied.put(tab.get("slotName").toString(), fliedNames);
        }
        dataMap.put("slotFlied", slotFlied);
        dataMap.put("slotForm", slotForm);
        ctx.addMethod(lcdpComponent.getInstanceKey() + "JumpMethod", params, RenderUtil.renderTemplate((String)"/template/elementui/element/step/el_step_jump_method.ftl", dataMap));
    }

    private List<JSONObject> renderCheckRule(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List elFormCheckAnalyses;
        ArrayList<JSONObject> checkFunctions = new ArrayList<JSONObject>();
        Object formCheckInfo = lcdpComponent.getProps().get("formCheck");
        if (ToolUtil.isNotEmpty(formCheckInfo) && (elFormCheckAnalyses = (List)JSON.parseObject((String)JSON.toJSONString(formCheckInfo), (TypeReference)new TypeReference<List<ELFormCheckAnalysis>>(){}, (Feature[])new Feature[0])).size() > 0) {
            Map formCheckMap = FormCheckInfo.formCheckMap;
            for (ELFormCheckAnalysis elFormCheckAnalysis : elFormCheckAnalyses) {
                JSONObject singleFunc = new JSONObject();
                HashMap<String, Object> ruleMap = new HashMap<String, Object>();
                ArrayList formCheckObjects = new ArrayList();
                ruleMap.put("checkList", formCheckObjects);
                ruleMap.put("field", elFormCheckAnalysis.getCheckFormCol());
                JSONArray componentCols = (JSONArray)lcdpComponent.getProps().get("component_cols");
                for (Object col : componentCols) {
                    if (!elFormCheckAnalysis.getCheckFormCol().equals(((JSONObject)col).getString("field"))) continue;
                    singleFunc.put("id", (Object)((JSONObject)col).getString("id"));
                }
                Map<String, List<String>> referComponents = this.dealAllComponentReference(lcdpComponent, ctx);
                if (ToolUtil.isNotEmpty(referComponents) && ToolUtil.isNotEmpty(referComponents.get(elFormCheckAnalysis.getCheckFormCol()))) {
                    singleFunc.put("verifyKeys", referComponents.get(elFormCheckAnalysis.getCheckFormCol()));
                }
                singleFunc.put("field", (Object)elFormCheckAnalysis.getCheckFormCol());
                checkFunctions.add(singleFunc);
            }
        }
        return checkFunctions;
    }

    private Map<String, List<String>> dealAllComponentReference(LcdpComponent formComponent, Ctx ctx) {
        HashMap<String, List<String>> resMap = new HashMap<String, List<String>>();
        if (ToolUtil.isNotEmpty((Object)ctx.getComponentMap())) {
            ctx.getComponentMap().values().forEach(curComponent -> {
                if (ToolUtil.isNotEmpty((Object)curComponent.getProps()) && ToolUtil.isNotEmpty(curComponent.getProps().get("reference"))) {
                    JSONArray quotes = (JSONArray)curComponent.getProps().get("reference");
                    ValueVisitor quoteVisitor = (ValueVisitor)formComponent.getProvideVisitor("value");
                    try {
                        formComponent.accept((BaseProvideVisitor)quoteVisitor, ctx, null);
                        Map colMappings = quoteVisitor.getComponentColMapping();
                        List quoteBOS = JSON.parseArray((String)quotes.toJSONString(), QuoteBO.class);
                        if (ToolUtil.isNotEmpty((Object)quoteBOS)) {
                            quoteBOS.forEach(quoteBO -> {
                                String quoteKey;
                                if (ToolUtil.isNotEmpty((Object)quoteBO.getComponentQuote()) && ToolUtil.isNotEmpty((Object)quoteBO.getComponentQuote().getInstanceKey()) && (quoteKey = quoteBO.getComponentQuote().getInstanceKey()).equals(formComponent.getInstanceKey()) && quoteBO.getComponentQuote().getInstanceData().size() == 2) {
                                    String fieldId = (String)quoteBO.getComponentQuote().getInstanceData().get(1);
                                    String field = (String)colMappings.get(fieldId);
                                    if (ToolUtil.isEmpty(resMap.get(field))) {
                                        resMap.put(field, new ArrayList());
                                    }
                                    ((List)resMap.get(field)).add(curComponent.getInstanceKey());
                                }
                            });
                        }
                    }
                    catch (LcdpException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return resMap;
    }
}

