/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataitem.reference.QuoteBO;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.defaultvalue.DefaultValueAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.DefaultValueUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JxdDateTimePickerVoidVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/jxd_date_time_picker/el_date_picker.ftl");
        ctx.addComponent("JxdDateTimePicker");
        ctx.addImports("import JxdDateTimePicker from '@/components/JxdDateTimePicker/picker/date-picker'");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        String type = "yyyy".equals(lcdpComponent.getProps().get("select")) ? "year" : ("yyyy-MM".equals(lcdpComponent.getProps().get("select")) ? "month" : ("yyyy-MM-dd".equals(lcdpComponent.getProps().get("select")) ? "date" : ("HH:mm:ss".equals(lcdpComponent.getProps().get("select")) ? "time" : "datetime")));
        lcdpComponent.addRenderParam("type", (Object)type);
        this.renderAttr(lcdpComponent, ctx);
        this.renderMounted(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethods(lcdpComponent, ctx);
    }

    private void renderAttr(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderMethods(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        HashMap params = new HashMap();
        if (!ctx.getMethods().containsKey("format")) {
            ArrayList<String> param = new ArrayList<String>();
            param.add("data");
            param.add("type");
            ctx.addMethod("format", param, RenderUtil.renderTemplate((String)"/template/elementui/element/jxd_date_time_picker/initDate.ftl", params));
        }
    }

    private void renderMounted(LcdpComponent lcdpComponent, Ctx ctx) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormMounted(lcdpComponent, ctx);
        if (lcdpComponent.getProps().get("readonly") != null) {
            String instanceKey = lcdpComponent.getInstanceKey();
            String isReadonly = instanceKey + "Readonly";
            lcdpComponent.addAttr(":class", isReadonly + " ? 'jxd_ins_elDateTimePickerReadonly' : ''");
        }
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        ComponentDataUtil.ComponentValueStatusEnum dataItemStartDateStatus = ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("startDate"));
        ComponentDataUtil.ComponentValueStatusEnum dataItemEndDateStatus = ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("endDate"));
        Boolean isRange = (Boolean)lcdpComponent.getProps().get("isRange");
        Boolean isDefaultValue = null;
        Boolean isEndDefaultValue = null;
        JSONObject defaults = (JSONObject)lcdpComponent.getProps().get("defaults");
        JSONObject endDefaults = (JSONObject)lcdpComponent.getProps().get("endDefaults");
        if (ToolUtil.isNotEmpty((Object)defaults)) {
            isDefaultValue = defaults.getBoolean("isDefaultValue");
            if ("system".equals(defaults.getString("defaultValueType")) && "time".equals(defaults.getString("value"))) {
                defaults.put("value", (Object)"datetime");
            }
        }
        if (ToolUtil.isNotEmpty((Object)endDefaults)) {
            isEndDefaultValue = endDefaults.getBoolean("isDefaultValue");
            if ("system".equals(endDefaults.getString("defaultValueType")) && "time".equals(endDefaults.getString("value"))) {
                endDefaults.put("value", (Object)"datetime");
            }
        }
        String valueData = "";
        if (ToolUtil.isNotEmpty((Object)isRange) && isRange.booleanValue()) {
            if (ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)dataItemStartDateStatus) && ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)dataItemEndDateStatus)) {
                valueData = lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
                if (ToolUtil.isNotEmpty((Object)isDefaultValue) && isDefaultValue.booleanValue() && ToolUtil.isNotEmpty((Object)isEndDefaultValue) && isEndDefaultValue.booleanValue()) {
                    DefaultValueAnalysis defaultValueAnalysis = (DefaultValueAnalysis)JSON.parseObject((String)defaults.toJSONString(), DefaultValueAnalysis.class);
                    DefaultValueAnalysis endDefaultValueAnalysis = (DefaultValueAnalysis)JSON.parseObject((String)endDefaults.toJSONString(), DefaultValueAnalysis.class);
                    String defaultValue = DefaultValueUtil.renderDefaultValue((DefaultValueAnalysis)defaultValueAnalysis, (String)"string", (Ctx)ctx);
                    String endDefaultValue = DefaultValueUtil.renderDefaultValue((DefaultValueAnalysis)endDefaultValueAnalysis, (String)"string", (Ctx)ctx);
                    ctx.addData(valueData + ": [" + defaultValue + ", " + endDefaultValue + "]");
                } else {
                    ctx.addData(valueData + ": ''");
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("instanceKey", lcdpComponent.getInstanceKey());
                ctx.addComputedWithGetSet(lcdpComponent.getInstanceKey() + "StartDate", RenderUtil.renderTemplate((String)"/template/elementui/element/jxd_date_time_picker/date_picker_start_data.ftl", params));
                ctx.addComputedWithGetSet(lcdpComponent.getInstanceKey() + "EndDate", RenderUtil.renderTemplate((String)"/template/elementui/element/jxd_date_time_picker/date_picker_end_data.ftl", params));
            } else {
                valueData = lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
                String startDate = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)"StartDate", Collections.singletonList("startDate"), (String)"null");
                String endDate = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)"EndDate", Collections.singletonList("endDate"), (String)"null");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("startDate", startDate);
                params.put("endDate", endDate);
                boolean startDateGetValue = ComponentDataUtil.ComponentValueStatusEnum.GET_VALUE.equals((Object)dataItemStartDateStatus);
                boolean endDateGetValue = ComponentDataUtil.ComponentValueStatusEnum.GET_VALUE.equals((Object)dataItemEndDateStatus);
                params.put("startDateGetValue", startDateGetValue);
                params.put("endDateGetValue", endDateGetValue);
                params.put("instanceKey", lcdpComponent.getInstanceKey());
                this.dealList(lcdpComponent, ctx, params);
                ctx.addComputedWithGetSet(valueData, RenderUtil.renderTemplate((String)"/template/elementui/element/jxd_date_time_picker/date_picker_computed.ftl", params));
            }
        } else {
            valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)"null");
        }
        lcdpComponent.addRenderParam("referData", (Object)valueData);
        if (valueData.indexOf(".") != -1) {
            lcdpComponent.addAttr(valueData.split("\\.")[1], lcdpComponent.getProps().get("select").toString());
        } else {
            lcdpComponent.addAttr(lcdpComponent.getInstanceKey(), lcdpComponent.getProps().get("select").toString());
        }
    }

    private void dealList(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) throws LcdpException {
        String startQuoteListKey = this.isQuoteFromList(lcdpComponent, ctx, "startDate");
        String endQuoteListKey = this.isQuoteFromList(lcdpComponent, ctx, "endDate");
        String listKey = "";
        if (ToolUtil.isNotEmpty((Object)startQuoteListKey)) {
            params.put("startListKey", startQuoteListKey);
            String startDate = (String)params.get("startDate");
            params.put("startField", startDate.substring(startDate.indexOf(46) + 1));
            listKey = startQuoteListKey;
        }
        if (ToolUtil.isNotEmpty((Object)endQuoteListKey)) {
            params.put("endListKey", endQuoteListKey);
            String endDate = (String)params.get("endDate");
            params.put("endField", endDate.substring(endDate.indexOf(46) + 1));
            listKey = endQuoteListKey;
        }
        if (ToolUtil.isNotEmpty((Object)listKey)) {
            lcdpComponent.addRenderParam("listKey", (Object)listKey);
            ctx.addMethod(lcdpComponent.getInstanceKey() + "DataInput", Arrays.asList("value", listKey + "Item"), RenderUtil.renderTemplate((String)"/template/elementui/element/jxd_date_time_picker/date_picker_input.ftl", params));
        }
    }

    private String isQuoteFromList(LcdpComponent lcdpComponent, Ctx ctx, String dataItem) throws LcdpException {
        ComponentDataUtil.ComponentValueStatusEnum status = ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList(dataItem));
        if (ComponentDataUtil.ComponentValueStatusEnum.QUOTE.equals((Object)status)) {
            QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote((LcdpComponent)lcdpComponent, Collections.singletonList(dataItem));
            assert (quoteBO != null);
            String quoteInstanceKey = quoteBO.getComponentQuote().getInstanceKey();
            if ("com.jxdinfo.nanruielement.JXDElList".equals(((LcdpComponent)ctx.getComponentMap().get(quoteInstanceKey)).getName())) {
                return quoteInstanceKey;
            }
        }
        return null;
    }
}

