/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataitem.reference.QuoteBO;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DateTimeRangeVoidVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/dateTimeRange/el_date_picker.ftl");
        ctx.addComponent("JxdDatePicker");
        ctx.addImports("import JxdDatePicker from '@/components/JxdDatePicker/JxdDatePicker'");
        Map dataParams = lcdpComponent.getRenderParamsToBind();
        this.renderWatch(lcdpComponent, ctx, dataParams);
        this.renderData(lcdpComponent, ctx, dataParams);
        this.renderAttrs(lcdpComponent, ctx);
        this.renderAction(lcdpComponent, ctx, dataParams);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException {
        String defaultValue = "{}";
        if (ToolUtil.isNotEmpty((Object)dataParams.get("fromArray"))) {
            defaultValue = "[]";
        }
        String valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("data"), (String)defaultValue);
        if (!(lcdpComponent.getInstanceKey() + "Data").equals(valueData)) {
            ctx.addData(lcdpComponent.getInstanceKey() + "Data:" + defaultValue);
        }
        lcdpComponent.addRenderParam("valueData", (Object)valueData);
    }

    private void renderWatch(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException {
        String startTime = this.getComponentDataRender(lcdpComponent, ctx, CodeSuffix._DATA.getType(), Collections.singletonList("startTime"), dataParams);
        String endTime = this.getComponentDataRender(lcdpComponent, ctx, CodeSuffix._DATA.getType(), Collections.singletonList("endTime"), dataParams);
        if (ToolUtil.isNotEmpty((Object)dataParams.get("fromData"))) {
            startTime = dataParams.get("fromData") + "[index]" + startTime;
            endTime = dataParams.get("fromData") + "[index]" + endTime;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(dataParams);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        ctx.addWatch(lcdpComponent.getInstanceKey() + "Data", Collections.singletonList("data"), RenderUtil.renderTemplate((String)"/template/elementui/element/dateTimeRange/dateTimeRange_watch.ftl", params));
    }

    private void renderAction(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>(dataParams);
        String startTime = this.getComponentDataRender(lcdpComponent, ctx, CodeSuffix._DATA.getType(), Collections.singletonList("startTime"), dataParams);
        String endTime = this.getComponentDataRender(lcdpComponent, ctx, CodeSuffix._DATA.getType(), Collections.singletonList("endTime"), dataParams);
        if (ToolUtil.isNotEmpty((Object)dataParams.get("fromData"))) {
            startTime = "item" + startTime;
            endTime = "item" + endTime;
        }
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        ctx.addMethod(lcdpComponent.getInstanceKey() + "DateTimeRangeEcho", RenderUtil.renderTemplate((String)"/template/elementui/element/dateTimeRange/dateTimeRange_echo_method.ftl", params));
    }

    private String getComponentDataRender(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems, Map<String, Object> dataParams) throws LcdpException {
        if (ToolUtil.isEmpty(dataItems)) {
            dataItems.add("value");
        }
        if (ComponentDataUtil.ComponentValueStatusEnum.QUOTE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, dataItems))) {
            QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote((LcdpComponent)lcdpComponent, dataItems);
            HashMap<String, List<List<String>>> quoteMap = new HashMap<String, List<List<String>>>();
            ArrayList<List<String>> dataItemList = new ArrayList<List<String>>();
            dataItemList.add(dataItems);
            quoteMap.put(lcdpComponent.getInstanceKey(), dataItemList);
            if (DateTimeRangeVoidVisitor.judgeCircleQuote(quoteBO, ctx, quoteMap)) {
                ComponentData quoteData;
                LcdpComponent quoteComponent = (LcdpComponent)ctx.getComponentMap().get(quoteBO.getComponentQuote().getInstanceKey());
                ValueVisitor quoteVisitor = (ValueVisitor)quoteComponent.getProvideVisitor("value");
                quoteComponent.accept((BaseProvideVisitor)quoteVisitor, ctx, null);
                List param = quoteBO.getComponentQuote().getInstanceData();
                if (param.size() == 2 && ComponentData.DataTypeEnum.ARRAY_OBJECT.equals((Object)(quoteData = quoteVisitor.getDataItemValue(Collections.singletonList(param.get(0)))).getDataType()) && ToolUtil.isNotEmpty(param.get(1))) {
                    dataParams.put("fromArray", true);
                    lcdpComponent.addRenderParam("fromArray", (Object)true);
                    String paramValue = quoteVisitor.getDataItemValue(param).getRenderValue();
                    dataParams.put("fromData", quoteVisitor.getDataItemValue(null).getRenderValue());
                    return paramValue.substring(paramValue.indexOf("."));
                }
                return quoteVisitor.getDataItemValue(param).getRenderValue();
            }
        }
        return CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + suffix + "." + dataItems.get(0);
    }

    private static boolean judgeCircleQuote(QuoteBO quoteBO, Ctx ctx, Map<String, List<List<String>>> quoteMap) throws LcdpException {
        List<List<String>> dataItemList;
        LcdpComponent quoteComponent = (LcdpComponent)ctx.getComponentMap().get(quoteBO.getComponentQuote().getInstanceKey());
        List quoteDataItems = quoteBO.getComponentQuote().getInstanceData();
        boolean keyInMap = quoteMap.containsKey(quoteComponent.getInstanceKey());
        if (keyInMap && ToolUtil.isNotEmpty(dataItemList = quoteMap.get(quoteComponent.getInstanceKey()))) {
            for (List<String> item : dataItemList) {
                if (!item.equals(quoteDataItems)) continue;
                return false;
            }
        }
        if (ComponentDataUtil.ComponentValueStatusEnum.QUOTE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)quoteComponent, (Ctx)ctx, (List)quoteDataItems))) {
            if (keyInMap) {
                quoteMap.get(quoteComponent.getInstanceKey()).add(quoteDataItems);
            } else {
                ArrayList<List> dataItems = new ArrayList<List>();
                dataItems.add(quoteDataItems);
                quoteMap.put(quoteComponent.getInstanceKey(), dataItems);
            }
            QuoteBO nextQuoteBO = ComponentDataUtil.getComponentDataItemQuote((LcdpComponent)quoteComponent, (List)quoteDataItems);
            return DateTimeRangeVoidVisitor.judgeCircleQuote(nextQuoteBO, ctx, quoteMap);
        }
        return true;
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealDisabledAttr(lcdpComponent, ctx);
    }
}

