const xResult = [];
const inResult = [];
const outResult = [];
const result = [];
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
if (oldTitle) {
const titleLength = oldTitle.length;
const provideLength = numberOfRow;
const rowNumber = Math.ceil(titleLength / provideLength);
if (titleLength > provideLength) {
for (let i = 0; i < rowNumber; i++) {
let tempStr = ' ';
const start = i * provideLength;
const end = start + provideLength;
if (i === rowNumber - 1) {
tempStr = oldTitle.substring(start, titleLength);
} else {
tempStr = oldTitle.substring(start, end)+'\n';
}
newTitle += tempStr;
}
} else {
newTitle = oldTitle;
}
}
const echatrsTitle = {
text: newTitle,
textStyle: {
color: '${titleColor!}',
fontSize: '${titleFontSize!}',
fontFamily: '${fontFamily!}',
fontWeight: '${fontWeight!}',
fontStyle: '${fontStyle!}',
},
left: '${titleAlign!}',
};
const echatrsTooltip = {
formatter: '{b} : {c} ({d}%)',
trigger: 'item',
backgroundColor: '${tooltipBgColor!}',
textStyle: {
color: '${toolColor!}',
fontSize: '${toolFontSize!}',
fontFamily: '${toolFontFamily!}',
fontWeight: '${toolFontWeight!}',
fontStyle: '${toolFontStyle!}',
},
};
const textStyle = {
color: '${legendColor!}',
fontSize: '${legendFontSize!}',
fontFamily: '${legendFontFamily!}',
fontWeight: '${legendFontWeight!}',
fontStyle: '${legendFontStyle!}',
};
${optionData!}.xAxisData.forEach((col,index)=>{
result.push({
name: col,
value: ${optionData!}.seriesData[index],
});
});
if(result.length !== 0) {
const inName = result[0].name.split(",");
const inValue = result[0].value.split(",");
const outName = result[1].name.split(",");
const outValue = result[1].value.split(",");
for (let m = 0; m < inName.length; m++) {
inResult.push({
name: inName[m],
value: inValue[m],
});
}
for (let n = 0; n < outName.length; n++) {
outResult.push({
name: outName[n],
value: outValue[n],
});
}
}
return {
title: echatrsTitle,
tooltip: echatrsTooltip,
legend: {
<#if (isShowFlag?? && isShowFlag)>
    show: true,
<#elseif (!isShowFlag?? || !isShowFlag)>
    show: false,
</#if>
left: '${legendLocation!}',
textStyle: textStyle,
bottom: 10,
},
series: [
{
radius: [0, '20%'],
type: 'pie',
label: {
position: 'inner',
},
selectedMode: 'single',
data: inResult,
},{
radius: ['30%', '45%'],
type: 'pie',
selectedMode: 'single',
labelLine: {
length: 0,
},
label: {
formatter: '{b|{b}：}{c}  {per|{d}%}  ',
backgroundColor: '#eee',
borderColor: '#aaa',
borderWidth: 0.5,
borderRadius: 4,
rich: {
a: {
color: '#999',
lineHeight: 18,
align: 'center',
fontSize: 8,
},
hr: {
borderColor: '#aaa',
width: '100%',
borderWidth: 0.5,
height: 0,
fontSize: 8,
},
b: {
fontSize: 8,
lineHeight: 33,
},
per: {
color: '#eee',
fontSize: 8,
backgroundColor: '#334455',
padding: [2, 2],
borderRadius: 1,
},
},
},
data:  outResult,
},
],
}