/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.uniui.vistor;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RadarEchartsVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/uniui/uni/radarecharts/el_radarEcharts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) {
        String instanceKey = lcdpComponent.getInstanceKey();
        Integer height = lcdpComponent.getHeight();
        Integer width = lcdpComponent.getWidth();
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderTop"))) {
            String borderTop = String.valueOf(lcdpComponent.getStyles().get("borderTop"));
            ctx.addData(instanceKey + "BorderTop: " + borderTop.substring(0, borderTop.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderBottom"))) {
            String borderBottom = String.valueOf(lcdpComponent.getStyles().get("borderBottom"));
            ctx.addData(instanceKey + "BorderBottom: " + borderBottom.substring(0, borderBottom.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderLeft"))) {
            String borderLeft = String.valueOf(lcdpComponent.getStyles().get("borderLeft"));
            ctx.addData(instanceKey + "BorderLeft: " + borderLeft.substring(0, borderLeft.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderRight"))) {
            String borderRight = String.valueOf(lcdpComponent.getStyles().get("borderRight"));
            ctx.addData(instanceKey + "BorderRight: " + borderRight.substring(0, borderRight.indexOf("px")));
        }
        ctx.addData(instanceKey + "Height: " + height);
        ctx.addData(instanceKey + "Width: " + width);
        ctx.addData(instanceKey + "Data: null");
    }

    private void setParamValue(Map<String, Object> params, Map<String, Object> maps) {
        params.put("titleText", maps.get("title"));
        params.put("titleColor", ToolUtil.isNotEmpty((Object)maps.get("titleColor")) ? maps.get("titleColor") : "#000");
        params.put("titleFontSize", ToolUtil.isNotEmpty((Object)maps.get("titleFontSize")) ? maps.get("titleFontSize") : "18");
        params.put("fontFamily", maps.get("fontFamily"));
        params.put("fontWeight", maps.get("fontWeight"));
        params.put("titleAlign", maps.get("titleAlign"));
        params.put("titleVerticalAlign", maps.get("titleVerticalAlign"));
        params.put("titleBackgroundColor", ToolUtil.isNotEmpty((Object)maps.get("titleBackgroundColor")) ? maps.get("titleBackgroundColor") : "transparent");
        params.put("titleLeft", maps.get("titleLeft"));
        params.put("titleTop", maps.get("titleTop"));
        params.put("tooltipBgColor", maps.get("tooltipBgColor"));
        params.put("toolColor", ToolUtil.isNotEmpty((Object)maps.get("toolColor")) ? maps.get("toolColor") : "#666");
        params.put("toolFontSize", ToolUtil.isNotEmpty((Object)maps.get("toolFontSize")) ? maps.get("toolFontSize") : "12");
        params.put("toolFontFamily", maps.get("toolFontFamily"));
        params.put("toolFontWeight", maps.get("toolFontWeight"));
        params.put("toolFontStyle", maps.get("toolFontStyle"));
        params.put("toolLineHeight", maps.get("toolLineHeight"));
        params.put("toolShow", Optional.ofNullable(maps.get("toolShow")).orElse(false));
        params.put("toolPaddingTop", ToolUtil.isNotEmpty((Object)maps.get("toolPaddingTop")) ? maps.get("toolPaddingTop") : "10");
        params.put("toolPaddingLeft", ToolUtil.isNotEmpty((Object)maps.get("toolPaddingLeft")) ? maps.get("toolPaddingLeft") : "10");
        params.put("toolShadow", maps.get("toolShadow"));
        params.put("axisLineColor", Optional.ofNullable(maps.get("axisLineColor")).orElse("#E1E1E1"));
        params.put("axisLineType", maps.get("axisLineType"));
        params.put("axisLineWidth", ToolUtil.isNotEmpty((Object)maps.get("axisLineWidth")) ? maps.get("axisLineWidth") : "1");
        params.put("axisTickShow", Optional.ofNullable(maps.get("axisTickShow")).orElse(false));
        params.put("axisTickLength", maps.get("axisTickLength"));
        params.put("axisLabelShow", Optional.ofNullable(maps.get("axisLabelShow")).orElse(false));
        params.put("axisLabelMargin", ToolUtil.isNotEmpty((Object)maps.get("axisLabelMargin")) ? maps.get("axisLabelMargin") : "8");
        params.put("axisLabelColor", maps.get("axisLabelColor"));
        params.put("axisLabelFontFamily", maps.get("axisLabelFontFamily"));
        params.put("axisLabelFontSize", ToolUtil.isNotEmpty((Object)maps.get("axisLabelFontSize")) ? maps.get("axisLabelFontSize") : "12");
        params.put("splitLineColor", Optional.ofNullable(maps.get("splitLineColor")).orElse("#E1E1E1"));
        params.put("splitLineWidth", Optional.ofNullable(maps.get("splitLineWidth")).orElse(1));
        params.put("splitLineType", ToolUtil.isNotEmpty((Object)maps.get("splitLineType")) ? maps.get("splitLineType") : "solid");
        params.put("splitAreaShow", Optional.ofNullable(maps.get("splitAreaShow")).orElse(false));
        params.put("splitAreaColorOne", ToolUtil.isNotEmpty((Object)maps.get("splitAreaColorOne")) ? maps.get("splitAreaColorOne") : "#ffffff");
        params.put("splitAreaColorTwo", ToolUtil.isNotEmpty((Object)maps.get("splitAreaColorTwo")) ? maps.get("splitAreaColorTwo") : "#ffffff");
        params.put("splitAreaOpacity", Optional.ofNullable(maps.get("splitAreaOpacity")).orElse(1));
        params.put("radarShape", maps.get("radarShape"));
        params.put("splitNumber", Optional.ofNullable(maps.get("splitNumber")).orElse(5));
        params.put("isShowName", Optional.ofNullable(maps.get("isShowName")).orElse(false));
        params.put("indicatorNameGap", maps.get("indicatorNameGap"));
        params.put("indicatorNameColor", ToolUtil.isNotEmpty((Object)maps.get("indicatorNameColor")) ? maps.get("indicatorNameColor") : "#666666");
        params.put("indicatorNameFontSize", maps.get("indicatorNameFontSize"));
        params.put("indicatorNameFontFamily", maps.get("indicatorNameFontFamily"));
        params.put("indicatorNameFontWeight", maps.get("indicatorNameFontWeight"));
        params.put("isShowFlag", Optional.ofNullable(maps.get("isShowFlag")).orElse(false));
        params.put("legendLocation", ToolUtil.isNotEmpty((Object)maps.get("legendLocation")) ? maps.get("legendLocation") : "center");
        params.put("legendColor", ToolUtil.isNotEmpty((Object)maps.get("legendColor")) ? maps.get("legendColor") : "#999999");
        params.put("legendFontSize", ToolUtil.isNotEmpty((Object)maps.get("legendFontSize")) ? maps.get("legendFontSize") : "14");
        params.put("legendFontFamily", maps.get("legendFontFamily"));
        params.put("legendFontWeight", maps.get("legendFontWeight"));
        params.put("legendFontStyle", maps.get("legendFontStyle"));
        params.put("itemIcon", maps.get("itemIcon"));
        params.put("itemWidth", Optional.ofNullable(maps.get("itemWidth")).orElse(22));
        params.put("itemHeight", Optional.ofNullable(maps.get("itemHeight")).orElse(10));
        params.put("itemGap", Optional.ofNullable(maps.get("itemGap")).orElse(30));
        params.put("itemOrient", ToolUtil.isNotEmpty((Object)maps.get("itemOrient")) ? maps.get("itemOrient") : "horizontal");
        params.put("itemInactiveColor", maps.get("itemInactiveColor"));
        params.put("symbolIcon", ToolUtil.isNotEmpty((Object)maps.get("symbolIcon")) ? maps.get("symbolIcon") : "none");
        params.put("symbolIconSize", maps.get("symbolIconSize"));
        params.put("topicColorStr", maps.get("topicColor").toString());
    }

    private void setDataModel(Map<String, Object> params, DataSModelAnalysis dataModelAnalysis, LcdpComponent lcdpComponent, Ctx ctx) throws IOException, LcdpException {
        DataSConditionAnalysis dataConditionAnalysis = dataModelAnalysis.getCondition();
        Map dataFieldAnalysisMap = dataModelAnalysis.getFields();
        String labelField = "";
        String valueField = "";
        String maxField = "";
        String groupField = "";
        if (ToolUtil.isNotEmpty((Object)dataFieldAnalysisMap)) {
            for (Map.Entry fieldList : dataFieldAnalysisMap.entrySet()) {
                List fieldAnalyses = (List)fieldList.getValue();
                for (DataSFieldAnalysis dataFieldAnalysis : fieldAnalyses) {
                    String dataItemValue;
                    List dataItemPath = dataFieldAnalysis.getDataItemPath();
                    if (!ToolUtil.isNotEmpty((Object)dataItemPath)) continue;
                    switch (dataItemValue = (String)dataItemPath.get(dataItemPath.size() - 1)) {
                        case "label": {
                            labelField = dataFieldAnalysis.getFieldName();
                            break;
                        }
                        case "value": {
                            valueField = dataFieldAnalysis.getFieldName();
                            break;
                        }
                        case "group": {
                            groupField = dataFieldAnalysis.getFieldName();
                            break;
                        }
                        case "maxNum": {
                            maxField = dataFieldAnalysis.getFieldName();
                            break;
                        }
                    }
                }
            }
        }
        if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField) && ToolUtil.isNotEmpty((Object)groupField) && ToolUtil.isNotEmpty((Object)maxField)) {
            String sortConditionName;
            DataSortConditionAnalysis dataSortConditionAnalysis;
            String querySelectionName;
            List conditionList;
            String operationName = "hussarQuery";
            String apiFileName = "";
            String apiFilePath = "";
            String dataModelId = dataModelAnalysis.getDataModelId();
            if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
                apiFileName = fileMappingService.getFileName(dataModelId);
                apiFilePath = fileMappingService.getImportPath(dataModelId);
            }
            if (ToolUtil.isNotEmpty((Object)dataConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataConditionAnalysis.getQueryConditionModelList()))) {
                params.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                params.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
            }
            if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataConditionAnalysis.getSelectCondition()))) {
                operationName = operationName + querySelectionName;
            }
            if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                operationName = operationName + sortConditionName;
            }
            if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
            }
            params.put("importName", apiFileName);
            params.put("importMethod", operationName);
            params.put("axisCols", labelField);
            params.put("seriesCols", valueField);
            params.put("maxValue", maxField);
            params.put("groupValue", groupField);
        }
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        Map maps;
        HashMap<String, Object> params = new HashMap<String, Object>(100);
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        String optionData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION_DATA.getType(), Collections.singletonList("data"), (String)"{\nitemName: [],\nitemValue: [],\nindicatorData: [],\nitemMaxValue: [],\n}");
        params.put("optionData", CodePrefix._SELF.getType() + optionData);
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            params.put("isQuoteOrGetValue", "true");
        }
        if (ToolUtil.isNotEmpty((Object)(maps = lcdpComponent.getProps()))) {
            this.setParamValue(params, maps);
            DataSAnalysis dataAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
            DataSModelAnalysis dataModelAnalysis = dataAnalysis.getDatamodel();
            if (ToolUtil.isNotEmpty((Object)dataModelAnalysis)) {
                this.setDataModel(params, dataModelAnalysis, lcdpComponent, ctx);
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addComputed(lcdpComponent.getInstanceKey() + "EchartsData", RenderUtil.renderTemplate((String)"/template/uniui/uni/radarecharts/el_radarEcharts_computed.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "EchartsData", args, RenderUtil.renderTemplate((String)"/template/uniui/uni/radarecharts/el_radarEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderBottom", args, RenderUtil.renderTemplate((String)"/template/uniui/uni/radarecharts/el_radarEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderRight", args, RenderUtil.renderTemplate((String)"/template/uniui/uni/radarecharts/el_radarEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderLeft", args, RenderUtil.renderTemplate((String)"/template/uniui/uni/radarecharts/el_radarEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderTop", args, RenderUtil.renderTemplate((String)"/template/uniui/uni/radarecharts/el_radarEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "OptionData", args, RenderUtil.renderTemplate((String)"/template/uniui/uni/radarecharts/el_radarEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Height", args, RenderUtil.renderTemplate((String)"/template/uniui/uni/radarecharts/el_radarEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Width", args, RenderUtil.renderTemplate((String)"/template/uniui/uni/radarecharts/el_radarEcharts_watch.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionItem", RenderUtil.renderTemplate((String)"/template/uniui/uni/radarecharts/el_radarEcharts_Success.ftl", params));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "OptionItem();");
        }
    }
}

