/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.cascade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.formdesign.publish.uni.UniPathStrategyService;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@ClientKind(kind="com.jxdinfo.UniPage.cascade")
public class UniVueCascadeImpl
implements ResourceCascadeVisitor {
    public static final String KIND = "com.jxdinfo.UniPage.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String parentPath = this.getMetaPath(parentId);
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        File vueFrom = new File(oldVueFilePath);
        UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextUtil.getBean(UniPathStrategyService.class);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        String rootPath = FileUtil.systemPath((String[])new String[]{pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath(), uniPathStrategy.uniPathService().getUniVueCodePath()});
        File vueTo = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (FileUtils.exists((File)vueFrom)) {
            if (!FileUtils.exists((File)vueTo)) {
                FileUtils.forceMkdir((File)vueTo);
            }
            if (newName != null && !newName.isEmpty()) {
                vueTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName + formDesignProperties.getPageSuffix(), rootPath));
                if (!FileUtils.exists((File)vueTo)) {
                    try {
                        FileUtils.copyFile((File)vueFrom, (File)vueTo, (boolean)false);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, vueFrom.getAbsolutePath());
                    }
                }
            } else {
                try {
                    FileUtils.copyFileToDirectory((File)vueFrom, (File)vueTo, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, vueFrom.getAbsolutePath());
                }
            }
        }
        this.copyAncestor(id, newId);
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String parentPath = this.getMetaPath(parentId);
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        File vueFrom = new File(oldVueFilePath);
        UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextUtil.getBean(UniPathStrategyService.class);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        String rootPath = FileUtil.systemPath((String[])new String[]{pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath(), uniPathStrategy.uniPathService().getUniVueCodePath()});
        File vueTo = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (FileUtils.exists((File)vueFrom)) {
            if (!FileUtils.exists((File)vueTo)) {
                FileUtils.forceMkdir((File)vueTo);
            }
            if (newName != null && !newName.isEmpty()) {
                vueTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName + formDesignProperties.getPageSuffix(), rootPath));
                if (!FileUtils.exists((File)vueTo)) {
                    try {
                        this.dealRouter(id, newName, parentPath, false);
                        FileUtils.moveFile((File)vueFrom, (File)vueTo);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, vueFrom.getAbsolutePath());
                    }
                }
            } else {
                try {
                    this.dealRouter(id, newName, parentPath, false);
                    FileUtils.moveFileToDirectory((File)vueFrom, (File)vueTo, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, vueFrom.getAbsolutePath());
                }
            }
        }
    }

    public void cascadeDelete(String id) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        File file = new File(oldVueFilePath);
        if (FileUtils.exists((File)file)) {
            try {
                FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
                this.dealRouter(id, null, fileMappingService.getFormatParentPath(id), true);
                FileUtils.forceDelete((File)file);
                ResourceCascadeService resourceCascadeService = (ResourceCascadeService)SpringContextUtil.getBean(ResourceCascadeService.class);
                resourceCascadeService.deleteVuePublishFile(id);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldVueFilePath);
            }
        }
    }

    String getOldVuePath(String id, Integer strategy) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextUtil.getBean(UniPathStrategyService.class);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        String oldVuePath = fileMappingService.getFormatPath(id);
        String localPrefix = FileUtil.systemPath((String[])new String[]{pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath(), uniPathStrategy.uniPathService().getUniVueCodePath()});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{oldVuePath + formDesignProperties.getPageSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getNeWVuePath(String id, String pageName, Integer strategy) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextUtil.getBean(UniPathStrategyService.class);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        String localPrefix = FileUtil.systemPath((String[])new String[]{pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath(), uniPathStrategy.uniPathService().getUniVueCodePath()});
        String newVuePath = FileUtil.systemPath((String[])new String[]{fileMappingService.getFormatParentPath(id), pageName});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{newVuePath + formDesignProperties.getPageSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    void copyAncestor(String oidId, String newId) throws IOException {
        String oldPublishPath = this.getPublishVersionFilePathById(oidId);
        String oldFilePath = this.getLastFileVersionFilePathById(oidId);
        File oldPublish = new File(oldPublishPath);
        File oldFile = new File(oldFilePath);
        File toPublish = new File(this.getPublishVersionFilePathById(newId));
        File toFile = new File(this.getLastFileVersionFilePathById(newId));
        if (FileUtils.exists((File)oldPublish) && FileUtils.exists((File)oldFile)) {
            FileUtils.copyFile((File)oldPublish, (File)toPublish, (boolean)false);
            FileUtils.copyFile((File)oldFile, (File)toFile, (boolean)false);
        }
    }

    String getPublishVersionFilePathById(String id) {
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        return FileUtil.posixPath((String[])new String[]{pathStrategy.resourcePathService().getProjectAndCodePath(), "/publish/version/ancestor", id.replace("_", "/"), "/last_publish.version"});
    }

    String getLastFileVersionFilePathById(String id) {
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        return FileUtil.posixPath((String[])new String[]{pathStrategy.resourcePathService().getProjectAndCodePath(), "/publish/version/ancestor", id.replace("_", "/"), "/last_file.version"});
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String parentPath = (String)fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }

    void dealRouter(String id, String newPageName, String newModuleRelatePath, boolean isDelete) throws IOException, LcdpException {
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String moduleRelatePath = fileMappingService.getFormatParentPath(id);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        String projectPath = pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        ResourceCascadeService resourceCascadeService = (ResourceCascadeService)SpringContextUtil.getBean(ResourceCascadeService.class);
        JSONObject jsonObject = resourceCascadeService.getJSONObject(id);
        String pageName = jsonObject.get((Object)"name").toString();
        String desc = jsonObject.get((Object)"desc").toString();
        String component = FileUtil.posixPath((String[])new String[]{AppContextUtil.posixFilePathPrefix(), "views", moduleRelatePath, pageName});
        String newComponent = FileUtil.posixPath((String[])new String[]{AppContextUtil.posixFilePathPrefix(), "views", newModuleRelatePath, ToolUtil.isNotEmpty((Object)newPageName) ? newPageName : pageName});
        String routerExport = "{\n 'path': '" + newComponent + "',\n'style': {\n'navigationBarTitleText': '" + desc + "'\n}\n}";
        this.mobileUniRouterCode(component, newComponent, routerExport, projectPath, isDelete);
    }

    private void mobileUniRouterCode(String component, String newComponent, String fileContent, String vueRootPath, boolean isDelete) throws IOException {
        String path;
        vueRootPath = FileUtil.complementFilePath((String)vueRootPath);
        String filePath = vueRootPath + "/src/pages.json";
        File file = new File(filePath);
        String fileMsg = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        JSONObject parse = JSON.parseObject((String)fileMsg, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray jsonArray = JSON.parseArray((String)parse.get((Object)"pages").toString());
        boolean type = true;
        for (Object o : jsonArray) {
            path = JSON.parseObject((String)o.toString()).get((Object)"path").toString();
            if (!path.equals(component)) continue;
            jsonArray.remove(o);
            break;
        }
        for (Object o : jsonArray) {
            path = JSON.parseObject((String)o.toString()).get((Object)"path").toString();
            if (!path.equals(newComponent)) continue;
            type = false;
            break;
        }
        if (type) {
            if (!isDelete) {
                jsonArray.add((Object)JSON.parseObject((String)fileContent));
            }
            parse.put("pages", (Object)jsonArray);
        }
        if (FileUtils.exists((File)file)) {
            if (ToolUtil.isEmpty((Object)parse)) {
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)parse), (String)"UTF-8", (boolean)false);
            }
        }
    }

    private ResourcePath mobileProject(String name, String ... pathSegments) {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String localPrefix = FileUtil.systemPath((String[])new String[]{formDesignProperties.getWorkspace(), name});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }
}

