/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.cascade;

import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.formdesign.publish.uni.UniPathStrategyService;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.io.IOException;

@ClientKind(kind="com.jxdinfo.UniDataModelJs.cascade")
public class UniModelJsCascadeImpl
implements ResourceCascadeVisitor {
    public static final String KIND = "com.jxdinfo.UniDataModelJs.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldUnifilePath = this.getOldUniJSPath(baseFile.getId(), strategy);
        String newUniFilePath = this.getNewUniJSPath(baseFile.getId(), baseFile.getName(), strategy);
        File newUniFile = new File(newUniFilePath);
        File oldUniFile = new File(oldUnifilePath);
        if (FileUtils.exists((File)oldUniFile) && !FileUtils.exists((File)newUniFile)) {
            this.fixName(oldUniFile, newUniFile);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentPath) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String parentPath = this.getMetaPath(parentId);
        String oldunifilePath = this.getOldUniJSPath(id, strategy);
        File uniJsFrom = new File(oldunifilePath);
        UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextUtil.getBean(UniPathStrategyService.class);
        String uniRootPath = FileUtil.systemPath((String[])new String[]{uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), uniPathStrategy.uniPathService().getUniFrontApiPath()});
        File uniJsTo = new File(this.relativeToAbsolute(parentPath, uniRootPath));
        this.modelMove(uniJsFrom, uniJsTo, newName, parentPath, uniRootPath);
    }

    public void modelMove(File jsFrom, File jsTo, String newName, String parentPath, String rootPath) throws IOException, LcdpException {
        if (FileUtils.exists((File)jsFrom)) {
            if (!FileUtils.exists((File)jsTo)) {
                FileUtils.forceMkdir((File)jsTo);
            }
            if (newName != null && !newName.isEmpty()) {
                jsTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName + ".js", rootPath));
                if (!FileUtils.exists((File)jsTo)) {
                    try {
                        FileUtils.moveFile((File)jsFrom, (File)jsTo);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, jsFrom.getAbsolutePath());
                    }
                }
            } else {
                try {
                    FileUtils.moveFileToDirectory((File)jsFrom, (File)jsTo, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, jsFrom.getAbsolutePath());
                }
            }
        }
    }

    public void cascadeDelete(String id) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String olduniJSFilePath = this.getOldUniJSPath(id, strategy);
        File unifile = new File(olduniJSFilePath);
        this.modelJsDel(unifile, olduniJSFilePath);
    }

    public void modelJsDel(File file, String oldJSFilePath) throws LcdpException {
        if (FileUtils.exists((File)file)) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldJSFilePath);
            }
        }
    }

    String getOldUniJSPath(String id, Integer strategy) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextUtil.getBean(UniPathStrategyService.class);
        String oldJsPath = fileMappingService.getFormatPath(id);
        String localPrefix = FileUtil.systemPath((String[])new String[]{uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), uniPathStrategy.uniPathService().getUniFrontApiPath()});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{oldJsPath + formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getNewUniJSPath(String id, String pageName, Integer strategy) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextUtil.getBean(UniPathStrategyService.class);
        String localPrefix = FileUtil.systemPath((String[])new String[]{uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), uniPathStrategy.uniPathService().getUniFrontApiPath()});
        String newJsPath = FileUtil.systemPath((String[])new String[]{fileMappingService.getFormatParentPath(id), pageName});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{newJsPath + formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String parentPath = (String)fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }
}

