/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.service.impl;

import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.lock.FileLockInfoVo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsCheckVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFileInfo;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsPathVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsRelationVO;
import com.jxdinfo.hussar.formdesign.extend.model.RegisterJsScriptFileVO;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendJsCommonService;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendJsService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileLockManagerService;
import com.jxdinfo.hussar.formdesign.publish.uni.UniPathStrategyService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.List;

@ClientKind(kind="com.jxdinfo.UniPage.extend.js")
public class ExtendMobileUniJsServiceImpl
implements ExtendJsService {
    private PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
    private UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextUtil.getBean(UniPathStrategyService.class);
    private FormDesignProperties speedCodeProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
    private MobileUniProperties mobileUniProperties = (MobileUniProperties)SpringContextUtil.getBean(MobileUniProperties.class);
    private FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
    private final ExtendJsCommonService extendJsCommonService = (ExtendJsCommonService)SpringContextUtil.getBean(ExtendJsCommonService.class);
    private FileLockManagerService lockManagerService = (FileLockManagerService)SpringContextUtil.getBean(FileLockManagerService.class);

    public ApiResponse<List<ExtendJsPathVO>> listJs() throws LcdpException, IOException {
        List extendJsPathVos = this.extendJsCommonService.listJs(this.pathStrategy.resourcePathService().getProjectAndCodePath(), this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), "UniPage");
        return ApiResponse.success((Object)extendJsPathVos);
    }

    public ApiResponse<ExtendJsCheckVO> getErrorForJs(String filePath) throws LcdpException {
        ExtendJsCheckVO extendJsCheckVo = this.extendJsCommonService.getErrorForJs(this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), filePath, "UniPage");
        return ApiResponse.success((Object)extendJsCheckVo);
    }

    public ApiResponse<RegisterJsScriptFileVO> listMethod(String filePath, String fileId) throws IOException, LcdpException {
        if (StringUtil.isNotBlank((CharSequence)fileId) && !this.fileMappingService.isFileExist(fileId)) {
            return ApiResponse.fail((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (StringUtil.isEmpty((Object)filePath) && StringUtil.isNotBlank((CharSequence)fileId)) {
            return ApiResponse.success((Object)this.extendJsCommonService.listMethodByStorage(this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), (ExtendJsFileInfo)this.extendJsCommonService.get(fileId), "UniPage"));
        }
        if (StringUtil.isNotBlank((CharSequence)filePath) && StringUtil.isEmpty((Object)fileId)) {
            return ApiResponse.success((Object)this.extendJsCommonService.listMethodByPath(this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), filePath, "UniPage"));
        }
        if (StringUtil.isNotBlank((CharSequence)filePath) && StringUtil.isNotBlank((CharSequence)fileId)) {
            return ApiResponse.success((Object)this.extendJsCommonService.listMethodByPathAndStorage(this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), filePath, (ExtendJsFileInfo)this.extendJsCommonService.get(fileId), "UniPage"));
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
    }

    public ApiResponse<FileLockInfoVo> saveJsFile(ExtendJsFileInfo fileInfo) throws IOException, LcdpException {
        ApiResponse response = this.lockManagerService.checkLock(fileInfo.getId(), null);
        if (!response.isSuccess()) {
            return response;
        }
        if (this.fileMappingService.isFileExist(fileInfo.getId())) {
            this.extendJsCommonService.updateFile((BaseFile)fileInfo);
        } else {
            if (this.extendJsCommonService.checkExists(fileInfo.getFilePath(), "UniPage")) {
                return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
            }
            this.extendJsCommonService.create((BaseFile)fileInfo);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> getJsContentByPath(String filePath) throws LcdpException {
        if (StringUtil.isEmpty((Object)filePath)) {
            return ApiResponse.fail((IResultCode)ResultCode.NO_EXIST_RESOURCE);
        }
        return ApiResponse.success((String)this.extendJsCommonService.getJsContentByPath(this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), filePath, "UniPage"));
    }

    public ApiResponse<List<ExtendJsRelationVO>> getRelation(String fileId, String functionName) throws IOException, LcdpException {
        return null;
    }
}

