const seriesResult = [];
const colorValue =${topicColorStr!};
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
if (oldTitle) {
const titleLength = oldTitle.length;
const provideLength = numberOfRow;
const rowNumber = Math.ceil(titleLength / provideLength);
if (titleLength > provideLength) {
for (let i = 0; i < rowNumber; i++) {
let tempStr = ' ';
const start = i * provideLength;
const end = start + provideLength;
if (i === rowNumber - 1) {
tempStr = oldTitle.substring(start, titleLength);
} else {
tempStr = oldTitle.substring(start, end) + '\n';
}
newTitle += tempStr;
}
} else {
newTitle = oldTitle;
}
}
<#--标题-->
const echatrsTitle = {
text: newTitle,
textStyle: {
color: '${titleColor!}',
fontSize: '${titleFontSize!}',
fontWeight: '${fontWeight!}',
},
textVerticalAlign :'${titleVerticalAlign!}',
left: '${titleAlign!}',
top: '${titleTop!}',
<#if (titleBackgroundColor?? && titleBackgroundColor != "")>
    backgroundColor: '${titleBackgroundColor!}',
</#if>
borderRadius: 4,
padding: [6, 5, 3, 5],
};
<#--网格-->
const grid = {
left: '${gridLeft!}',
top: '${gridTop!}',
right: '${gridRight!}',
bottom: '${gridBottom!}',
containLabel: ${containLabel?string!},
};
<#--提示信息-->
const echatrsTooltip = {
trigger: 'axis',
position: function (point, params, dom, rect, size) {
    let x = 0;
    let y = 0;
    const pointX = point[0];
    const pointY = point[1];
    const boxWidth = size.contentSize[0];
    const boxHeight = size.contentSize[1];
    if (boxWidth > pointX) {
        x = 10;
    } else {
        x = pointX - boxWidth - 10;
    }
    if (boxHeight > pointY) {
        y = 10;
    } else {
        y = pointY - boxHeight - 10;
    }
    return [x, y];
},
backgroundColor: '${tooltipBgColor!}',
textStyle: {
color: '${toolColor!}',
fontSize: '${toolFontSize!}',
fontWeight: '${toolFontWeight!}',
fontStyle: '${toolFontStyle!}',
lineHeight: '${toolLineHeight!}',
},
};
<#--图例字体设置-->
const textStyle ={
color: '${legendColor!}',
fontSize: '${legendFontSize!}',
fontWeight: '${legendFontWeight!}',
fontStyle: '${legendFontStyle!}',
};
<#--坐标轴字体设置-->
const nameTextStyle = {
color: '${xyColor!}',
fontSize: '${xyFontSize!}',
fontWeight: '${xyFontWeight!}',
fontStyle: '${xyFontStyle!}',
};
<#--坐标轴设置-->
const axisLine = {
show: true,
type: 'solid',
lineStyle: {
width: '${lineWidth!}',
<#if (lineColor?? && lineColor != "")>
    color: '${lineColor!}',
</#if>
},
};
const axisLabel = {
show: true,
color: '${xyColor!}',
fontSize: '${xyFontSize!}',
fontWeight: '${xyFontWeight!}',
fontStyle: '${xyFontStyle!}',
};
const axisLabels = {
show: true,
color: '${xyColor!}',
fontSize: '${xyFontSize!}',
fontWeight: '${xyFontWeight!}',
fontStyle: '${xyFontStyle!}',
<#if (barUnit?? && barUnit != "")>
    formatter:'{value}${barUnit!}',
<#else>
    formatter:'{value}',
</#if>
};
<#--标签-->
const label ={
position:'${labelPosition!}',
<#if (labelDistance??)>
    distance:${labelDistance!},
</#if>
color:'${labelColor!}',
fontSize:'${labelFontSize!}',
};
const axisTick ={
length:'${xyAxisTickLength!}',
};
<#--x坐标轴设置-->
const xAxis = {
type:'value',
show:true,
name: '${yBarAxisName!}',
nameLocation: '${nameLocation!}',
nameGap:${xNameGap!},
nameTextStyle:nameTextStyle,
axisLine:axisLine,
axisLabel:axisLabels,
axisTick:axisTick,
splitLine:{
show: ${xSplitLineShow?string!},
lineStyle:{
color:'${xSplitLineColor!}',
type:'${xSplitLineType!}',
},
},
};
<#--series样式设置-->
const seriesItemStyle ={
    normal: {
        barBorderRadius: ${barRadius!},
    },
};

${optionData!}.legendData.forEach((col, index) => {
    seriesResult.push({
    name: col,
    itemStyle:seriesItemStyle,
    type: 'bar',
    label:label,
    barWidth: ${barWidth!},
    <#if barGap?? && '${barGap}' != ''>
        barGap: '${barGap}',
    </#if>
    data: ${optionData!}.xAxisData[index],
<#--    color: ${optionData!}.color[index],-->
    });
});

return {
        color: colorValue,
        title: echatrsTitle,
        grid:grid,
        tooltip: echatrsTooltip,
        legend: {
            show: ${isShowFlag?string!},
            left: '${legendLocation!}',
            textStyle:textStyle,
            itemWidth: ${itemWidth!},
            itemHeight: ${itemHeight!},
            itemGap: ${itemGap!}   ,
            icon: '${itemIcon!}',
            orient: '${itemOrient!}',
            inactiveColor: '${itemInactiveColor!}',
            data:${optionData!}.legendData,
        },
        xAxis: xAxis,
        yAxis: {
            type:'category',
            show:true,
            name: '${xAxisName!}',
            nameLocation: '${nameLocation!}',
            nameGap:${yNameGap!},
            nameTextStyle:nameTextStyle,
            axisLine:axisLine,
            axisLabel:axisLabel,
            axisTick: axisTick,
            data: ${optionData!}.yAxisData,
        },
        series: seriesResult,
}