/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.CodePublishTool;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.VueCodeGenerateService;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.result.VueCodeResult;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.result.VueGenerateResult;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.CodePublisher;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.StyleScheme;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBaseConfig;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.publish.uni.UniPathStrategyService;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ClientKind(kind="com.jxdinfo.UniPage.publish")
@Component(value="com.jxdinfo.UniPage.publish")
public class UniCodePublishImpl
implements CodePublisher {
    public static final String KIND = "com.jxdinfo.UniPage.publish";
    @Autowired
    private VersionManageService versionManageService;
    @Autowired
    private FilePublishService filePublishService;
    @Autowired
    private CodeMergeService codeMergeService;
    @Autowired
    private VueCodeGenerateService vueCodeGenerateService;
    @Autowired
    private FileMappingService fileMappingService;
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private MobileUniProperties mobileUniProperties;
    @Autowired
    private IHussarThemeConfigService iHussarThemeConfigService;
    @Autowired
    private CodePublishTool codePublishTool;
    @Autowired
    private UniPathStrategyService uniPathStrategy;
    @Autowired
    private PathStrategyService pathStrategy;
    public static final String JS = ".js";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(PublishCtx<CodeResult> publishCtx, ThemeVars themeVars) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        PageInfo pageInfo = (PageInfo)publishCtx.getBaseFile();
        String projectPath = this.mobileUniProperties.getUniFrontProjectPath();
        String id = pageInfo.getId();
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(pageInfo.getId());
        moduleRelatePath = moduleRelatePath.startsWith("/") ? moduleRelatePath : "/" + moduleRelatePath;
        moduleRelatePath = moduleRelatePath.endsWith("/") ? moduleRelatePath : moduleRelatePath + "/";
        String pageName = pageInfo.getName();
        String pageInfoDataJson = pageInfo.getData();
        JSONObject pageInfoDataJsonObject = JSON.parseObject((String)pageInfoDataJson);
        StyleScheme styleScheme = this.iHussarThemeConfigService.getCurrentSysThemeInfo();
        ThemeBaseConfig themeBaseConfig = styleScheme.getThemeBase().getMobilePage();
        Map scssVars = styleScheme.getScssVars().getMobilePage();
        VueGenerateResult codeFormatResult = this.vueCodeGenerateService.vueGenerate(publishCtx, pageInfoDataJsonObject, pageName, pageInfo, themeVars.getMobilePage(), strategy, themeBaseConfig, scssVars);
        String newContent = codeFormatResult.getCodeFormatCode();
        String projectPagePath = this.mobileProjectVue(this.mobileUniProperties.getUniFrontProjectPath(), this.fileMappingService.getFormatPath(id) + this.formDesignProperties.getPageSuffix()).getLocalPath();
        if (!codeFormatResult.isSucceed()) {
            VueCodeResult codeResult = new VueCodeResult();
            codeResult.setId(id);
            codeResult.setNewCode(newContent);
            codeResult.setFilePath(projectPagePath);
            codeResult.setCodeFormatSucceed(codeFormatResult.isSucceed());
            codeResult.setCodeFormatMessages(codeFormatResult.getMessages());
            codeResult.setMsg(codeFormatResult.getMsg());
            publishCtx.addCodeResult((CodeResult)codeResult);
            return;
        }
        newContent = CodeSplitUtil.removeEmptyLines((String)newContent);
        this.filePublishService.writePublishSourceToCache(id, "mobileUni");
        if (strategy != null) {
            try {
                this.genMobileUniCode(id, moduleRelatePath, pageName, pageInfo, newContent, projectPath);
                this.codePublishTool.delayWrite(id);
                this.compile(projectPath, moduleRelatePath, pageName, pageInfo);
            }
            finally {
                this.versionManageService.saveLastPublishCode(id, newContent);
                this.versionManageService.saveLastFileCode(id, newContent);
            }
            return;
        }
        Optional<String> ancestorContent = Optional.ofNullable(this.versionManageService.getAncestorCodeById(id));
        Optional<String> lastFileContent = Optional.ofNullable(this.versionManageService.getLastFileCode(id));
        String pagePath = this.mobileProjectVue(projectPath, moduleRelatePath, pageName + this.formDesignProperties.getPageSuffix()).getLocalPath();
        Optional<String> currentContent = Optional.ofNullable(this.filePublishService.readCurrentPublishedFile(pagePath));
        if (ancestorContent.isPresent() && currentContent.isPresent()) {
            MergeResult mergeResult;
            String lastPulishCode = ancestorContent.get();
            String currentFileCode = currentContent.get();
            if (this.formDesignProperties.isLocalCodeFormatter()) {
                CodeFormatResult lastPublishResult = CodeFormatter.formatterHtml((String)ancestorContent.get(), (String)"vue");
                lastPulishCode = lastPublishResult.getCodeFormatCode();
                CodeFormatResult currentFileResult = CodeFormatter.formatterHtml((String)currentContent.get(), (String)"vue");
                currentFileCode = currentFileResult.getCodeFormatCode();
            }
            String lastFile = "";
            if (lastFileContent.isPresent()) {
                lastFile = lastFileContent.get();
            }
            if (!(mergeResult = this.codeMergeService.structuralMerge(pagePath, ExtractFileType.VUE, lastPulishCode, currentFileCode, newContent, lastFile, true)).isConflict()) {
                try {
                    this.genMobileUniCode(id, moduleRelatePath, pageName, pageInfo, mergeResult.getMergedCode(), projectPath);
                }
                finally {
                    this.versionManageService.saveLastPublishCode(id, newContent);
                    this.versionManageService.saveLastFileCode(id, mergeResult.getMergedCode());
                }
            } else {
                this.codePublishTool.assembleCode(id, publishCtx, newContent, currentContent, mergeResult, projectPagePath);
            }
        } else {
            try {
                newContent = CodeSplitUtil.removeEmptyLines((String)newContent);
                this.genMobileUniCode(id, moduleRelatePath, pageName, pageInfo, newContent, projectPath);
            }
            finally {
                this.versionManageService.saveLastPublishCode(id, newContent);
                this.versionManageService.saveLastFileCode(id, newContent);
            }
        }
    }

    private void genMobileUniCode(String id, String moduleRelatePath, String pageName, PageInfo pageInfo, String fileContent, String uniProjectPath) throws IOException, LcdpException {
        String projectPath = this.mobileProject(uniProjectPath, new String[0]).getLocalPath();
        this.writeMobileCode(fileContent, moduleRelatePath, pageName, projectPath, id);
        if (!this.formDesignProperties.isLocalUnReset()) {
            String component = this.pathStrategy.vuePathService().posixFilePathPrefix("", new String[]{"views", moduleRelatePath, pageName});
            String desc = pageInfo.getDesc();
            String routerExport = "{\n \"path\": \"" + component.replace("\\", "/") + "\",\n\"style\": {\n\"navigationBarTitleText\": \"" + desc + "\"\n}\n}";
            this.writeMobileUniRouterCode(component, routerExport, projectPath, id);
        }
        this.getCommon(id);
    }

    private void getCommon(String pageId) throws LcdpException {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String prefix = AppContextUtil.getUnionPrefix();
        map.put("name", this.uniPathStrategy.uniPathService().getName());
        map.put("pathName", this.uniPathStrategy.uniPathService().getPathName());
        String newCode = RenderUtil.renderTemplate((String)"prefixCommon/prefixCommon.ftl", map);
        String filePath = this.mobileProject(this.mobileUniProperties.getUniFrontProjectPath(), this.pathStrategy.vuePathService().posixFilePathPrefix("src", new String[]{"prefixCommon.js"})).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        this.filePublishService.writeStringToFile(newCode, filePath, pageId);
    }

    private void writeMobileUniRouterCode(String component, String fileContent, String vueRootPath, String pageId) throws IOException {
        vueRootPath = FileUtil.complementFilePath((String)vueRootPath);
        String filePath = vueRootPath + "/src/pages.json";
        File file = new File(filePath);
        String fileMsg = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        JSONObject parse = JSON.parseObject((String)fileMsg, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray jsonArray = JSON.parseArray((String)parse.get((Object)"pages").toString());
        boolean type = true;
        for (Object o : jsonArray) {
            String path = JSON.parseObject((String)o.toString()).get((Object)"path").toString();
            if (!path.equals(FileUtil.posixPath((String[])new String[]{component}))) continue;
            type = false;
            break;
        }
        if (type) {
            jsonArray.add((Object)JSON.parseObject((String)fileContent));
            parse.put("pages", (Object)jsonArray);
        }
        String writeFormat = JSON.toJSONString((Object)parse, (boolean)true);
        this.filePublishService.writeStringToFile(writeFormat, filePath, pageId);
    }

    private void writeMobileCode(String fileContent, String modulePath, String pageName, String vueRootPath, String pageId) throws IOException {
        vueRootPath = this.formDesignProperties.isLocalUnReset() ? FileUtil.systemPath((String[])new String[]{vueRootPath, this.pathStrategy.vuePathService().posixFilePathPrefix("src", new String[]{"pages"})}) : FileUtil.systemPath((String[])new String[]{vueRootPath, this.pathStrategy.vuePathService().posixFilePathPrefix("src", new String[]{"views"})});
        vueRootPath = FileUtil.complementFilePath((String)vueRootPath);
        modulePath = FileUtil.complementFilePath((String)modulePath);
        String filePath = vueRootPath + modulePath + pageName + this.formDesignProperties.getPageSuffix();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        this.filePublishService.writeStringToFile(fileContent, filePath, pageId);
    }

    private void compile(String projectPath, String moduleRelatePath, String pageName, PageInfo pageInfo) throws LcdpException {
        HashMap<String, String> compileParams = new HashMap<String, String>();
        String pageType = "pages";
        String publishVueRelativePath = this.pathStrategy.vuePathService().posixFilePathPrefix("@/" + pageType, new String[]{moduleRelatePath, pageName});
        if (ToolUtil.isNotEmpty((Object)moduleRelatePath)) {
            moduleRelatePath = moduleRelatePath.substring(0, 1).equals("/") ? moduleRelatePath.substring(1) : moduleRelatePath;
        }
        compileParams.put("entry", FileUtil.posixPath((String[])new String[]{"pages", moduleRelatePath, pageName}));
        compileParams.put("template", this.mobileProject(projectPath, this.formDesignProperties.getMobileCompileHtmlPath()).getLocalPath());
        compileParams.put("output", this.pathStrategy.vuePathService().posixFilePathPrefix(this.mobileUniProperties.getUniCompilePath(), new String[]{moduleRelatePath, pageName, File.separator}));
        compileParams.put("name", pageInfo.getDesc());
        compileParams.put("path", FileUtil.posixPath((String[])new String[]{"pages", moduleRelatePath, pageName}));
        this.codePublishTool.compile(publishVueRelativePath, compileParams, this.mobileUniProperties.getUniCompileServer());
    }

    private ResourcePath mobileProject(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getWorkspace(), name});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }

    private ResourcePath mobileProjectVue(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getWorkspace(), name, this.uniPathStrategy.uniPathService().getUniVueCodePath()});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }
}

