const result = [];
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
if (oldTitle) {
    const titleLength = oldTitle.length;
    const provideLength = numberOfRow;
    const rowNumber = Math.ceil(titleLength / provideLength);
    if (titleLength > provideLength) {
        for (let i = 0; i < rowNumber; i++) {
            let tempStr = ' ';
            const start = i * provideLength;
            const end = start + provideLength;
            if (i === rowNumber - 1) {
                tempStr = oldTitle.substring(start, titleLength);
            } else {
                tempStr = oldTitle.substring(start, end)+'\n';
            }
            newTitle += tempStr;
        }
    } else {
        newTitle = oldTitle;
    }
}
const echatrsTitle = {
    text: newTitle,
    textStyle: {
        color: '${titleColor!}',
        fontSize: '${titleFontSize!}',
        fontWeight: '${fontWeight!}',
        fontStyle: '${fontStyle!}',
    },
    left: '${titleAlign!}',
    top: '${titleTop!}',
<#if (titleBackgroundColor?? && titleBackgroundColor != "")>
    backgroundColor: '${titleBackgroundColor!}',
</#if>
};
const echatrsTooltip = {
    formatter: '{b} : {c} ({d}%)',
    trigger: 'item',
    position: function (point, params, dom, rect, size) {
    let x = 0;
    let y = 0;
    const pointX = point[0];
    const pointY = point[1];
    const boxWidth = size.contentSize[0];
    const boxHeight = size.contentSize[1];
    if (boxWidth > pointX) {
    x = 10;
    } else {
    x = pointX - boxWidth - 10;
    }
    if (boxHeight > pointY) {
    y = 10;
    } else {
    y = pointY - boxHeight - 10;
    }
    return [x, y];
    },
    backgroundColor: '${tooltipBgColor!}',
    textStyle: {
        color: '${toolColor!}',
        fontSize: '${toolFontSize!}',
        fontWeight: '${toolFontWeight!}',
        fontStyle: '${toolFontStyle!}',
        lineHeight: '${toolLineHeight!}',
    },
};
const textStyle = {
    color: '${legendColor!}',
    fontSize: '${legendFontSize!}',
    fontWeight: '${legendFontWeight!}',
    fontStyle: '${legendFontStyle!}',
};
const topicColorStr = ${topicColorStr!};
${optionData!}.xAxisData.forEach((col,index)=>{
  result.push({
    name: col,
    value: ${optionData!}.seriesData[index],
  });
});
return {
    color: topicColorStr,
    title: echatrsTitle,
    tooltip: echatrsTooltip,
    legend: {
        <#if (isShowFlag?? && isShowFlag)>
            show: true,
        <#elseif (!isShowFlag?? || !isShowFlag)>
            show: false,
        </#if>
        icon: '${legendIcon!}',
        left: '${legendLocation!}',
        textStyle: textStyle,
        data: ${optionData!}.xAxisData,
        bottom: 10,
    },
    series: [
        {
        radius: '${radius!}%',
        type: 'pie',
        selectedMode: 'single',
        data: result,
        label: {
            show: true,
            formatter: '{b} : {c}',
            fontSize: ${topicSize!},
        },
        },
    ],
}
