/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.publish;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.ScriptCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ScriptPublisher;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendUniWJsScript;
import com.jxdinfo.hussar.formdesign.extend.result.UniJsScriptCodeResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;

@ClientKind(kind="com.jxdinfo.UniJsScript.extend.publish")
public class UniJsScriptPublishImpl
implements ScriptPublisher {
    public static final String KIND = "com.jxdinfo.UniJsScript.extend.publish";
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final MobileUniProperties mobileUniProperties = (MobileUniProperties)SpringContextHolder.getBean(MobileUniProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static final String JS_SUFFIX = ".js";

    public void publish(ScriptCtx<CodeResult> scriptCtx) throws LcdpException {
        BaseFile baseFile = scriptCtx.getBaseFile();
        ExtendUniWJsScript extendWJsScript = (ExtendUniWJsScript)((Object)JSON.parseObject((String)baseFile.getData(), ExtendUniWJsScript.class));
        String modelPath = this.fileMappingService.getFormatParentPath(baseFile.getId());
        String rootPath = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.formDesignProperties.getMobileExtendScriptPath()});
        String path = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendJavaScriptPath(), modelPath, baseFile.getName() + JS_SUFFIX});
        if (HussarUtils.isNotEmpty((Object)extendWJsScript.getEditorNote())) {
            filePublishService.writeStringToFile(extendWJsScript.getEditorNote(), path, baseFile.getId());
        }
        UniJsScriptCodeResult jsScriptCodeResult = new UniJsScriptCodeResult();
        jsScriptCodeResult.setFilePath(path);
        jsScriptCodeResult.setResultType(ResultBeanEnum.JS_SCRIPT);
        jsScriptCodeResult.setId(baseFile.getId());
        scriptCtx.addGenCodeResults((CodeResult)jsScriptCodeResult);
    }
}

