/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.uniui.vistor;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.ctx.MobileUniCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LineBarEchartsVoidVisitor
implements VoidVisitor<LcdpComponent, MobileUniCtx> {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, MobileUniCtx ctx) throws LcdpException, IOException {
        lcdpComponent.registerTemplatePath("/template/uniui/uni/lineBarEcharts/line_bar_echarts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderMethod(LcdpComponent lcdpComponent, MobileUniCtx ctx) throws LcdpException, IOException {
        Map echartsMaps;
        HashMap<String, Object> echartsParams = new HashMap<String, Object>();
        echartsParams.put("instanceKey", lcdpComponent.getInstanceKey());
        this.renderDadaValue(lcdpComponent, ctx, echartsParams);
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            echartsParams.put("isQuoteOrGetValue", "true");
        }
        if (ToolUtil.isNotEmpty((Object)(echartsMaps = lcdpComponent.getProps()))) {
            echartsParams.put("titleText", echartsMaps.get("title"));
            echartsParams.put("titleColor", ToolUtil.isNotEmpty(echartsMaps.get("titleColor")) ? echartsMaps.get("titleColor") : "#000");
            echartsParams.put("titleFontSize", ToolUtil.isNotEmpty(echartsMaps.get("titleFontSize")) ? echartsMaps.get("titleFontSize") : "18");
            echartsParams.put("fontStyle", echartsMaps.get("fontStyle"));
            echartsParams.put("fontWeight", echartsMaps.get("fontWeight"));
            echartsParams.put("titleAlign", ToolUtil.isNotEmpty(echartsMaps.get("titleAlign")) ? echartsMaps.get("titleAlign") : "left");
            echartsParams.put("numberOfRow", ToolUtil.isNotEmpty(echartsMaps.get("numberOfRow")) ? echartsMaps.get("numberOfRow") : "10");
            echartsParams.put("titleTop", echartsMaps.get("titleTop"));
            echartsParams.put("titleBackgroundColor", ToolUtil.isNotEmpty(echartsMaps.get("titleBackgroundColor")) ? echartsMaps.get("titleBackgroundColor") : "transparent");
            echartsParams.put("xAxisName", echartsMaps.get("xAxisName"));
            echartsParams.put("yBarAxisName", echartsMaps.get("yBarAxisName"));
            echartsParams.put("yLineAxisName", echartsMaps.get("yLineAxisName"));
            echartsParams.put("nameLocation", ToolUtil.isNotEmpty(echartsMaps.get("nameLocation")) ? echartsMaps.get("nameLocation") : "end");
            echartsParams.put("xyColor", ToolUtil.isNotEmpty(echartsMaps.get("xyColor")) ? echartsMaps.get("xyColor") : "#000");
            echartsParams.put("xyFontSize", ToolUtil.isNotEmpty(echartsMaps.get("xyFontSize")) ? echartsMaps.get("xyFontSize") : "14");
            echartsParams.put("xyFontWeight", echartsMaps.get("xyFontWeight"));
            echartsParams.put("xyFontStyle", echartsMaps.get("xyFontStyle"));
            echartsParams.put("lineColor", ToolUtil.isNotEmpty(echartsMaps.get("lineColor")) ? echartsMaps.get("lineColor") : "#000");
            echartsParams.put("lineWidth", ToolUtil.isNotEmpty(echartsMaps.get("lineWidth")) ? echartsMaps.get("lineWidth") : "1");
            echartsParams.put("barUnit", ToolUtil.isNotEmpty(echartsMaps.get("barUnit")) ? echartsMaps.get("barUnit") : "");
            echartsParams.put("lineUnit", ToolUtil.isNotEmpty(echartsMaps.get("lineUnit")) ? echartsMaps.get("lineUnit") : "");
            echartsParams.put("xNameGap", ToolUtil.isNotEmpty(echartsMaps.get("xNameGap")) ? echartsMaps.get("xNameGap") : "35");
            echartsParams.put("yNameGap", ToolUtil.isNotEmpty(echartsMaps.get("yNameGap")) ? echartsMaps.get("yNameGap") : "10");
            echartsParams.put("xyAxisTickLength", echartsMaps.get("xyAxisTickLength"));
            echartsParams.put("gridLeft", ToolUtil.isNotEmpty(echartsMaps.get("gridLeft")) ? echartsMaps.get("gridLeft") : "60");
            echartsParams.put("gridTop", ToolUtil.isNotEmpty(echartsMaps.get("gridTop")) ? echartsMaps.get("gridTop") : "50");
            echartsParams.put("gridRight", ToolUtil.isNotEmpty(echartsMaps.get("gridRight")) ? echartsMaps.get("gridRight") : "60");
            echartsParams.put("gridBottom", ToolUtil.isNotEmpty(echartsMaps.get("gridBottom")) ? echartsMaps.get("gridBottom") : "45");
            echartsParams.put("containLabel", Optional.ofNullable(echartsMaps.get("containLabel")).orElse(false));
            echartsParams.put("tooltipBgColor", echartsMaps.get("tooltipBgColor"));
            echartsParams.put("toolColor", echartsMaps.get("toolColor"));
            echartsParams.put("toolFontSize", ToolUtil.isNotEmpty(echartsMaps.get("toolFontSize")) ? echartsMaps.get("toolFontSize") : "18");
            echartsParams.put("toolFontWeight", echartsMaps.get("toolFontWeight"));
            echartsParams.put("toolFontStyle", echartsMaps.get("toolFontStyle"));
            echartsParams.put("toolLineHeight", echartsMaps.get("toolLineHeight"));
            echartsParams.put("isShowFlag", echartsMaps.get("isShowFlag"));
            echartsParams.put("legendLocation", ToolUtil.isNotEmpty(echartsMaps.get("legendLocation")) ? echartsMaps.get("legendLocation") : "right");
            echartsParams.put("legendIcon", echartsMaps.get("legendIcon"));
            echartsParams.put("legendColor", ToolUtil.isNotEmpty(echartsMaps.get("legendColor")) ? echartsMaps.get("legendColor") : "#000000");
            echartsParams.put("legendFontSize", ToolUtil.isNotEmpty(echartsMaps.get("legendFontSize")) ? echartsMaps.get("legendFontSize") : "18");
            echartsParams.put("legendFontWeight", echartsMaps.get("legendFontWeight"));
            echartsParams.put("legendFontStyle", echartsMaps.get("legendFontStyle"));
            String topicColorStr = "";
            String colorSystem = echartsMaps.get("colorSystem").toString();
            if ("colour".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("colourColor").toString();
            } else if ("green".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("greenColor").toString();
            } else if ("blue".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("blueColor").toString();
            }
            echartsParams.put("topicColorStr", topicColorStr);
            echartsParams.put("barWidth", Optional.ofNullable(echartsMaps.get("barWidth")).orElse(12));
            echartsParams.put("barGap", echartsMaps.get("barGap"));
            echartsParams.put("barRadius", Optional.ofNullable(echartsMaps.get("barRadius")).orElse(0));
            echartsParams.put("xPaddingTop", ToolUtil.isNotEmpty(echartsMaps.get("xPaddingTop")) ? echartsMaps.get("xPaddingTop") : "0");
            echartsParams.put("xPaddingRight", ToolUtil.isNotEmpty(echartsMaps.get("xPaddingRight")) ? echartsMaps.get("xPaddingRight") : "0");
            echartsParams.put("xPaddingBottom", ToolUtil.isNotEmpty(echartsMaps.get("xPaddingBottom")) ? echartsMaps.get("xPaddingBottom") : "0");
            echartsParams.put("xPaddingLeft", ToolUtil.isNotEmpty(echartsMaps.get("xPaddingLeft")) ? echartsMaps.get("xPaddingLeft") : "0");
            echartsParams.put("yBarPaddingTop", ToolUtil.isNotEmpty(echartsMaps.get("yBarPaddingTop")) ? echartsMaps.get("yBarPaddingTop") : "0");
            echartsParams.put("yBarPaddingRight", ToolUtil.isNotEmpty(echartsMaps.get("yBarPaddingRight")) ? echartsMaps.get("yBarPaddingRight") : "0");
            echartsParams.put("yBarPaddingBottom", ToolUtil.isNotEmpty(echartsMaps.get("yBarPaddingBottom")) ? echartsMaps.get("yBarPaddingBottom") : "0");
            echartsParams.put("yBarPaddingLeft", ToolUtil.isNotEmpty(echartsMaps.get("yBarPaddingLeft")) ? echartsMaps.get("yBarPaddingLeft") : "0");
            echartsParams.put("yLinePaddingTop", ToolUtil.isNotEmpty(echartsMaps.get("yLinePaddingTop")) ? echartsMaps.get("yLinePaddingTop") : "0");
            echartsParams.put("yLinePaddingRight", ToolUtil.isNotEmpty(echartsMaps.get("yLinePaddingRight")) ? echartsMaps.get("yLinePaddingRight") : "0");
            echartsParams.put("yLinePaddingBottom", ToolUtil.isNotEmpty(echartsMaps.get("yLinePaddingBottom")) ? echartsMaps.get("yLinePaddingBottom") : "0");
            echartsParams.put("yLinePaddingLeft", ToolUtil.isNotEmpty(echartsMaps.get("yLinePaddingLeft")) ? echartsMaps.get("yLinePaddingLeft") : "0");
            echartsParams.put("seriesLineWidth", ToolUtil.isNotEmpty(echartsMaps.get("seriesLineWidth")) ? echartsMaps.get("seriesLineWidth") : "1");
            echartsParams.put("smooth", echartsMaps.get("smooth"));
            echartsParams.put("topicType", echartsMaps.get("topicType").toString());
            echartsParams.put("barSeriesName", echartsMaps.get("barSeriesName"));
            echartsParams.put("lineSeriesName", echartsMaps.get("lineSeriesName"));
            echartsParams.put("lineMin", echartsMaps.get("lineMin"));
            echartsParams.put("lineMax", echartsMaps.get("lineMax"));
            echartsParams.put("barMin", echartsMaps.get("barMin"));
            echartsParams.put("barMax", echartsMaps.get("barMax"));
            DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
            DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
            if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
                Boolean isNewDataSet = "ASSOCIATION".equals(dataSModelAnalysis.getFunctionType()) || "CUSTOM_SQL".equals(dataSModelAnalysis.getFunctionType());
                echartsParams.put("isNewDataSet", isNewDataSet);
                DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
                List paramValue = dataSModelAnalysis.getParamValue();
                Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
                String labelField = "";
                String valueField = "";
                String legendField = "";
                String typeField = "";
                ArrayList<String> dims = new ArrayList<String>();
                ArrayList targets = new ArrayList();
                if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                    List dataItemPath;
                    List fieldAnalyses;
                    if (!isNewDataSet.booleanValue()) {
                        for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                            fieldAnalyses = (List)fieldList.getValue();
                            for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                                dataItemPath = dataSFieldAnalysis.getDataItemPath();
                                if (ToolUtil.isNotEmpty((Object)dataItemPath) && "label".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                    labelField = dataSFieldAnalysis.getFieldName();
                                }
                                if (ToolUtil.isNotEmpty((Object)dataItemPath) && "value".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                    valueField = dataSFieldAnalysis.getFieldName();
                                }
                                if (ToolUtil.isNotEmpty((Object)dataItemPath) && "legend".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                    legendField = dataSFieldAnalysis.getFieldName();
                                }
                                if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"type".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                                typeField = dataSFieldAnalysis.getFieldName();
                            }
                        }
                    } else {
                        for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                            fieldAnalyses = (List)fieldList.getValue();
                            for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                                HashMap<String, String> map;
                                dataItemPath = dataSFieldAnalysis.getDataItemPath();
                                String convertFieldName = dataSModelAnalysis.getModelFieldNameByAliasName(dataSFieldAnalysis.getFieldName());
                                if (ToolUtil.isNotEmpty((Object)dataItemPath) && "label".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                    dims.add(convertFieldName);
                                    map = new HashMap();
                                    map.put("columnName", convertFieldName);
                                    map.put("asAlias", convertFieldName + "Dim");
                                    targets.add(map);
                                }
                                if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                                map = new HashMap<String, String>();
                                map.put("columnName", convertFieldName);
                                map.put("agg", dataSFieldAnalysis.getAggrFunc());
                                map.put("legendName", dataSFieldAnalysis.getLegendName());
                                map.put("asAlias", convertFieldName + dataSFieldAnalysis.getAggrFunc() + "Metrics");
                                targets.add(map);
                            }
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField) || isNewDataSet.booleanValue()) {
                    String querySelectionName;
                    String operationName = "hussarQuery";
                    if (isNewDataSet.booleanValue()) {
                        operationName = "conditionECharsQuery";
                        echartsParams.put("dims", dims);
                        echartsParams.put("targets", targets);
                    }
                    String apiFileName = "";
                    String apiFilePath = "";
                    String dataModelId = dataSModelAnalysis.getDataModelId();
                    if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                        apiFileName = this.fileMappingService.getFileName(dataModelId);
                        apiFilePath = this.fileMappingService.getMobileImportPath(dataModelId);
                    }
                    if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) || ToolUtil.isNotEmpty((Object)paramValue)) {
                        List conditionList = dataSConditionAnalysis.getQueryConditionModelList();
                        if (ToolUtil.isNotEmpty((Object)conditionList) && !isNewDataSet.booleanValue()) {
                            echartsParams.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                            echartsParams.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                        } else if (isNewDataSet.booleanValue()) {
                            echartsParams.put("queryAttr", QueryAttrUtil.getDataSetQueryAttr((List)conditionList, (List)paramValue, (Ctx)ctx, (String)dataModelId));
                        }
                    }
                    if (!isNewDataSet.booleanValue()) {
                        String sortConditionName;
                        DataSortConditionAnalysis dataSortConditionAnalysis;
                        querySelectionName = dataSConditionAnalysis.getSelectCondition();
                        if (ToolUtil.isNotEmpty((Object)querySelectionName)) {
                            operationName = operationName + querySelectionName;
                        }
                        if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                            operationName = operationName + sortConditionName;
                        }
                    } else {
                        String sortConditionName;
                        DataSortConditionAnalysis dataSortConditionAnalysis;
                        querySelectionName = dataSConditionAnalysis.getSelectCondition();
                        echartsParams.put("isDataSetSearch", false);
                        List allFields = ModelProvideAdapter.adaptor((String)dataModelId).getFields(dataModelId);
                        echartsParams.put("allFields", allFields);
                        if (ToolUtil.isNotEmpty((Object)querySelectionName)) {
                            echartsParams.put("isDataSetSearch", true);
                            Map queryConditions = DataModelUtil.getQueryConditionByModelIDAndName((String)dataModelId, (String)querySelectionName);
                            echartsParams.put("queryConditions", queryConditions);
                            ctx.addImports("getQueryConditionsResult", "@/utils/lowcode/queryConditionUtils");
                            ArrayList<String> queryConditionParams = new ArrayList<String>();
                            queryConditionParams.add("params");
                            ctx.addMethod(lcdpComponent.getInstanceKey() + "GetQueryConditions", queryConditionParams, RenderUtil.renderTemplate((String)"template/uniui/event/echarts_getQueryConditionsMethod.ftl", echartsParams), false, MultilineExegesisUtil.dealMethodExegesis((LcdpComponent)lcdpComponent, (String)"\u83b7\u53d6\u7b5b\u9009\u53c2\u6570\u65b9\u6cd5"));
                        }
                        if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                            Map sortConditions = DataModelUtil.getSortConditionByModelIDAndName((String)dataModelId, (String)sortConditionName);
                            echartsParams.put("sortConditions", sortConditions);
                            echartsParams.put("orders", RenderUtil.renderTemplate((String)"template/uniui/event/sortCondition.ftl", echartsParams));
                        }
                    }
                    if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                        EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                    }
                    echartsParams.put("dbdHaveMethod", DataModelUtil.judgeDataModelHasOperation((String)dataModelId, (String)operationName));
                    echartsParams.put("importName", apiFileName);
                    echartsParams.put("importMethod", operationName);
                    echartsParams.put("xAxisCols", labelField);
                    echartsParams.put("seriesCols", valueField);
                    echartsParams.put("legendCols", legendField);
                }
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addComputed(lcdpComponent.getInstanceKey() + "EchartsData", RenderUtil.renderTemplate((String)"/template/uniui/uni/lineBarEcharts/line_bar_echarts_computed.ftl", echartsParams), false, MultilineExegesisUtil.dealComputedExegesis((LcdpComponent)lcdpComponent));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "GetOptionItem", RenderUtil.renderTemplate((String)"/template/uniui/uni/lineBarEcharts/line_bar_echarts_success.ftl", echartsParams));
            ctx.addOnLoad("this." + lcdpComponent.getInstanceKey() + "GetOptionItem();");
        }
    }

    private void renderDadaValue(LcdpComponent lcdpComponent, MobileUniCtx ctx, Map<String, Object> echartsParams) throws LcdpException {
        String defaultValue = "{xAxisData: [],yAxisData: [],legendData: [],}";
        ComponentData optionData = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION_DATA.getType(), Collections.singletonList("data"), (String)defaultValue);
        echartsParams.put("optionData", CodePrefix._SELF.getType() + optionData.getRenderValue());
        boolean isDefaultValue = false;
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            echartsParams.put("isQuoteOrGetValue", "true");
        } else if (!ctx.getDatas().containsKey(lcdpComponent.getInstanceKey() + CodeSuffix._OPTION_DATA.getType() + ":" + defaultValue)) {
            isDefaultValue = true;
        }
        echartsParams.put("isDefaultValue", isDefaultValue);
    }
}

