/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.cascade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

@ClientKind(kind="com.jxdinfo.UniPage.cascade")
public class UniVueCascadeImpl
implements ResourceCascadeVisitor {
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final MobileUniProperties mobileUniProperties = (MobileUniProperties)SpringContextHolder.getBean(MobileUniProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    public static final String KIND = "com.jxdinfo.UniPage.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
    }

    public void cascadeDelete(String id) throws LcdpException {
    }

    String getOldVuePath(String id, Integer strategy) throws LcdpException {
        String oldVuePath = this.fileMappingService.getFormatPath(id);
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniVueCodePath(strategy)});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{oldVuePath + this.formDesignProperties.getPageSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getNeWVuePath(String id, String pageName, Integer strategy) throws LcdpException {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniVueCodePath(strategy)});
        String newVuePath = FileUtil.systemPath((String[])new String[]{this.fileMappingService.getFormatParentPath(id), pageName});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{newVuePath + this.formDesignProperties.getPageSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    void copyAncestor(String oidId, String newId) throws IOException {
        String oldPublishPath = this.getPublishVersionFilePathById(oidId);
        String oldFilePath = this.getLastFileVersionFilePathById(oidId);
        File oldPublish = new File(oldPublishPath);
        File oldFile = new File(oldFilePath);
        File toPublish = new File(this.getPublishVersionFilePathById(newId));
        File toFile = new File(this.getLastFileVersionFilePathById(newId));
        if (oldPublish.exists() && oldFile.exists()) {
            FileUtils.copyFile((File)oldPublish, (File)toPublish, (boolean)false);
            FileUtils.copyFile((File)oldFile, (File)toFile, (boolean)false);
        }
    }

    String getPublishVersionFilePathById(String id) {
        return FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), "/publish/version/ancestor", id.replace("_", "/"), "/last_publish.version"});
    }

    String getLastFileVersionFilePathById(String id) {
        return FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), "/publish/version/ancestor", id.replace("_", "/"), "/last_file.version"});
    }

    void deleteAncestor(String id) throws IOException {
        String publishPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), "/publish/version/ancestor", id.replace("_", "/")});
        if (new File(publishPath).exists()) {
            FileUtils.forceDelete((File)new File(publishPath));
        }
    }

    protected boolean fixName(File oldFile, File newFile) {
        return oldFile.renameTo(newFile);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }

    void dealRouter(String id, String newPageName, String newModuleRelatePath, boolean isDelete) throws IOException, LcdpException {
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(id);
        String projectPath = this.mobileProject(this.mobileUniProperties.getUniFrontProjectPath(), new String[0]).getLocalPath();
        String path = this.getMetaPath(id);
        File file = new File(FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath(), path + ".meta"}));
        JSONObject jsonObject = null;
        jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
        String pageName = jsonObject.get((Object)"name").toString();
        String desc = jsonObject.get((Object)"desc").toString();
        String component = FileUtil.posixPath((String[])new String[]{AppContextUtil.posixFilePathPrefix(), "views", moduleRelatePath, pageName});
        String newComponent = FileUtil.posixPath((String[])new String[]{AppContextUtil.posixFilePathPrefix(), "views", newModuleRelatePath, ToolUtil.isNotEmpty((Object)newPageName) ? newPageName : pageName});
        String routerExport = "{\n 'path': '" + newComponent + "',\n'style': {\n'navigationBarTitleText': '" + desc + "'\n}\n}";
        this.mobileUniRouterCode(component, newComponent, routerExport, projectPath, isDelete);
    }

    private void mobileUniRouterCode(String component, String newComponent, String fileContent, String vueRootPath, boolean isDelete) throws IOException {
        String path;
        vueRootPath = FileUtil.complementFilePath((String)vueRootPath);
        String filePath = vueRootPath + "/src/pages.json";
        File file = new File(filePath);
        String fileMsg = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        JSONObject parse = JSON.parseObject((String)fileMsg, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray jsonArray = JSON.parseArray((String)parse.get((Object)"pages").toString());
        boolean type = true;
        for (Object o : jsonArray) {
            path = JSON.parseObject((String)o.toString()).get((Object)"path").toString();
            if (!path.equals(component)) continue;
            jsonArray.remove(o);
            break;
        }
        for (Object o : jsonArray) {
            path = JSON.parseObject((String)o.toString()).get((Object)"path").toString();
            if (!path.equals(newComponent)) continue;
            type = false;
            break;
        }
        if (type) {
            if (!isDelete) {
                jsonArray.add((Object)JSON.parseObject((String)fileContent));
            }
            parse.put("pages", (Object)jsonArray);
        }
        if (file.exists()) {
            if (ToolUtil.isEmpty((Object)parse)) {
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)parse), (String)"UTF-8", (boolean)false);
            }
        }
    }

    private ResourcePath mobileProject(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getWorkspace(), name});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }
}

