/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.cascade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

@ClientKind(kind="com.jxdinfo.UniModule.cascade")
public class UniModuleCascadeImpl
implements ResourceCascadeVisitor {
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final MobileUniProperties mobileUniProperties = (MobileUniProperties)SpringContextHolder.getBean(MobileUniProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    public static final String KIND = "com.jxdinfo.UniModule.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
    }

    public void iteratorDirectory(File extendnewFile, BaseFile baseFile, String oldName) {
        if (ToolUtil.isNotEmpty((Object)extendnewFile) && ToolUtil.isNotEmpty((Object)extendnewFile.listFiles())) {
            for (File file : extendnewFile.listFiles()) {
                if (!file.isDirectory()) continue;
                if (file.getName().equals(oldName)) {
                    File newFile = new File(file.getParent() + File.separator + baseFile.getName());
                    if (newFile.exists()) continue;
                    this.fixName(file, newFile);
                    continue;
                }
                this.iteratorDirectory(file, baseFile, oldName);
            }
        }
    }

    public void moduleEdit(File oldFile, File newFile) {
        if (oldFile.exists() && !newFile.exists()) {
            this.fixName(oldFile, newFile);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
    }

    public void moveFrontFile(String id, String parentPath, String rootPath, String newName, String parentId) throws LcdpException, IOException {
        String path = this.getMetaPath(id);
        File from = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        File to = new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath));
        if (parentPath.contains(path) && (id.equals(parentId) || this.copyCheck(id, parentId))) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        if (from.exists()) {
            if (!to.exists()) {
                FileUtils.moveDirectory((File)from, (File)to);
            } else {
                FileUtils.moveDirectoryToDirectory((File)from, (File)to, (boolean)false);
            }
        }
    }

    private boolean copyCheck(String id, String parentId) throws IOException, LcdpException {
        BaseFile baseFile = this.fileMappingService.getPageInfoById(parentId);
        if (ToolUtil.isNotEmpty((Object)baseFile) && !"#".equals(baseFile.getParentId())) {
            if (id.equals(baseFile.getId())) {
                return true;
            }
            return this.copyCheck(id, baseFile.getParentId());
        }
        return false;
    }

    public void cascadeDelete(String id) throws LcdpException, IOException {
    }

    private void moduleDelete(File f) throws LcdpException {
        if (f.exists()) {
            try {
                FileUtils.forceDelete((File)f);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, f.getAbsolutePath());
            }
        }
    }

    private void extendModuleDelete(String rootPath, String path) throws LcdpException {
        String jsPath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendJavaScriptPath(), path});
        this.moduleDelete(new File(jsPath));
        String vuePath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendVuePath(), path});
        this.moduleDelete(new File(vuePath));
        String cssPath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendCssScriptPath(), path});
        this.moduleDelete(new File(cssPath));
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }

    void dealRouter(String id, String newPageName, String newModuleRelatePath, boolean isDelete) throws IOException, LcdpException {
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(id);
        String projectPath = this.mobileProject(this.mobileUniProperties.getUniFrontProjectPath(), new String[0]).getLocalPath();
        String path = this.getMetaPath(id);
        File file = new File(FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath(), path + ".meta"}));
        JSONObject jsonObject = null;
        jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
        String pageName = jsonObject.get((Object)"name").toString();
        String desc = jsonObject.get((Object)"desc").toString();
        String component = FileUtil.posixPath((String[])new String[]{AppContextUtil.posixFilePathPrefix(), "views", moduleRelatePath, pageName});
        String newComponent = FileUtil.posixPath((String[])new String[]{AppContextUtil.posixFilePathPrefix(), "views", newModuleRelatePath, ToolUtil.isNotEmpty((Object)newPageName) ? newPageName : pageName});
        String routerExport = "{\n 'path': '" + newComponent + "',\n'style': {\n'navigationBarTitleText': '" + desc + "'\n}\n}";
        this.mobileUniRouterCode(component, newComponent, routerExport, projectPath, isDelete);
    }

    private ResourcePath mobileProject(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getWorkspace(), name});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }

    private void mobileUniRouterCode(String component, String newComponent, String fileContent, String vueRootPath, boolean isDelete) throws IOException {
        vueRootPath = FileUtil.complementFilePath((String)vueRootPath);
        String filePath = vueRootPath + "/src/pages.json";
        File file = new File(filePath);
        String fileMsg = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        JSONObject parse = JSON.parseObject((String)fileMsg, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray jsonArray = JSON.parseArray((String)parse.get((Object)"pages").toString());
        boolean type = true;
        for (Object o : jsonArray) {
            String path = JSON.parseObject((String)o.toString()).get((Object)"path").toString();
            if (!path.equals(component)) continue;
            jsonArray.remove(o);
            break;
        }
        parse.put("pages", (Object)jsonArray);
        if (file.exists()) {
            if (ToolUtil.isEmpty((Object)parse)) {
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)parse), (String)"UTF-8", (boolean)false);
            }
        }
    }

    private void iteratorMobileFile(File file) throws IOException, LcdpException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorMobileFile(childFile);
                    }
                }
            } else if (file.getName().endsWith(".meta")) {
                JSONObject jsonObject = null;
                jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
                String id = jsonObject.get((Object)"id").toString();
                String type = jsonObject.get((Object)"type").toString();
                String parentId = jsonObject.get((Object)"parentId").toString();
                String parentPath = this.getMetaPath(parentId);
                if ("UniPage".equals(type)) {
                    this.dealRouter(id, null, parentPath, false);
                }
            }
        }
    }

    protected boolean fixName(File oldFile, File newFile) {
        return oldFile.renameTo(newFile);
    }
}

