/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.cascade;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.formdesign.publish.uni.UniPathStrategyService;
import java.io.File;
import java.io.IOException;

@ClientKind(kind="com.jxdinfo.UniDataModelJs.cascade")
public class UniModelJsCascadeImpl
implements ResourceCascadeVisitor {
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final MobileUniProperties mobileUniProperties = (MobileUniProperties)SpringContextHolder.getBean(MobileUniProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private final PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    private final UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextHolder.getBean(UniPathStrategyService.class);
    public static final String KIND = "com.jxdinfo.UniDataModelJs.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
    }

    public void cascadeCopy(String id, String newId, String newName, String parentPath) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
    }

    public void modelMove(File jsFrom, File jsTo, String newName, String parentPath, String rootPath) throws IOException, LcdpException {
        if (FileUtils.exists((File)jsFrom)) {
            if (!FileUtils.exists((File)jsTo)) {
                FileUtils.forceMkdir((File)jsTo);
            }
            if (newName != null && !newName.isEmpty()) {
                jsTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName + ".js", rootPath));
                if (!FileUtils.exists((File)jsTo)) {
                    try {
                        FileUtils.moveFile((File)jsFrom, (File)jsTo);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, jsFrom.getAbsolutePath());
                    }
                }
            } else {
                try {
                    FileUtils.moveFileToDirectory((File)jsFrom, (File)jsTo, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, jsFrom.getAbsolutePath());
                }
            }
        }
    }

    public void cascadeDelete(String id) throws LcdpException, IOException {
    }

    public void modelJsDel(File file, String oldJSFilePath) throws LcdpException {
        if (FileUtils.exists((File)file)) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldJSFilePath);
            }
        }
    }

    String getOldUniJSPath(String id, Integer strategy) throws LcdpException {
        String oldJsPath = this.fileMappingService.getFormatPath(id);
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniFrontApiPath()});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{oldJsPath + this.formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getNewUniJSPath(String id, String pageName, Integer strategy) throws LcdpException {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniFrontApiPath()});
        String newJsPath = FileUtil.systemPath((String[])new String[]{this.fileMappingService.getFormatParentPath(id), pageName});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{newJsPath + this.formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    protected boolean fixName(File oldFile, File newFile) {
        return oldFile.renameTo(newFile);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }
}

