const seriesResult = [];
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
if (oldTitle) {
    const titleLength = oldTitle.length;
    const provideLength = numberOfRow;
    const rowNumber = Math.ceil(titleLength / provideLength);
    if (titleLength > provideLength) {
        for (let i = 0; i < rowNumber; i++) {
            let tempStr = ' ';
            const start = i * provideLength;
            const end = start + provideLength;
            if (i === rowNumber - 1) {
                tempStr = oldTitle.substring(start, titleLength);
            } else {
                tempStr = oldTitle.substring(start, end)+'\n';
            }
            newTitle += tempStr;
        }
    } else {
        newTitle = oldTitle;
    }
}
const echatrsTitle = {
    text: newTitle,
    textStyle: {
        color: '${titleColor!}',
        fontSize: '${titleFontSize!}',
        fontWeight: '${fontWeight!}',
        fontStyle: '${fontStyle!}',
    },
    left: '${titleAlign!}',
    top: '${titleTop!}',
    <#if (titleBackgroundColor?? && titleBackgroundColor != "")>
        backgroundColor: '${titleBackgroundColor!}',
    </#if>
};
const echatrsTooltip = {
    formatter: `{a} \n{b} : {c}${unit}`,
    trigger: 'item',
    position: function (point, params, dom, rect, size) {
        let x = 0;
        let y = 0;
        const pointX = point[0];
        const pointY = point[1];
        const boxWidth = size.contentSize[0];
        const boxHeight = size.contentSize[1];
        if (boxWidth > pointX) {
            x = 10;
        } else {
            x = pointX - boxWidth - 10;
        }
        if (boxHeight > pointY) {
            y = 10;
        } else {
            y = pointY - boxHeight - 10;
        }
        return [x, y];
    },
    backgroundColor: '${tooltipBgColor!}',
    textStyle: {
        color: '${toolColor!}',
        fontSize: '${toolFontSize!}',
        fontWeight: '${toolFontWeight!}',
        fontStyle: '${toolFontStyle!}',
        lineHeight: '${toolLineHeight!}',
    },
};
const echartsLegend = {
  itemGap: 20,
  <#if (isShowFlag?? && isShowFlag)>
    show: true,
  <#elseif (!isShowFlag?? || !isShowFlag)>
    show: false,
  </#if>
  left: '${legendLocation!}',
  textStyle: {
    color: '${legendColor!}',
    fontSize: '${legendFontSize!}',
    fontFamily: '${legendFontFamily!}',
    fontWeight: '${legendFontWeight!}',
    fontStyle: '${legendFontStyle!}',
  },
  orient: '${itemOrient!}',
  itemWidth: ${itemWidth!},
  itemHeight: ${itemHeight!},
  top: 30,
};
const topicColorStr = ${topicColorStr!};
${optionData!}.xAxisData.forEach((col, index) => {
    seriesResult.push({
        name: col,
        value: ${optionData!}.yAxisData[index],
    });
});

return {
  color: topicColorStr,
  title: echatrsTitle,
  tooltip: echatrsTooltip,
  legend: echartsLegend,
  series: {
    name: '${pointerName!}',
    type: 'funnel',
    left: ${gridLeft!},
    top: ${gridTop!},
    right: ${gridRight!},
    bottom: ${gridBottom!},
    funnelAlign: '${funnelAlign!}',
    min: '${seriesMin!}',
    max: '${seriesMax!}',
    minSize: '${minSize!}',
    maxSize: '${maxSize!}',
    sort: '${dataSorType!}',
    gap: ${gapNum!},
    label: {
      <#if (isShowLabel?? && isShowLabel)>
        show: true,
      <#elseif (!isShowLabel?? || !isShowLabel)>
        show: false,
      </#if>
      position: '${labelPosition}',
      fontSize: ${labelFontSize!},
      fontWeight: ${labelFontWeight!},
      fontStyle: '${labelFontStyle!}',
      backgroundColor: '${labelBackgroundColor!}',
    },
    labelLine: {
      length: ${labelLineLength!},
      lineStyle: {
        color: '${labelLineColor}',
        width: ${labelLineWidth!},
        type: '${labelType!}',
      },
    },
    itemStyle: {
      borderColor: '#fff',
      borderWidth: 1,
    },
    emphasis: {
      label: {
        fontSize: ${labelFontSize!},
      },
    },
    data: seriesResult,
  },
}