/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.uniui.vistor;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DoughnutEchartsVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        lcdpComponent.registerTemplatePath("/template/uniui/uni/doughnutEcharts/doughnut_echarts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, Object> echartsParams = new HashMap<String, Object>();
        echartsParams.put("instanceKey", lcdpComponent.getInstanceKey());
        echartsParams.put("labelData", CodePrefix._SELF.getType() + lcdpComponent.getRenderParams().get("labelData"));
        echartsParams.put("valueData", CodePrefix._SELF.getType() + lcdpComponent.getRenderParams().get("valueData"));
        String defaultOptionData = "{seriesResult: [],legendEchart: []}";
        ComponentData componentData = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION_DATA.getType(), Collections.singletonList("data"), (String)defaultOptionData);
        echartsParams.put("optionData", CodePrefix._SELF.getType() + componentData.getRenderValue());
        boolean isDefaultValue = false;
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            echartsParams.put("isQuoteOrGetValue", "true");
        } else if (!ctx.getDatas().containsKey(lcdpComponent.getInstanceKey() + CodeSuffix._OPTION_DATA.getType() + ":" + defaultOptionData)) {
            isDefaultValue = true;
        }
        echartsParams.put("isDefaultValue", isDefaultValue);
        Map echartsMaps = lcdpComponent.getProps();
        if (ToolUtil.isNotEmpty((Object)echartsMaps)) {
            echartsParams.put("titleText", echartsMaps.get("title"));
            echartsParams.put("titleColor", ToolUtil.isNotEmpty(echartsMaps.get("titleColor")) ? echartsMaps.get("titleColor") : "#000");
            echartsParams.put("titleFontSize", ToolUtil.isNotEmpty(echartsMaps.get("titleFontSize")) ? echartsMaps.get("titleFontSize") : "18");
            echartsParams.put("fontStyle", echartsMaps.get("fontStyle"));
            echartsParams.put("fontWeight", echartsMaps.get("fontWeight"));
            echartsParams.put("titleAlign", ToolUtil.isNotEmpty(echartsMaps.get("titleAlign")) ? echartsMaps.get("titleAlign") : "center");
            echartsParams.put("numberOfRow", ToolUtil.isNotEmpty(echartsMaps.get("numberOfRow")) ? echartsMaps.get("numberOfRow") : "10");
            echartsParams.put("titleTop", echartsMaps.get("titleTop"));
            echartsParams.put("titleBackgroundColor", ToolUtil.isNotEmpty(echartsMaps.get("titleBackgroundColor")) ? echartsMaps.get("titleBackgroundColor") : "transparent");
            String topicColorStr = "";
            String colorSystem = echartsMaps.get("colorSystem").toString();
            if ("colour".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("colourColor").toString();
            } else if ("green".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("greenColor").toString();
            } else if ("blue".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("blueColor").toString();
            }
            echartsParams.put("topicColorStr", topicColorStr);
            echartsParams.put("withinRadius", echartsMaps.get("withinRadius").toString());
            echartsParams.put("outsideRadius", echartsMaps.get("outsideRadius").toString());
            echartsParams.put("topicSize", echartsMaps.get("topicSize").toString());
            echartsParams.put("tooltipBgColor", echartsMaps.get("tooltipBgColor"));
            echartsParams.put("toolColor", echartsMaps.get("toolColor"));
            echartsParams.put("toolFontSize", ToolUtil.isNotEmpty(echartsMaps.get("toolFontSize")) ? echartsMaps.get("toolFontSize") : "18");
            echartsParams.put("toolFontWeight", echartsMaps.get("toolFontWeight"));
            echartsParams.put("toolFontStyle", echartsMaps.get("toolFontStyle"));
            echartsParams.put("isShowFlag", echartsMaps.get("isShowFlag"));
            echartsParams.put("legendLocation", ToolUtil.isNotEmpty(echartsMaps.get("legendLocation")) ? echartsMaps.get("legendLocation") : "center");
            echartsParams.put("legendIcon", echartsMaps.get("legendIcon"));
            echartsParams.put("legendColor", ToolUtil.isNotEmpty(echartsMaps.get("legendColor")) ? echartsMaps.get("legendColor") : "#000000");
            echartsParams.put("legendFontSize", ToolUtil.isNotEmpty(echartsMaps.get("legendFontSize")) ? echartsMaps.get("legendFontSize") : "14");
            echartsParams.put("legendFontWeight", echartsMaps.get("legendFontWeight"));
            echartsParams.put("legendFontStyle", echartsMaps.get("legendFontStyle"));
            DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
            DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
            if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
                Boolean isNewDataSet = "ASSOCIATION".equals(dataSModelAnalysis.getFunctionType()) || "CUSTOM_SQL".equals(dataSModelAnalysis.getFunctionType());
                echartsParams.put("isNewDataSet", isNewDataSet);
                DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
                List paramValue = dataSModelAnalysis.getParamValue();
                Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
                String labelField = "";
                String valueField = "";
                ArrayList<String> dims = new ArrayList<String>();
                ArrayList targets = new ArrayList();
                if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                    List dataItemPath;
                    List fieldAnalyses;
                    if (!isNewDataSet.booleanValue()) {
                        for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                            fieldAnalyses = (List)fieldList.getValue();
                            for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                                dataItemPath = dataSFieldAnalysis.getDataItemPath();
                                if (ToolUtil.isNotEmpty((Object)dataItemPath) && "label".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                    labelField = dataSFieldAnalysis.getFieldName();
                                }
                                if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                                valueField = dataSFieldAnalysis.getFieldName();
                            }
                        }
                    } else {
                        for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                            fieldAnalyses = (List)fieldList.getValue();
                            for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                                HashMap<String, String> map;
                                dataItemPath = dataSFieldAnalysis.getDataItemPath();
                                String convertFieldName = dataSModelAnalysis.getModelFieldNameByAliasName(dataSFieldAnalysis.getFieldName());
                                if (ToolUtil.isNotEmpty((Object)dataItemPath) && "label".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                    dims.add(convertFieldName);
                                    map = new HashMap();
                                    map.put("columnName", convertFieldName);
                                    map.put("asAlias", convertFieldName + "Dim");
                                    targets.add(map);
                                }
                                if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                                map = new HashMap<String, String>();
                                map.put("columnName", convertFieldName);
                                map.put("agg", dataSFieldAnalysis.getAggrFunc());
                                map.put("legendName", dataSFieldAnalysis.getLegendName());
                                map.put("asAlias", convertFieldName + dataSFieldAnalysis.getAggrFunc() + "Metrics");
                                targets.add(map);
                            }
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField) || isNewDataSet.booleanValue()) {
                    String querySelectionName;
                    String operationName = "hussarQuery";
                    if (isNewDataSet.booleanValue()) {
                        operationName = "conditionECharsQuery";
                        echartsParams.put("dims", dims);
                        echartsParams.put("targets", targets);
                    }
                    String apiFileName = "";
                    String apiFilePath = "";
                    String dataModelId = dataSModelAnalysis.getDataModelId();
                    if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                        apiFileName = this.fileMappingService.getFileName(dataModelId);
                        apiFilePath = this.fileMappingService.getMobileImportPath(dataModelId);
                    }
                    if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) || ToolUtil.isNotEmpty((Object)paramValue)) {
                        List conditionList = dataSConditionAnalysis.getQueryConditionModelList();
                        if (ToolUtil.isNotEmpty((Object)conditionList) && !isNewDataSet.booleanValue()) {
                            echartsParams.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                            echartsParams.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                        } else if (isNewDataSet.booleanValue()) {
                            echartsParams.put("queryAttr", QueryAttrUtil.getDataSetQueryAttr((List)conditionList, (List)paramValue, (Ctx)ctx, (String)dataModelId));
                        }
                    }
                    if (!isNewDataSet.booleanValue()) {
                        DataSortConditionAnalysis dataSortConditionAnalysis;
                        querySelectionName = dataSConditionAnalysis.getSelectCondition();
                        if (ToolUtil.isNotEmpty((Object)querySelectionName)) {
                            operationName = operationName + querySelectionName;
                        }
                        if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition()))) {
                            String sortConditionName = dataSortConditionAnalysis.getSortCondition();
                            if (ToolUtil.isNotEmpty((Object)sortConditionName)) {
                                operationName = operationName + sortConditionName;
                            }
                            echartsParams.put("dbdHaveMethod", DataModelUtil.judgeDataModelHasOperation((String)dataModelId, (String)operationName));
                        }
                    } else {
                        String sortConditionName;
                        DataSortConditionAnalysis dataSortConditionAnalysis;
                        querySelectionName = dataSConditionAnalysis.getSelectCondition();
                        echartsParams.put("isDataSetSearch", false);
                        List allFields = ModelProvideAdapter.adaptor((String)dataModelId).getFields(dataModelId);
                        echartsParams.put("allFields", allFields);
                        if (ToolUtil.isNotEmpty((Object)querySelectionName)) {
                            echartsParams.put("isDataSetSearch", true);
                            Map queryConditions = DataModelUtil.getQueryConditionByModelIDAndName((String)dataModelId, (String)querySelectionName);
                            echartsParams.put("queryConditions", queryConditions);
                            ctx.addImports("getQueryConditionsResult", "@/utils/lowcode/queryConditionUtils");
                            ArrayList<String> queryConditionParams = new ArrayList<String>();
                            queryConditionParams.add("params");
                            ctx.addMethod(lcdpComponent.getInstanceKey() + "GetQueryConditions", queryConditionParams, RenderUtil.renderTemplate((String)"template/uniui/event/echarts_getQueryConditionsMethod.ftl", echartsParams), false, MultilineExegesisUtil.dealMethodExegesis((LcdpComponent)lcdpComponent, (String)"\u83b7\u53d6\u7b5b\u9009\u53c2\u6570\u65b9\u6cd5"));
                        }
                        if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                            Map sortConditions = DataModelUtil.getSortConditionByModelIDAndName((String)dataModelId, (String)sortConditionName);
                            echartsParams.put("sortConditions", sortConditions);
                            echartsParams.put("orders", RenderUtil.renderTemplate((String)"template/uniui/event/sortCondition.ftl", echartsParams));
                        }
                    }
                    if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                        EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                    }
                    echartsParams.put("importName", apiFileName);
                    echartsParams.put("importMethod", operationName);
                    echartsParams.put("xAxisCols", labelField);
                    echartsParams.put("seriesCols", valueField);
                }
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addComputed(lcdpComponent.getInstanceKey() + "EchartsData", RenderUtil.renderTemplate((String)"/template/uniui/uni/doughnutEcharts/doughnut_echarts_computed.ftl", echartsParams));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "GetOptionItem", RenderUtil.renderTemplate((String)"/template/uniui/uni/doughnutEcharts/doughnut_echarts_success.ftl", echartsParams));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "GetOptionItem();");
        }
    }
}

