/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsCheckVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFileInfo;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFileVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsPathVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsRelationVO;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendJsService;
import com.jxdinfo.hussar.formdesign.extend.service.common.ExtendJsCommonImpl;
import com.jxdinfo.hussar.formdesign.extend.util.ParsingUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import com.jxdinfo.hussar.formdesign.publish.uni.UniPathStrategyService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

@ClientKind(kind="com.jxdinfo.UniPage.extend.js")
public class ExtendMobileUniJsServiceImpl
extends BaseFileServiceImpl<ExtendJsFileInfo>
implements ExtendJsService {
    private PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
    private UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextUtil.getBean(UniPathStrategyService.class);
    private FormDesignProperties speedCodeProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
    private MobileUniProperties mobileUniProperties = (MobileUniProperties)SpringContextUtil.getBean(MobileUniProperties.class);
    private FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);

    public ApiResponse<List<ExtendJsPathVO>> listJs() throws LcdpException, IOException {
        return ApiResponse.success((Object)ExtendJsCommonImpl.listJs((String)this.pathStrategy.resourcePathService().getProjectAndCodePath(), (String)this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), (String)"UniPage"));
    }

    public ApiResponse<ExtendJsCheckVO> getErrorForJs(String filePath) throws LcdpException {
        return ApiResponse.success((Object)ExtendJsCommonImpl.getErrorForJs((String)this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), (String)filePath, (String)"UniPage"));
    }

    public ApiResponse<ExtendJsFileVO> listMethod(String filePath, String fileId) throws IOException, LcdpException {
        if (StringUtil.isNotBlank((CharSequence)fileId) && !this.fileMappingService.isFileExist(fileId)) {
            return ApiResponse.fail((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (StringUtil.isEmpty((Object)filePath) && StringUtil.isNotBlank((CharSequence)fileId)) {
            return ApiResponse.success((Object)ExtendJsCommonImpl.listMethodByStorage((String)this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), (ExtendJsFileInfo)((ExtendJsFileInfo)this.get(fileId)), (String)"UniPage"));
        }
        if (StringUtil.isNotBlank((CharSequence)filePath) && StringUtil.isEmpty((Object)fileId)) {
            return ApiResponse.success((Object)ExtendJsCommonImpl.listMethodByPath((String)this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), (String)filePath, (String)"UniPage"));
        }
        if (StringUtil.isNotBlank((CharSequence)filePath) && StringUtil.isNotBlank((CharSequence)fileId)) {
            return ApiResponse.success((Object)ExtendJsCommonImpl.listMethodByPathAndStorage((String)this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), (String)filePath, (ExtendJsFileInfo)((ExtendJsFileInfo)this.get(fileId)), (String)"UniPage"));
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
    }

    public ApiResponse<Boolean> saveJsFile(ExtendJsFileInfo fileInfo) throws IOException, LcdpException {
        if (this.fileMappingService.isFileExist(fileInfo.getId())) {
            this.updateFile((BaseFile)fileInfo);
        } else {
            if (this.checkExists(fileInfo.getFilePath())) {
                return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
            }
            this.create((BaseFile)fileInfo);
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<String> getJsContentByPath(String filePath) throws LcdpException {
        if (StringUtil.isEmpty((Object)filePath)) {
            return ApiResponse.fail((IResultCode)ResultCode.NO_EXIST_RESOURCE);
        }
        return ApiResponse.success((String)ExtendJsCommonImpl.getJsContentByPath((String)this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), (String)filePath, (String)"UniPage"));
    }

    public ApiResponse<List<ExtendJsRelationVO>> getRelation(String fileId, String functionName) throws IOException, LcdpException {
        return null;
    }

    private boolean checkExists(String filePath) throws LcdpException, IOException {
        String metaPath = this.pathStrategy.resourcePathService().getProjectAndCodePath();
        List metaList = ParsingUtil.getFilePath((String)metaPath, (String)".mjsd.meta");
        try {
            for (String path : metaList) {
                String content = FileUtils.readFileToString((File)new File(path), (String)"UTF-8");
                ExtendJsFileInfo fileInfo = (ExtendJsFileInfo)JSON.parseObject((String)content, ExtendJsFileInfo.class);
                if (!filePath.replaceAll("\\\\", "/").equals(fileInfo.getFilePath().replaceAll("\\\\", "/")) || !fileInfo.getType().equals("UniFrontScript")) continue;
                return true;
            }
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
        return false;
    }
}

