/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.uniui.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.form.FormColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.uniui.JXDMobileTable.value")
@Scope(value="prototype")
public class TableValueProvide
implements ValueVisitor<LcdpComponent, Ctx> {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) throws LcdpException {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem;
            switch (dataItem = dataItems.get(0)) {
                case "page": {
                    this.getPageData(dataItems, data);
                    break;
                }
                case "total": {
                    data.setDataType(ComponentData.DataTypeEnum.INTEGER);
                    data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"ListTotal", dataItems));
                    break;
                }
                default: {
                    this.getTableValueData(dataItems, data);
                    break;
                }
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            ArrayList<String> currDataItem = new ArrayList<String>();
            currDataItem.add("item");
            data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"ListData", currDataItem));
        }
        return data;
    }

    public ComponentData getDefaultValueByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    private void getPageData(List<String> dataItems, ComponentData data) throws LcdpException {
        ArrayList<String> pageDataItem = new ArrayList<String>();
        pageDataItem.add("page");
        String pageValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"Page", pageDataItem);
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.INTEGER);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            if ("current".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".current");
            } else if ("size".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".size");
            } else if ("total".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".total");
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.OBJECT);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            data.setRenderValue(pageValue);
        }
    }

    private void getTableValueData(List<String> dataItems, ComponentData data) throws LcdpException {
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        ArrayList<String> currDataItem = new ArrayList<String>();
        currDataItem.add("value");
        if (ToolUtil.isNotEmpty(dataItems) && dataItems.size() == 2) {
            this.getListItemData(dataItems.get(1), data);
        } else if (ToolUtil.isNotEmpty(dataItems) && dataItems.size() == 1 && !"value".equals(dataItems.get(0))) {
            this.getListItemData(dataItems.get(0), data);
        } else {
            String dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"ListData", currDataItem);
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            data.setRenderValue(dataValue);
        }
    }

    private void getListItemData(String dataItems, ComponentData data) {
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("opt_cols");
        for (Object col : cols) {
            JSONObject colObj = (JSONObject)col;
            if (!colObj.getString("id").equals(dataItems)) continue;
            data.setRenderValue(this.lcdpComponent.getInstanceKey() + "Item." + colObj.getString("field"));
            data.setDataType(((JSONObject)col).getString("dataType"));
            break;
        }
    }

    private void getOptColData(List<String> dataItems, ComponentData data, String dataValue, JSONArray cols) {
        if (ToolUtil.isNotEmpty((Object)cols)) {
            List colsList = cols.toJavaList(TableOptColsAnalysis.class);
            for (TableOptColsAnalysis col : colsList) {
                if (!col.getId().equals(dataItems.get(1))) continue;
                data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                if (col.getRowSummary() && ToolUtil.isNotEmpty((Object)col.getRowCalculate())) {
                    data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((row) => result.push(" + col.getRowCalculate().getEditFormulaReplace() + "));return result;}()");
                    break;
                }
                data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((item) => result.push(item." + col.getField() + "));return result;}()");
                break;
            }
        }
    }

    public List<ComponentData> getClearValue(List<String> list) throws LcdpException {
        return null;
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        return null;
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._LIST_ITEM_DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("opt_cols");
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (ToolUtil.isNotEmpty((Object)cols)) {
            List formColsList = cols.toJavaList(FormColsAnalysis.class);
            formColsList.forEach(col -> map.put(col.getId(), col.getField()));
        }
        return map;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public String getDefaultValue() {
        return "''";
    }
}

