/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.parser;

import com.jxdinfo.hussar.formdesign.common.constant.ExtendScriptTypeEnum;
import com.jxdinfo.hussar.formdesign.common.model.script.ExtendWScript;
import com.jxdinfo.hussar.formdesign.common.parser.ScriptParser;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extend.factory.ScriptParseFactory;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsMethodVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsParam;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendUniWJsScript;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class UniJsScriptParser
implements ScriptParser {
    private static final Pattern METHOD_NAME_PARAM_PATTERN = Pattern.compile("(export)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))");
    private static final Pattern PARAM_NAME_PATTERN = Pattern.compile("(?<=\\()(.*?)(?=\\))");
    private static final Pattern NAME_NOTE_SPATTERN = Pattern.compile("(@name)(.*?)(export)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))");
    private static final Pattern NAME_PATTERN = Pattern.compile("(@name)(.*?)((\\*\\s@)|(\\*\\/))");
    private static final Pattern CHINESE_NAME_PATTERN = Pattern.compile("(function)(.*?)(\\()");
    private static final Pattern DESCRIPTION_NOTE_SPATTERN = Pattern.compile("(@description)(.*?)(export)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))");
    private static final Pattern PARAM_NOTE_SPATTERN = Pattern.compile("(\\@param)(.*?)(export)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))");
    private static final Pattern PARAM_PATTERN = Pattern.compile("(@param)(.*?)(\\*\\/)");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("(@description)(.*?)((\\*\\s@)|(\\*\\/))");
    private static final Pattern RETURN_NOTE_SPATTERN = Pattern.compile("(@return(s)?)(.*?)(export)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))");
    private static final Pattern RETURN_COUNT = Pattern.compile("(@return(s)?)(.*?)(export)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))(\\s*)(\\{[^\\*](.*?)\\})");
    private static final Pattern RETURN_PATTERN = Pattern.compile("(@return(s)?)(.*?)(\\*)");

    @PostConstruct
    public void register() {
        ScriptParseFactory.register((String)ExtendScriptTypeEnum.UNI_JS_SCRIPT.getType(), (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public ExtendWScript parseScript(String editorNote) {
        ExtendUniWJsScript extendWJsScript = new ExtendUniWJsScript();
        ArrayList<ExtendJsMethodVO> methodList = new ArrayList<ExtendJsMethodVO>();
        String jsContent = editorNote;
        jsContent = jsContent.replaceAll("[\r\n]", "").replaceAll("\\u00A0", "");
        Matcher methodNameMatcher = METHOD_NAME_PARAM_PATTERN.matcher(jsContent);
        StringBuilder methodGroup = new StringBuilder();
        while (methodNameMatcher.find()) {
            methodGroup.append(methodNameMatcher.group());
        }
        if (StringUtil.isEmpty((Object)methodGroup.toString())) {
            extendWJsScript.setMethods(methodList);
            return extendWJsScript;
        }
        String[] methodName = methodGroup.toString().replaceAll("(export\\s)", "").replaceAll("(function\\s)", "").replaceAll("\\((.*?)\\)", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
        List<String> methodNameList = Arrays.asList(methodName);
        Matcher paramNameMatcher = PARAM_NAME_PATTERN.matcher(methodGroup.toString());
        ArrayList<String> paramNameList = new ArrayList<String>();
        while (paramNameMatcher.find()) {
            paramNameList.add(paramNameMatcher.group());
        }
        Matcher nameNotesMatcher = NAME_NOTE_SPATTERN.matcher(jsContent);
        StringBuffer nameNotesGroup = new StringBuffer();
        while (nameNotesMatcher.find()) {
            nameNotesGroup.append(nameNotesMatcher.group());
        }
        String[] chineseNames = null;
        String[] chineseNameMethodName = null;
        if (!ToolUtil.isEmpty((Object)nameNotesGroup)) {
            Matcher nameMatcher = NAME_PATTERN.matcher(nameNotesGroup.toString());
            StringBuilder chineseNameGroup = new StringBuilder();
            while (nameMatcher.find()) {
                chineseNameGroup.append(nameMatcher.group());
            }
            chineseNames = chineseNameGroup.toString().replaceAll("((\\*\\s@)|(\\*\\/))", "&&,&&,&&").replaceAll("@name", "").split("&&,&&,&&");
            Matcher chineseNameMatcher = CHINESE_NAME_PATTERN.matcher(nameNotesGroup.toString());
            StringBuilder chineseGroup = new StringBuilder();
            while (chineseNameMatcher.find()) {
                chineseGroup.append(chineseNameMatcher.group());
            }
            chineseNameMethodName = chineseGroup.toString().replaceAll("export", "").replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
        }
        Matcher returncounts = RETURN_COUNT.matcher(jsContent);
        StringBuilder counts = new StringBuilder();
        while (returncounts.find()) {
            counts.append(returncounts.group()).append("&&,&&,&&");
        }
        String[] allreturns = counts.toString().split("&&,&&,&&");
        HashMap<String, String> returnMaps = new HashMap<String, String>();
        for (String s : allreturns) {
            Matcher returnNoteMather = RETURN_NOTE_SPATTERN.matcher(s);
            StringBuilder returnNoteGroup = new StringBuilder();
            while (returnNoteMather.find()) {
                returnNoteGroup.append(returnNoteMather.group());
            }
            Matcher chineseNameMatcher = CHINESE_NAME_PATTERN.matcher(returnNoteGroup.toString());
            StringBuilder chineseGroup = new StringBuilder();
            while (chineseNameMatcher.find()) {
                chineseGroup.append(chineseNameMatcher.group());
            }
            String returnMethodName = chineseGroup.toString().replaceAll("export", "").replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").replaceAll("&&,&&,&&", "");
            returnMaps.put(returnMethodName, s);
        }
        Matcher returnNotesMather = RETURN_NOTE_SPATTERN.matcher(jsContent);
        StringBuilder returnNotesGroup = new StringBuilder();
        while (returnNotesMather.find()) {
            returnNotesGroup.append(returnNotesMather.group());
        }
        String[] returns = null;
        String[] returnMethodName = null;
        if (!ToolUtil.isEmpty((Object)returnNotesGroup)) {
            Matcher returnMatcher = RETURN_PATTERN.matcher(returnNotesGroup.toString());
            StringBuilder returnGroup = new StringBuilder();
            while (returnMatcher.find()) {
                returnGroup.append(returnMatcher.group());
            }
            returns = returnGroup.toString().replaceAll("\\*", "&&,&&,&&").replaceAll("@return(s)?", "").split("&&,&&,&&");
            Matcher functionReturnMatcher = CHINESE_NAME_PATTERN.matcher(returnNotesGroup.toString());
            StringBuilder functionReturnGroup = new StringBuilder();
            while (functionReturnMatcher.find()) {
                functionReturnGroup.append(functionReturnMatcher.group());
            }
            returnMethodName = functionReturnGroup.toString().replaceAll("export", "").replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
        }
        Matcher descriptionNotesMatcher = DESCRIPTION_NOTE_SPATTERN.matcher(jsContent);
        StringBuffer descriptionNotesGroup = new StringBuffer();
        while (descriptionNotesMatcher.find()) {
            descriptionNotesGroup.append(descriptionNotesMatcher.group());
        }
        String[] descriptions = null;
        String[] descriptionMethodName = null;
        if (!ToolUtil.isEmpty((Object)descriptionNotesGroup)) {
            Matcher descriptionMatcher = DESCRIPTION_PATTERN.matcher(descriptionNotesGroup.toString());
            StringBuilder descriptionGroup = new StringBuilder();
            while (descriptionMatcher.find()) {
                descriptionGroup.append(descriptionMatcher.group());
            }
            descriptions = descriptionGroup.toString().replaceAll("((\\*\\s@)|(\\*\\/))", "&&,&&,&&").replaceAll("@description", "").split("&&,&&,&&");
            Matcher functionDescriptionMatcher = CHINESE_NAME_PATTERN.matcher(descriptionNotesGroup.toString());
            StringBuilder functionDescriptionGroup = new StringBuilder();
            while (functionDescriptionMatcher.find()) {
                functionDescriptionGroup.append(functionDescriptionMatcher.group());
            }
            descriptionMethodName = functionDescriptionGroup.toString().replaceAll("export", "").replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
        }
        Matcher paramNotesMatcher = PARAM_NOTE_SPATTERN.matcher(jsContent);
        StringBuffer paramNotesGroup = new StringBuffer();
        while (paramNotesMatcher.find()) {
            paramNotesGroup.append(paramNotesMatcher.group());
        }
        Matcher paramMatcher = PARAM_PATTERN.matcher(paramNotesGroup.toString());
        StringBuilder paramGroup = new StringBuilder();
        while (paramMatcher.find()) {
            paramGroup.append(paramMatcher.group());
        }
        String[] paramDescription = paramGroup.toString().replaceAll("(\\*\\s@)", "&&,&&,&&").replaceAll("&&,&&,&&param", "&&,&&,&&").replaceAll("@param", "").replaceAll("\\*\\/", "&&;&&").split("&&;&&");
        Matcher paramFunctionNameMatcher = CHINESE_NAME_PATTERN.matcher(paramNotesGroup);
        StringBuilder containParamFunction = new StringBuilder();
        while (paramFunctionNameMatcher.find()) {
            containParamFunction.append(paramFunctionNameMatcher.group());
        }
        String[] paramMethodName = containParamFunction.toString().replaceAll("export", "").replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
        for (int i = 0; i < methodNameList.size(); ++i) {
            int j;
            int j2;
            ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
            ArrayList<ExtendJsParam> paramList = new ArrayList<ExtendJsParam>();
            ExtendJsMethodVO extendJsMethodVO = new ExtendJsMethodVO();
            if (StringUtil.isNotBlank((CharSequence)((CharSequence)paramNameList.get(i)))) {
                String[] oneMethodParam;
                for (String s : oneMethodParam = ((String)paramNameList.get(i)).split(",")) {
                    ExtendJsParam extendJsParam = new ExtendJsParam();
                    extendJsParam.setName(s.trim());
                    paramList.add(extendJsParam);
                }
            }
            for (j2 = 0; j2 < paramMethodName.length; ++j2) {
                String[] methodParamNotes;
                if (!paramMethodName[j2].equals(methodNameList.get(i))) continue;
                for (String methodParamNote : methodParamNotes = paramDescription[j2].split("&&,&&,&&")) {
                    String[] oneMethodParamNotes = methodParamNote.trim().replaceAll("\\s{1,}", " ").split(" ");
                    for (ExtendJsParam extendJsParam : paramList) {
                        if (!extendJsParam.getName().equals(oneMethodParamNotes[0]) || oneMethodParamNotes.length < 2) continue;
                        String content = oneMethodParamNotes[1];
                        for (int k = 2; k < oneMethodParamNotes.length; ++k) {
                            content = content + " " + oneMethodParamNotes[k];
                        }
                        extendJsParam.setDescription(content);
                        result.put(oneMethodParamNotes[0], content);
                    }
                }
            }
            if (descriptionMethodName != null) {
                for (j2 = 0; j2 < descriptionMethodName.length; ++j2) {
                    if (!descriptionMethodName[j2].equals(methodNameList.get(i))) continue;
                    extendJsMethodVO.setAnnotation(descriptions[j2].trim());
                }
            }
            String[] notess = editorNote.split("\n");
            String startLine = "";
            String endLine = "";
            int right = 0;
            int left = 0;
            block25: for (j = 0; j < notess.length && (startLine.isEmpty() || endLine.isEmpty()); ++j) {
                String cname = "(export)(\\s*)(function)(\\s*)" + methodNameList.get(i) + "(\\s*)";
                Pattern cnamePattern = Pattern.compile(cname);
                Matcher nameMatcher = cnamePattern.matcher(editorNote);
                if (!notess[j].contains(methodNameList.get(i)) || !notess[j].contains("export") || !notess[j].contains("function") || !nameMatcher.find()) continue;
                startLine = String.valueOf(j + 1);
                for (int k = j; k < notess.length; ++k) {
                    if ((left += this.countNum(notess[k], "{").intValue()) != (right += this.countNum(notess[k], "}").intValue()) || left == 0) continue;
                    endLine = String.valueOf(k + 1);
                    left = 0;
                    right = 0;
                    continue block25;
                }
            }
            extendJsMethodVO.setStartLine(startLine);
            extendJsMethodVO.setEndLine(endLine);
            if (returnMethodName != null) {
                for (j = 0; j < returnMethodName.length; ++j) {
                    String[] num;
                    if (!returnMethodName[j].equals(methodNameList.get(i)) || !ToolUtil.isNotEmpty(returnMaps.get(methodNameList.get(i))) || (num = ((String)returnMaps.get(methodNameList.get(i))).split("return")).length <= 2) continue;
                    HashMap<String, Object> returnValue = new HashMap<String, Object>();
                    String[] ss = returns[j].trim().split("}");
                    Object[] s = new String[ss.length];
                    Arrays.fill(s, "");
                    System.arraycopy(ss, 0, s, 0, ss.length);
                    if (((String)s[0]).contains("{")) {
                        if (s.length == 1) {
                            returnValue.put("type", ((String)s[0]).substring(((String)s[0]).indexOf("{") + 1).trim());
                            returnValue.put("description", "");
                        }
                        if (s.length == 2) {
                            returnValue.put("type", ((String)s[0]).substring(((String)s[0]).indexOf("{") + 1).trim());
                            returnValue.put("description", s[1]);
                        }
                    } else {
                        returnValue.put("type", "");
                        returnValue.put("description", s[0]);
                    }
                    extendJsMethodVO.setReturnValue(returnValue);
                }
            }
            if (chineseNameMethodName != null) {
                for (j = 0; j < chineseNameMethodName.length; ++j) {
                    if (!chineseNameMethodName[j].equals(methodNameList.get(i))) continue;
                    extendJsMethodVO.setDescription(chineseNames[j].trim());
                }
            }
            extendJsMethodVO.setName(methodNameList.get(i));
            extendJsMethodVO.setParams(paramList);
            methodList.add(extendJsMethodVO);
        }
        extendWJsScript.setMethods(methodList);
        extendWJsScript.setEditorNote(editorNote);
        return extendWJsScript;
    }

    public Integer countNum(String str, String target) {
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(target, index)) != -1) {
            index += target.length();
            ++count;
        }
        return count;
    }
}

