/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.uniui.vistor;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DoughnutEchartsVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        lcdpComponent.registerTemplatePath("/template/uniui/uni/doughnutEcharts/doughnut_echarts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, Object> echartsParams = new HashMap<String, Object>();
        echartsParams.put("instanceKey", lcdpComponent.getInstanceKey());
        echartsParams.put("labelData", CodePrefix._SELF.getType() + lcdpComponent.getRenderParams().get("labelData"));
        echartsParams.put("valueData", CodePrefix._SELF.getType() + lcdpComponent.getRenderParams().get("valueData"));
        String defaultOptionData = "{seriesResult: [],legendEchart: []}";
        ComponentData componentData = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION_DATA.getType(), Collections.singletonList("data"), (String)defaultOptionData);
        echartsParams.put("optionData", CodePrefix._SELF.getType() + componentData.getRenderValue());
        boolean isDefaultValue = false;
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            echartsParams.put("isQuoteOrGetValue", "true");
        } else if (!ctx.getDatas().containsKey(lcdpComponent.getInstanceKey() + CodeSuffix._OPTION_DATA.getType() + ":" + defaultOptionData)) {
            isDefaultValue = true;
        }
        echartsParams.put("isDefaultValue", isDefaultValue);
        Map echartsMaps = lcdpComponent.getProps();
        if (ToolUtil.isNotEmpty((Object)echartsMaps)) {
            echartsParams.put("titleText", echartsMaps.get("title"));
            echartsParams.put("titleColor", ToolUtil.isNotEmpty(echartsMaps.get("titleColor")) ? echartsMaps.get("titleColor") : "#000");
            echartsParams.put("titleFontSize", ToolUtil.isNotEmpty(echartsMaps.get("titleFontSize")) ? echartsMaps.get("titleFontSize") : "18");
            echartsParams.put("fontStyle", echartsMaps.get("fontStyle"));
            echartsParams.put("fontWeight", echartsMaps.get("fontWeight"));
            echartsParams.put("titleAlign", ToolUtil.isNotEmpty(echartsMaps.get("titleAlign")) ? echartsMaps.get("titleAlign") : "center");
            echartsParams.put("numberOfRow", ToolUtil.isNotEmpty(echartsMaps.get("numberOfRow")) ? echartsMaps.get("numberOfRow") : "10");
            echartsParams.put("titleTop", echartsMaps.get("titleTop"));
            echartsParams.put("titleBackgroundColor", ToolUtil.isNotEmpty(echartsMaps.get("titleBackgroundColor")) ? echartsMaps.get("titleBackgroundColor") : "transparent");
            String topicColorStr = "";
            String colorSystem = echartsMaps.get("colorSystem").toString();
            if ("colour".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("colourColor").toString();
            } else if ("green".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("greenColor").toString();
            } else if ("blue".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("blueColor").toString();
            }
            echartsParams.put("topicColorStr", topicColorStr);
            echartsParams.put("withinRadius", echartsMaps.get("withinRadius").toString());
            echartsParams.put("outsideRadius", echartsMaps.get("outsideRadius").toString());
            echartsParams.put("topicSize", echartsMaps.get("topicSize").toString());
            echartsParams.put("tooltipBgColor", echartsMaps.get("tooltipBgColor"));
            echartsParams.put("toolColor", echartsMaps.get("toolColor"));
            echartsParams.put("toolFontSize", ToolUtil.isNotEmpty(echartsMaps.get("toolFontSize")) ? echartsMaps.get("toolFontSize") : "18");
            echartsParams.put("toolFontWeight", echartsMaps.get("toolFontWeight"));
            echartsParams.put("toolFontStyle", echartsMaps.get("toolFontStyle"));
            echartsParams.put("isShowFlag", echartsMaps.get("isShowFlag"));
            echartsParams.put("legendLocation", ToolUtil.isNotEmpty(echartsMaps.get("legendLocation")) ? echartsMaps.get("legendLocation") : "center");
            echartsParams.put("legendIcon", echartsMaps.get("legendIcon"));
            echartsParams.put("legendColor", ToolUtil.isNotEmpty(echartsMaps.get("legendColor")) ? echartsMaps.get("legendColor") : "#000000");
            echartsParams.put("legendFontSize", ToolUtil.isNotEmpty(echartsMaps.get("legendFontSize")) ? echartsMaps.get("legendFontSize") : "14");
            echartsParams.put("legendFontWeight", echartsMaps.get("legendFontWeight"));
            echartsParams.put("legendFontStyle", echartsMaps.get("legendFontStyle"));
            DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
            DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
            if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
                DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
                Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
                String labelField = "";
                String valueField = "";
                if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                    for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                        List fieldAnalyses = (List)fieldList.getValue();
                        for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                            List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                            if (ToolUtil.isNotEmpty((Object)dataItemPath) && "label".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                labelField = dataSFieldAnalysis.getFieldName();
                            }
                            if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                            valueField = dataSFieldAnalysis.getFieldName();
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField)) {
                    DataSortConditionAnalysis dataSortConditionAnalysis;
                    String querySelectionName;
                    List conditionList;
                    String operationName = "hussarQuery";
                    String apiFileName = "";
                    String apiFilePath = "";
                    String dataModelId = dataSModelAnalysis.getDataModelId();
                    if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                        apiFileName = this.fileMappingService.getFileName(dataModelId);
                        apiFilePath = this.fileMappingService.getMobileImportPath(dataModelId);
                    }
                    if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                        echartsParams.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                        echartsParams.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                    }
                    if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                        operationName = operationName + querySelectionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition()))) {
                        String sortConditionName = dataSortConditionAnalysis.getSortCondition();
                        if (ToolUtil.isNotEmpty((Object)sortConditionName)) {
                            operationName = operationName + sortConditionName;
                        }
                        echartsParams.put("dbdHaveMethod", DataModelUtil.judgeDataModelHasOperation((String)dataModelId, (String)operationName));
                    }
                    if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                        EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                    }
                    echartsParams.put("importName", apiFileName);
                    echartsParams.put("importMethod", operationName);
                    echartsParams.put("xAxisCols", labelField);
                    echartsParams.put("seriesCols", valueField);
                }
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addComputed(lcdpComponent.getInstanceKey() + "EchartsData", RenderUtil.renderTemplate((String)"/template/uniui/uni/doughnutEcharts/doughnut_echarts_computed.ftl", echartsParams));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionItem", RenderUtil.renderTemplate((String)"/template/uniui/uni/doughnutEcharts/doughnut_echarts_success.ftl", echartsParams));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "OptionItem();");
        }
    }
}

