/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.uniui.vistor;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.RootComponent;
import com.jxdinfo.hussar.formdesign.codegenerator.core.model.CssFileModel;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.ExtendCommonUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.ExtendFormulaUtil;
import com.jxdinfo.hussar.formdesign.common.constant.SectionConstants;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.ctx.MobileUniCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.params.ComponentPageParams;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaCompileReferMethod;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FrameworkVoidVisitor
implements VoidVisitor<LcdpComponent, MobileUniCtx> {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, MobileUniCtx ctx) throws Exception {
        this.renderState(lcdpComponent, ctx);
        RootComponent rootComponent = (RootComponent)lcdpComponent;
        rootComponent.initPageState();
        this.renderExtendScopedStyles(lcdpComponent, ctx);
        lcdpComponent.registerTemplatePath("/template/uniui/uni/framework/framework.ftl");
        lcdpComponent.addRenderParam("datas", (Object)ctx.getDatas());
        lcdpComponent.addRenderParam("methods", (Object)ctx.getMethods());
        lcdpComponent.addRenderParam("watches", (Object)ctx.getWatches());
        lcdpComponent.addRenderParam("computeds", (Object)ctx.getComputeds());
        lcdpComponent.addRenderParam("computedWithGetSets", (Object)ctx.getComputedWithGetSets());
        lcdpComponent.addRenderParam("createds", (Object)ctx.getCreateds());
        lcdpComponent.addRenderParam("mounteds", (Object)ctx.getMounteds());
        lcdpComponent.addRenderParam("destroyeds", (Object)ctx.getDestroyeds());
        lcdpComponent.addRenderParam("pageName", (Object)ctx.getPageName());
        lcdpComponent.addRenderParam("importScripts", (Object)ctx.getImports());
        lcdpComponent.addRenderParam("styles", (Object)ctx.getStyles());
        lcdpComponent.addRenderParam("extendScopedStyles", (Object)ctx.getExtendScopedStyles());
        lcdpComponent.addRenderParam("filters", (Object)ctx.getFilter());
        lcdpComponent.addRenderParam("components", (Object)ctx.getComponents());
        lcdpComponent.addRenderParam("rootInstanceKey", (Object)lcdpComponent.getInstanceKey());
        lcdpComponent.addRenderParam("directives", (Object)SectionConstants.VUE_DEFAULT_DIRECTIVES);
        lcdpComponent.addRenderParam("dicts", (Object)ctx.getDictInfo().getDicts());
        lcdpComponent.addRenderParam("optionLoads", (Object)ctx.getDictInfo().getOptionLoads());
        lcdpComponent.addRenderParam("levelDicts", (Object)ctx.getDictInfo().getLevelDicts());
        lcdpComponent.addRenderParam("treeLoads", (Object)ctx.getDictInfo().getTreeLoads());
        lcdpComponent.addRenderParam("dictMethod", (Object)"GET_DICT_BY_TYPES");
        lcdpComponent.addRenderParam("treeMethod", (Object)"GET_LEVEL_DICT_BY_TYPES");
        lcdpComponent.addRenderParam("onLoads", ctx.getOnLoads());
        lcdpComponent.addRenderParam("onPullDownRefreshs", ctx.getOnPullDownRefreshs());
        this.renderPageProps(lcdpComponent, ctx);
        this.renderImport(lcdpComponent, ctx);
        this.renderFlowData(lcdpComponent, ctx);
        this.renderOnload(lcdpComponent, ctx);
        this.renderPoll(lcdpComponent, ctx);
        this.renderRouter(ctx);
    }

    private void renderState(LcdpComponent lcdpComponent, MobileUniCtx ctx) throws LcdpException {
        String rootKey = ctx.getRootLcdpComponent().getInstanceKey();
        String commonStateMeName = ctx.getRootLcdpComponent().getInstanceKey() + "PageCommonStateMe";
        StringBuilder allState = new StringBuilder();
        allState.append(this.unsureMethod(commonStateMeName));
        ctx.addMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe", ToolUtil.isNotEmpty((Object)allState) ? allState.toString() : "", false, "\u9875\u9762\u72b6\u6001\u65b9\u6cd5");
        String bpmStateName = this.unsureMethod(rootKey + "BpmStateHandler");
        ctx.addMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe", ToolUtil.isNotEmpty((Object)bpmStateName) ? bpmStateName : "", false, "\u9875\u9762\u72b6\u6001\u65b9\u6cd5");
        StringBuilder stringBuilder = new StringBuilder();
        RootComponent rootComponent = (RootComponent)lcdpComponent;
        stringBuilder.append("const failButContinue = true;\n");
        stringBuilder.append("flowAuth.getOnlineConfig().then((res) => {\nif (res && res.msg === 'true') {\n");
        this.renderFlowAuth(lcdpComponent, ctx, stringBuilder);
        stringBuilder.append("} else {\n");
        Map states = rootComponent.getPageState();
        rootComponent.initPageState();
        if (ToolUtil.isNotEmpty((Object)states)) {
            stringBuilder.append(this.unsureMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe"));
        }
        stringBuilder.append(CodePrefix._SELF.getType() + "alreadyLoad = true;\n");
        stringBuilder.append("if(callBack && typeof callBack === 'function') {callBack();}");
        stringBuilder.append("}\n");
        if (ToolUtil.isNotEmpty((Object)states)) {
            for (Map.Entry state : states.entrySet()) {
                if (!((String)state.getKey()).equals("common")) continue;
                stringBuilder.append(this.unsureMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe"));
            }
        }
        stringBuilder.append("}).catch(() => {HussarRouterMobile.mobileMessage('\u6570\u636e\u8bf7\u6c42\u5f02\u5e38', 'error');});");
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("pageParams");
        args.add("callBack");
        ctx.addMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageRenderAllState", args, ToolUtil.isNotEmpty((Object)stringBuilder) ? stringBuilder.toString() : "", false, "\u5de5\u4f5c\u6d41\u8868\u5355\u6743\u9650\u65b9\u6cd5");
        ctx.addMounted(CodePrefix._SELF.getType() + ctx.getRootLcdpComponent().getInstanceKey() + "PageRenderAllState" + "({processDefinitionKey: HussarRouterMobile.query('processDefinitionKey'),doneListIdentification: HussarRouterMobile.query('doneListIdentification'),taskDefinitionKey: HussarRouterMobile.query('taskDefinitionKey'),});");
    }

    private void renderExtendScopedStyles(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        if (lcdpComponent.getProps().get("cssFiles") != null) {
            List cssFileModels = JSON.parseArray((String)lcdpComponent.getProps().get("cssFiles").toString(), CssFileModel.class);
            for (CssFileModel cssFileModel : cssFileModels) {
                if (ToolUtil.isEmpty((Object)cssFileModel.getFileId())) continue;
                String path = FileUtil.posixPath((String[])new String[]{this.fileMappingService.getFormatPath(cssFileModel.getFileId())});
                ctx.addExtendScopedStyles("<style scoped src=\"" + ExtendCommonUtil.addExtendCSSImport((Ctx)ctx, (String)path) + "\"></style>");
            }
        }
    }

    private String unsureMethod(String methodName) {
        return "if(self." + methodName + "){self." + methodName + "();}";
    }

    private void renderFlowAuth(LcdpComponent lcdpComponent, MobileUniCtx ctx, StringBuilder stringBuilder) throws LcdpException {
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)ctx.getStrategy())) {
            moduleMap.put("strategy", true);
        }
        ctx.addData("alreadyLoad: false", MultilineExegesisUtil.dealDataExegesis((String)"\u9875\u9762", (String)"alreadyLoad\u5c5e\u6027"));
        lcdpComponent.addRenderParam("isProduce", (Object)true);
        Map componentMap = ctx.getComponentMap();
        StringBuilder disableInstance = new StringBuilder();
        for (Map.Entry component : componentMap.entrySet()) {
            LcdpComponent value = (LcdpComponent)component.getValue();
            if (!ToolUtil.isNotEmpty((Object)value) || !"com.jxdinfo.uniui.JXDMobileForm".equals(value.getName())) continue;
            String data = value.getInstanceKey() + "Disabled";
            disableInstance.append("self." + data + " = true;");
        }
        moduleMap.put("disableInstanceKey", disableInstance.toString());
        ctx.addImports("*", "flowAuth", "@/api/bpm/flowAuth");
        String dataArrayStr = RenderUtil.renderTemplate((String)"/template/uniui/uni/framework/FlowAuthConfig.ftl", moduleMap);
        stringBuilder.append(dataArrayStr);
    }

    private void renderFlowData(LcdpComponent lcdpComponent, MobileUniCtx ctx) {
        Map renderMap = lcdpComponent.getRenderParams();
        for (String key : renderMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains("addFlowFileData")) continue;
            ctx.addData(lcdpComponent.getInstanceKey() + "ShowFlowFile: false,", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feShowFlowFile\u5c5e\u6027"));
            ctx.addData(lcdpComponent.getInstanceKey() + "ShowPicProcessKey: '',", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feshowPicProcessKey\u5c5e\u6027"));
            ctx.addImports("import { flowfile } from 'BpmShowWorkflow'");
            ctx.addComponent("flowfile");
            break;
        }
        for (String key : renderMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains("addFlowFileDataDialog")) continue;
            ctx.addData(lcdpComponent.getInstanceKey() + "ShowFlowFileDialog: false,", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feshowPicProcessKey\u5c5e\u6027"));
            ctx.addData(lcdpComponent.getInstanceKey() + "ShowPicProcessKey: '',", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feshowPicProcessKey\u5c5e\u6027"));
            ctx.addImports("import { flowfile } from 'BpmShowWorkflow'");
            ctx.addComponent("flowfile");
            break;
        }
    }

    private void renderImport(LcdpComponent lcdpComponent, MobileUniCtx ctx) {
        List formulaReferJsList;
        List customFunctionList = (List)lcdpComponent.getProps().get("customFunction");
        if (ToolUtil.isNotEmpty((Object)customFunctionList)) {
            for (Map stringObjectMap : customFunctionList) {
                Boolean exportDefault = stringObjectMap.get("exportDefault") == null ? false : (Boolean)stringObjectMap.get("exportDefault");
                String importStr = "import ";
                if (!exportDefault.booleanValue()) {
                    importStr = "import * as ";
                }
                String fileIdentify = String.valueOf(stringObjectMap.get("fileIdentify"));
                importStr = importStr + fileIdentify + " from '";
                String filePath = String.valueOf(stringObjectMap.get("functionPath"));
                importStr = importStr + filePath + "'";
                ctx.addImports(importStr);
            }
        }
        if (ToolUtil.isNotEmpty((Object)(formulaReferJsList = ExtendFormulaUtil.getFormulaCompileReferJs((Ctx)ctx)))) {
            for (ExtendFormulaCompileReferMethod referMethod : formulaReferJsList) {
                if (!ToolUtil.isNotEmpty((Object)referMethod.getMethods())) continue;
                for (String method : referMethod.getMethods()) {
                    ctx.addImports(method, referMethod.getPath());
                }
            }
        }
    }

    private void renderOnload(LcdpComponent lcdpComponent, MobileUniCtx ctx) {
        Map mountedMap = ctx.getMethods();
        for (String key : mountedMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains(lcdpComponent.getInstanceKey() + "Onload")) continue;
            lcdpComponent.addRenderParam("isOnload", (Object)true);
            break;
        }
    }

    private void renderPageProps(LcdpComponent lcdpComponent, MobileUniCtx ctx) {
        boolean hasPageInfo = ToolUtil.isNotEmpty((Object)ctx.getPageInfo());
        ArrayList paramList = new ArrayList();
        if (hasPageInfo && ToolUtil.isNotEmpty((Object)ctx.getPageInfo().getComponentParams())) {
            List params = ctx.getPageInfo().getComponentParams();
            for (ComponentPageParams entry : params) {
                String paramName = entry.getParamName();
                String paramDataType = entry.getParamDataType();
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("paramName", paramName);
                paramMap.put("paramDataType", paramDataType);
                paramList.add(paramMap);
            }
        }
        lcdpComponent.addRenderParam("props", paramList);
    }

    private void renderPoll(LcdpComponent lcdpComponent, MobileUniCtx ctx) {
        Map mountedMap = ctx.getMethods();
        ArrayList<String> destroyPolls = new ArrayList<String>();
        boolean pollSwitchMethod = false;
        for (String key : mountedMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains(lcdpComponent.getInstanceKey() + "PollName")) continue;
            pollSwitchMethod = true;
            ctx.addData(key + "Destroy: null", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"destroy\u5c5e\u6027"));
            destroyPolls.add(key + "Destroy");
        }
        lcdpComponent.addRenderParam("destroyPolls", destroyPolls);
        lcdpComponent.addRenderParam("pollSwitchMethod", (Object)pollSwitchMethod);
        lcdpComponent.addRenderParam("pollSwitch", lcdpComponent.getProps().get("pollSwitch"));
        lcdpComponent.addRenderParam("polls", lcdpComponent.getProps().get("polls"));
    }

    private void renderRouter(MobileUniCtx ctx) {
        ctx.addImports("import HussarRouterMobile from '@/utils/HussarRouterMobile'");
    }
}

