/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.uniui.vistor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.constant.DataConfigConstant;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.ctx.MobileUniCtx;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Trigger;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DropDownVoidVisitor
implements VoidVisitor<LcdpComponent, MobileUniCtx> {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, MobileUniCtx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/uniui/uni/dropdown/drop_down.ftl");
        this.renderData(lcdpComponent, ctx);
        this.removeTrigger(lcdpComponent, ctx);
        this.renderMenuItemLoad(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, MobileUniCtx ctx) throws Exception {
        String id = lcdpComponent.getInstanceKey();
        lcdpComponent.addRenderParam("id", (Object)id);
        Object hidden = lcdpComponent.getProps().get("hidden");
        if (ToolUtil.isNotEmpty(hidden)) {
            ctx.addData(lcdpComponent.getInstanceKey() + "Hidden: " + hidden + ",", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u9690\u85cf\u5c5e\u6027"));
            lcdpComponent.addAttr("v-if", "!" + lcdpComponent.getInstanceKey() + "Hidden");
        }
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealDisabledAttr(lcdpComponent, (Ctx)ctx);
        Object options = lcdpComponent.getProps().get("DropDownOptions");
        String defaultValue = "";
        defaultValue = ToolUtil.isNotEmpty(options) ? options.toString() : "[]";
        ArrayList<String> list = new ArrayList<String>();
        list.add("data");
        String optionStringName = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)"DropDownMenuOptions", list, (String)defaultValue).getRenderValue();
        lcdpComponent.addRenderParam("optionStringName", (Object)optionStringName);
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        Object defalutValue = lcdpComponent.getProps().get("defaultValue");
        String value = "''";
        ComponentDataUtil.ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("value"));
        if (ToolUtil.isNotEmpty(defalutValue) && !"".equals(defalutValue.toString()) && ToolUtil.isEmpty((Object)dataSModelAnalysis) && !ComponentDataUtil.ComponentValueStatusEnum.QUOTE.equals((Object)dataItemValueStatus)) {
            value = "'" + defalutValue.toString() + "'";
        }
        String valueData = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)value).getRenderValue();
        lcdpComponent.addRenderParam("bindData", (Object)valueData);
    }

    private void renderMenuItemLoad(LcdpComponent lcdpComponent, MobileUniCtx ctx) throws Exception {
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            if (dataSModelAnalysis.getType().equals("DataModel")) {
                DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
                Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
                String labelField = "";
                String valueField = "";
                if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                    for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                        List fieldAnalyses = (List)fieldList.getValue();
                        for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                            List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                            if (ToolUtil.isNotEmpty((Object)dataItemPath) && "text".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                labelField = dataSFieldAnalysis.getFieldName();
                            }
                            if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                            valueField = dataSFieldAnalysis.getFieldName();
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField)) {
                    String querySelectionName;
                    List conditionList;
                    HashMap<String, Object> selectMap = new HashMap<String, Object>();
                    String operationName = "hussarQuery";
                    String dataSelectId = lcdpComponent.getInstanceKey();
                    String apiFileName = "";
                    String apiFilePath = "";
                    String dataModelId = dataSModelAnalysis.getDataModelId();
                    if (ToolUtil.isNotEmpty((Object)dataModelId)) {
                        apiFileName = this.fileMappingService.getFileName(dataModelId);
                        apiFilePath = this.fileMappingService.getMobileImportPath(dataModelId);
                    }
                    if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                        selectMap.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                        selectMap.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                    }
                    if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                        operationName = operationName + querySelectionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                        EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                    }
                    selectMap.put("importName", apiFileName);
                    selectMap.put("importMethod", operationName);
                    selectMap.put("id", dataSelectId);
                    selectMap.put("text", labelField);
                    selectMap.put("value", valueField);
                    selectMap.putAll(lcdpComponent.getRenderParamsToBind());
                    Map<String, String> relativeDataParams = this.setRelativeDataParams(lcdpComponent, dataSFieldAnalysisMap);
                    selectMap.put("relativeDataParams", relativeDataParams);
                    ctx.addMethod(dataSelectId + "DropDownMenuOptionLoad", RenderUtil.renderTemplate((String)"/template/uniui/uni/dropdown/drop_down_menu_item_load.ftl", selectMap));
                    ctx.addMounted(CodePrefix._SELF.getType() + dataSelectId + "DropDownMenuOptionLoad();");
                }
            } else if (dataSModelAnalysis.getType().equals("CommonModel")) {
                String apiFileName = "";
                String apiFilePath = "";
                String dataModelId = dataSModelAnalysis.getDataModelId();
                if (ToolUtil.isNotEmpty((Object)dataModelId)) {
                    apiFileName = this.fileMappingService.getFileName(dataModelId);
                    apiFilePath = this.fileMappingService.getMobileImportPath(dataModelId);
                }
                if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                    EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                }
                HashMap<String, String> selectMap = new HashMap<String, String>();
                selectMap.put("importName", apiFileName);
                selectMap.put("importMethod", DataConfigConstant.CommonModelCategory.DICT.getImportMethod());
                selectMap.put("instanceKey", lcdpComponent.getInstanceKey());
                selectMap.put("dictType", dataSModelAnalysis.getDictType());
                ctx.addMethod(lcdpComponent.getInstanceKey() + "DropDownMenuOptionLoad", RenderUtil.renderTemplate((String)"/template/uniui/uni/dropdown/menu_item_load_from_dict.ftl", selectMap), false);
                ctx.getDictInfo().addOptionLoads(CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "DropDownMenuOptionLoad();");
                ctx.getDictInfo().addDicts(dataSAnalysis.getDatamodel().getDictType());
            }
        }
    }

    private Map<String, String> setRelativeDataParams(LcdpComponent lcdpComponent, Map<String, List<DataSFieldAnalysis>> dataSFieldAnalysisMap) {
        HashMap<String, String> relativeParams = new HashMap<String, String>();
        JSONArray array = (JSONArray)lcdpComponent.getProps().get("relativeData");
        if (HussarUtils.isNotEmpty((Object)array) && HussarUtils.isNotEmpty(dataSFieldAnalysisMap)) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                String relativeField = String.valueOf(obj.get((Object)"field"));
                String relativeId = String.valueOf(obj.get((Object)"id"));
                block1: for (Map.Entry<String, List<DataSFieldAnalysis>> entry : dataSFieldAnalysisMap.entrySet()) {
                    if (!HussarUtils.isNotEmpty(entry.getValue())) continue;
                    for (DataSFieldAnalysis analysis : entry.getValue()) {
                        if (!relativeId.equals(analysis.getDataItemPath().get(1))) continue;
                        relativeParams.put(relativeField, entry.getKey());
                        continue block1;
                    }
                }
            }
        }
        return relativeParams;
    }

    private void removeTrigger(LcdpComponent lcdpComponent, MobileUniCtx ctx) {
        List triggers = lcdpComponent.getTrigger();
        if (ToolUtil.isNotEmpty((Object)triggers)) {
            for (Trigger trigger : triggers) {
                if (!"change".equals(trigger.getName())) continue;
                lcdpComponent.addRenderParam("change", (Object)true);
            }
            triggers.clear();
        }
    }
}

