/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.CodePublishTool;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.VueCodeGenerateService;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.result.VueCodeResult;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.ctx.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.CodePublisher;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.StyleScheme;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBaseConfig;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

@ClientKind(kind="com.jxdinfo.UniPage.publish")
public class UniCodePublishImpl
implements CodePublisher {
    public static final String KIND = "com.jxdinfo.UniPage.publish";
    private final VersionManageService versionManageService = (VersionManageService)SpringContextHolder.getBean(VersionManageService.class);
    private final FilePublishService filePublishService = (FilePublishService)SpringContextHolder.getBean(FilePublishService.class);
    private final CodeMergeService codeMergeService = (CodeMergeService)SpringContextHolder.getBean(CodeMergeService.class);
    private final VueCodeGenerateService vueCodeGenerateService = (VueCodeGenerateService)SpringContextHolder.getBean(VueCodeGenerateService.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private final ResourcePathService resourcePathService = (ResourcePathService)SpringContextHolder.getBean(ResourcePathService.class);
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final MobileUniProperties mobileUniProperties = (MobileUniProperties)SpringContextHolder.getBean(MobileUniProperties.class);
    private final IHussarThemeConfigService iHussarThemeConfigService = (IHussarThemeConfigService)SpringContextHolder.getBean(IHussarThemeConfigService.class);
    private final CodePublishTool codePublishTool = (CodePublishTool)SpringContextHolder.getBean(CodePublishTool.class);
    public static final String JS = ".js";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(PublishCtx<CodeResult> publishCtx, ThemeVars themeVars) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        PageInfo pageInfo = (PageInfo)publishCtx.getBaseFile();
        String projectPath = this.mobileUniProperties.getUniFrontProjectPath();
        String id = pageInfo.getId();
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(pageInfo.getId());
        moduleRelatePath = moduleRelatePath.startsWith("/") ? moduleRelatePath : "/" + moduleRelatePath;
        moduleRelatePath = moduleRelatePath.endsWith("/") ? moduleRelatePath : moduleRelatePath + "/";
        String pageName = pageInfo.getName();
        String pageInfoDataJson = pageInfo.getData();
        JSONObject pageInfoDataJsonObject = JSON.parseObject((String)pageInfoDataJson);
        StyleScheme styleScheme = this.iHussarThemeConfigService.getCurrentSysThemeInfo();
        ThemeBaseConfig themeBaseConfig = styleScheme.getThemeBase().getMobilePage();
        Map scssVars = styleScheme.getScssVars().getMobilePage();
        CodeFormatResult codeFormatResult = this.vueCodeGenerateService.vueGenerate(pageInfoDataJsonObject, pageName, pageInfo, themeVars.getMobilePage(), strategy, themeBaseConfig, scssVars);
        String newContent = codeFormatResult.getCodeFormatCode();
        String projectPagePath = this.mobileProjectVue(this.mobileUniProperties.getUniFrontProjectPath(), this.fileMappingService.getFormatPath(id) + this.formDesignProperties.getPageSuffix()).getLocalPath();
        if (!codeFormatResult.isSucceed()) {
            VueCodeResult codeResult = new VueCodeResult();
            codeResult.setId(id);
            codeResult.setNewCode(newContent);
            codeResult.setFilePath(projectPagePath);
            codeResult.setCodeFormatSucceed(codeFormatResult.isSucceed());
            codeResult.setCodeFormatMessages(codeFormatResult.getMessages());
            codeResult.setMsg(codeFormatResult.getMsg());
            publishCtx.addCodeResult((CodeResult)codeResult);
            return;
        }
        newContent = CodeSplitUtil.removeEmptyLines((String)newContent);
        this.filePublishService.writePublishSourceToCache(id, "mobileUni");
        if (strategy != null) {
            try {
                this.genMobileUniCode(id, moduleRelatePath, pageName, pageInfo, newContent, projectPath);
                this.codePublishTool.delayWrite(id);
                this.compile(projectPath, moduleRelatePath, pageName, pageInfo);
            }
            finally {
                this.versionManageService.saveLastPublishCode(id, newContent);
                this.versionManageService.saveLastFileCode(id, newContent);
            }
            return;
        }
        Optional<String> ancestorContent = Optional.ofNullable(this.versionManageService.getAncestorCodeById(id));
        Optional<String> lastFileContent = Optional.ofNullable(this.versionManageService.getLastFileCode(id));
        String pagePath = this.mobileProjectVue(projectPath, moduleRelatePath, pageName + this.formDesignProperties.getPageSuffix()).getLocalPath();
        Optional<String> currentContent = Optional.ofNullable(this.filePublishService.readCurrentPublishedFile(pagePath));
        if (ancestorContent.isPresent() && currentContent.isPresent()) {
            MergeResult mergeResult;
            CodeFormatResult lastPublishResult = CodeFormatter.formatterHtml((String)ancestorContent.get(), (String)"vue");
            CodeFormatResult currentFileResult = CodeFormatter.formatterHtml((String)currentContent.get(), (String)"vue");
            String lastFile = "";
            if (lastFileContent.isPresent()) {
                lastFile = lastFileContent.get();
            }
            if (!(mergeResult = this.codeMergeService.structuralMerge(pagePath, ExtractFileType.VUE, ancestorContent.get(), currentContent.get(), newContent, lastFile, true)).isConflict()) {
                try {
                    this.genMobileUniCode(id, moduleRelatePath, pageName, pageInfo, mergeResult.getMergedCode(), projectPath);
                    this.codePublishTool.delayWrite(id);
                }
                finally {
                    this.versionManageService.saveLastPublishCode(id, newContent);
                    this.versionManageService.saveLastFileCode(id, mergeResult.getMergedCode());
                }
            } else {
                this.codePublishTool.assembleCode(id, publishCtx, newContent, currentContent, mergeResult, projectPagePath);
            }
        } else {
            try {
                newContent = CodeSplitUtil.removeEmptyLines((String)newContent);
                this.genMobileUniCode(id, moduleRelatePath, pageName, pageInfo, newContent, projectPath);
            }
            finally {
                this.versionManageService.saveLastPublishCode(id, newContent);
                this.versionManageService.saveLastFileCode(id, newContent);
                this.codePublishTool.delayWrite(id);
            }
        }
    }

    private void genMobileUniCode(String id, String moduleRelatePath, String pageName, PageInfo pageInfo, String fileContent, String uniProjectPath) throws IOException {
        String projectPath = this.mobileProject(uniProjectPath, new String[0]).getLocalPath();
        this.writeMobileCode(fileContent, moduleRelatePath, pageName, projectPath, id);
        if (!this.formDesignProperties.isLocalUnReset()) {
            String component = FileUtil.posixPath((String[])new String[]{"views", moduleRelatePath, pageName});
            String desc = pageInfo.getDesc();
            String routerExport = "{\n 'path': '" + component + "',\n'style': {\n'navigationBarTitleText': '" + desc + "'\n}\n}";
            this.writeMobileUniRouterCode(component, routerExport, projectPath, id);
        }
    }

    private void writeMobileUniRouterCode(String component, String fileContent, String vueRootPath, String pageId) throws IOException {
        vueRootPath = FileUtil.complementFilePath((String)vueRootPath);
        String filePath = vueRootPath + "/src/pages.json";
        File file = new File(filePath);
        String fileMsg = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        JSONObject parse = JSON.parseObject((String)fileMsg, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray jsonArray = JSON.parseArray((String)parse.get((Object)"pages").toString());
        boolean type = true;
        for (Object o : jsonArray) {
            String path = JSON.parseObject((String)o.toString()).get((Object)"path").toString();
            if (!path.equals(component)) continue;
            type = false;
            break;
        }
        if (type) {
            jsonArray.add((Object)JSON.parseObject((String)fileContent));
            parse.put("pages", (Object)jsonArray);
        }
        String writeFormat = JSON.toJSONString((Object)parse, (boolean)true);
        this.filePublishService.writeStringToFile(writeFormat, filePath, pageId);
    }

    private void writeMobileCode(String fileContent, String modulePath, String pageName, String vueRootPath, String pageId) throws IOException {
        vueRootPath = this.formDesignProperties.isLocalUnReset() ? vueRootPath + File.separator + "src" + File.separator + "pages" : vueRootPath + File.separator + "src" + File.separator + "views";
        vueRootPath = FileUtil.complementFilePath((String)vueRootPath);
        modulePath = FileUtil.complementFilePath((String)modulePath);
        String filePath = vueRootPath + modulePath + pageName + this.formDesignProperties.getPageSuffix();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        this.filePublishService.writeStringToFile(fileContent, filePath, pageId);
    }

    private void compile(String projectPath, String moduleRelatePath, String pageName, PageInfo pageInfo) throws LcdpException {
        HashMap<String, String> compileParams = new HashMap<String, String>();
        String pageType = "pages";
        String publishVueRelativePath = FileUtil.posixPath((String[])new String[]{"@/" + pageType, AppContextUtil.posixFilePathPrefix(), moduleRelatePath, pageName});
        if (ToolUtil.isNotEmpty((Object)moduleRelatePath)) {
            moduleRelatePath = moduleRelatePath.substring(0, 1).equals("/") ? moduleRelatePath.substring(1) : moduleRelatePath;
        }
        compileParams.put("entry", FileUtil.posixPath((String[])new String[]{"pages", moduleRelatePath, pageName}));
        compileParams.put("template", this.mobileProject(projectPath, this.formDesignProperties.getMobileCompileHtmlPath()).getLocalPath());
        compileParams.put("output", FileUtil.posixPath((String[])new String[]{this.mobileUniProperties.getUniCompilePath(), AppContextUtil.posixFilePathPrefix(), moduleRelatePath, pageName, File.separator}));
        compileParams.put("name", pageInfo.getDesc());
        compileParams.put("path", FileUtil.posixPath((String[])new String[]{"pages", moduleRelatePath, pageName}));
        this.codePublishTool.compile(publishVueRelativePath, compileParams, this.mobileUniProperties.getUniCompileServer());
    }

    private ResourcePath mobileProject(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getWorkspace(), name});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }

    private ResourcePath mobileProjectVue(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getWorkspace(), name, this.formDesignProperties.getMobileVueCodePath()});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }
}

