<template>
    <view class="lcdp_axe_main">
        <view class="lcdp_axe jxd_ins_BaseMobilePage jxd_additional ${pageName} ${rootInstanceKey!}" v-if="alreadyLoad">
            ${body!}
            ${slotCodes.default!}
            ${slot_title!}
            <#if consignorDialog?? && consignorDialog>
                <consignorDialog
                        @close="${instanceKey!}ConsignorDialogVisible = false"
                        @comfirm="${instanceKey!}ComfirmConsignor"
                        :selectionBackup='${instanceKey!}SelectedConsignorBackup'
                        :tableData='${instanceKey!}ConsignorData'
                        :consignorDialogVisible='${instanceKey!}ConsignorDialogVisible' />
            </#if>
            <#if showSelectParticipant??>
                <#--提交流程表单选择参与者-->
                <#list showSelectParticipant as currentKey>
                    <selectParticipant
                            ref="${instanceKey!}${currentKey!}SelectParticipant"
                            @save="${instanceKey!}${currentKey!}FlowFormSubmitSave"
                            :taskId="${instanceKey!}${currentKey!}TaskId"
                            :processDefinitionKey="${instanceKey!}${currentKey!}ProcessDefinitionKey"
                            :doneListIdentification="${instanceKey!}${currentKey!}DoneListIdentification ? ${instanceKey!}${currentKey!}DoneListIdentification : '0'"
                            :isGetRevokeNode="${instanceKey!}${currentKey!}isGetRevokeNode"
                            :lineCondition="${instanceKey!}${currentKey!}LineCondition"/>
                </#list>
            </#if>
            <#if isConfigAlertNotify?? && isConfigAlertNotify>
                <#--弹出消息通知动作的弹出框-->
                <uni-popup ref="alertNotify" type="message">
                    <uni-popup-message
                            :type="${rootInstanceKey!}AlertNotifyType"
                            :message="${rootInstanceKey!}AlertNotifyText" />
                </uni-popup>
            </#if>
            <#if isConfigDateTimeInList?? && isConfigDateTimeInList>
                <view  class="list-outer-size-datetime">
                    <uni-datetime-picker
                            :clear-icon="false"
                            ref="${rootInstanceKey!}DateTimeRef"
                            @change="${rootInstanceKey!}DateTimeChange"
                            v-model="${rootInstanceKey!}DateTimeValue"
                            :start="${rootInstanceKey!}DateTimeStart"
                            :end="${rootInstanceKey!}DateTimeEnd"
                            :type="${rootInstanceKey!}DateTimeType"/>
                </view>
            </#if>
        </view>
    </view>
</template>

<script>
<#list importScripts! as imp>
    ${imp}
</#list>
/* ${directives.definitionsBegin} */
/* ${directives.definitionsEnd} */
export default {
    name: '${pageName!}',
    components: {
        <#list components as component>
            <#if component?contains("endif")>
                ${component}
            <#else>
                ${component},
            </#if>
        </#list>
    },
    props: {
        <#if props?? && (props?size>0)>
            <#list props as prop>
                ${prop.paramName}: ${prop.paramDataType?cap_first},
            </#list>
        </#if>
    },
    data() {
        return {
                ${rootInstanceKey!}DateTimeValue: '',
                ${rootInstanceKey!}DateTimeStart: '',
                ${rootInstanceKey!}DateTimeEnd: '',
                ${rootInstanceKey!}DateTimeType: '',
                ${rootInstanceKey!}DateTimeSetMethod: null,
            <#if dicts?? && dicts?size gt 0>
                dictOptions: [], // 字典数据
            </#if>
            <#if levelDicts?? && levelDicts?size gt 0>
                levelDictOptions: [], // 多级字典数据
            </#if>
            <#if isConfigAlertNotify?? && isConfigAlertNotify>
                ${rootInstanceKey!}AlertNotifyType: '',
                ${rootInstanceKey!}AlertNotifyText: '',
            </#if>
            <#list datas?keys as key>
                <#assign data=datas[key]>
                    ${key}, <#if data.comments??> <#list data.comments as comment>// ${comment}</#list> </#if>
            </#list>
            /* ${directives.dataBegin} */
            /* ${directives.dataEnd} */
        };
    },
    computed: {
        <#list computeds?keys as key>
            <#assign computed=computeds[key]>
                <#if computed.comments??>
                    /**
                    <#list computed.comments as comment>
                    * ${comment}
                    </#list>
                    */
                </#if>
                ${key}(${computed.argBody!}){
                    const self = this;
                    <#list computed.bodies as body>
                        ${body}
                    </#list>
                },
        </#list>
        <#list computedWithGetSets?keys as key>
            <#assign computed=computedWithGetSets[key]>
                ${key}:{
                    <#list computed.bodies as body>
                        ${body}
                    </#list>
                },
        </#list>
        /* ${directives.computedBegin} */
        /* ${directives.computedEnd} */
    },
    watch: {
        <#list watches?keys as key>
            <#assign watch=watches[key]>
            <#if (key!?index_of('\'') > -1) && !watch.argBody??>
                <#if watch.comments??>
                    /**
                     <#list watch.comments as comment>
                     * ${comment}
                     </#list>
                     */
                </#if>
                ${key}:{
                    <#list watch.bodies as body>
                        ${body}
                    </#list>
                },
            <#else>
                <#if watch.comments??>
                    /**
                     <#list watch.comments as comment>
                     * ${comment}
                     </#list>
                     */
                </#if>
                ${key}(${watch.argBody!}){
                    <#list watch.bodies as body>
                        ${body}
                    </#list>
                },
            </#if>
        </#list>
        /* ${directives.watchBegin} */
        /* ${directives.watchEnd} */
    },
    provide(){
        return {
            openDateTimeSelect: this.openDateTimeSelect.bind(this),
        }
    },
    methods: {
            openDateTimeSelect(data) {
                this.${rootInstanceKey!}DateTimeValue = data.value;
                this.${rootInstanceKey!}DateTimeStart = data.start;
                this.${rootInstanceKey!}DateTimeEnd = data.end;
                this.${rootInstanceKey!}DateTimeType = data.type;
                this.${rootInstanceKey!}DateTimeSetMethod = data.set;
                this.$refs.${rootInstanceKey!}DateTimeRef.show();
            },
        <#if isConfigDateTimeInList?? && isConfigDateTimeInList>
            ${rootInstanceKey!}DateTimeChange(n) {
                this.${rootInstanceKey!}DateTimeSetMethod(n);
            },
        </#if>
        <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
            // 查询字典数据
            async queryDictOptions() {
                const self = this;
                <#if dicts?? && dicts?size gt 0>
                    const queryDictObj = {
                        typeNames: '<#list dicts[0 ..! dicts?size - 1] as dict>${dict},</#list>${dicts[dicts?size - 1]}'
                    };
                    await dict.${dictMethod}(queryDictObj).then((res) => {
                        if (res.code === 10000 || res.code === 200) {
                          self.dictOptions = res.data;
                          <#list optionLoads as optionLoad>
                            ${optionLoad}
                          </#list>
                        } else {
                            HussarRouterMobile.mobileMessage( '字典请求异常', 'error');
                        }
                    }).catch(function () {
                        HussarRouterMobile.mobileMessage( '字典请求异常', 'error');
                    });
                </#if>
                <#if levelDicts?? && levelDicts?size gt 0>
                    const queryLevelDictObj = {
                        typeNames: '<#list levelDicts[0 ..! levelDicts?size - 1] as levelDict>${levelDict},</#list>${levelDicts[levelDicts?size - 1]}'
                    };
                    await dict.${treeMethod}(queryLevelDictObj).then((res) => {
                        if (res.code === 10000 || res.code === 200) {
                            self.levelDictOptions = res.data;
                            <#list treeLoads as treeLoad>
                                ${treeLoad}
                            </#list>
                        } else {
                            HussarRouterMobile.mobileMessage( '字典请求异常', 'error');
                        }
                    }).catch(function () {
                        HussarRouterMobile.mobileMessage( '字典请求异常', 'error');
                    });
                </#if>
            },
        </#if>
        <#list methods?keys as key>
            <#assign method=methods[key]>
            <#assign importName=key>
            <#if async?? && async?size gt 0>
                <#list async! as async_importName>
                    <#if async_importName == key>
                        <#assign importName=("async " + key)?string>
                    </#if>
                </#list>
            </#if>
            <#if method.comments??>
                /**
                <#list method.comments as comment>
                * ${comment}
                </#list>
                */
            </#if>
            ${importName}(${method.argBody!}){
                const self = this;
                <#list method.bodies as body>
                    ${body}
                </#list>
            },
        </#list>
        /* ${directives.methodsBegin} */
        /* ${directives.methodsEnd} */
    },
    <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)> async </#if>created() {
        const self = this;
        // ${directives.createdBeforeBegin}
        // ${directives.createdBeforeEnd}
        <#list createds! as created>
            ${created}
        </#list>
        <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
            // 查询字典数据
            await self.queryDictOptions();
        </#if>
        // ${directives.createdAfterBegin}
        // ${directives.createdAfterEnd}
    },
    onShow() {
        const self = this;
        // ${directives.mountedBeforeBegin}
        // ${directives.mountedBeforeEnd}
        <#if isOnload?? && isOnload>
            self.${rootInstanceKey!}Onload();
        </#if>
        <#if mounteds?? && mounteds?size gt 0>
            <#list mounteds! as mounted>
                ${mounted}
            </#list>
        </#if>
        // ${directives.mountedAfterBegin}
        // ${directives.mountedAfterEnd}
    },
    async onLoad(pageParams) {
        const self = this;
        // 为了实现免登录的时候，App.vue中的onLaunch与onLoad中的同步顺序
        await self.$onLaunched;
        <#if onLoads?? && onLoads?size gt 0>
            <#list onLoads! as onLoad>
                ${onLoad}
            </#list>
        </#if>
        <#if showSelectParticipant??>
            <#list showSelectParticipant as currentKey>
                self.${instanceKey!}${currentKey!}TaskId = HussarRouterMobile.query('taskId');
                self.${instanceKey!}${currentKey!}ProcessDefinitionKey = HussarRouterMobile.query('processDefinitionKey');
                self.${instanceKey!}${currentKey!}DoneListIdentification = HussarRouterMobile.query('doneListIdentification');
            </#list>
        </#if>
    },
    onPullDownRefresh() {
        const self = this;
        <#if onPullDownRefreshs?? && onPullDownRefreshs?size gt 0>
            <#list onPullDownRefreshs! as onPullDownRefresh>
                ${onPullDownRefresh}
            </#list>
        </#if>
    },
    filters: {
        <#list filters?keys as key>
            <#assign filter=filters[key]>
            <#if filter.comments??>
                /**
                <#list filter.comments as comment>
                * ${comment}
                </#list>
                */
            </#if>
            ${key}(${filter.argBody!}){
                <#list filter.bodies as body>
                    ${body}
                </#list>
            },
        </#list>
    },
    /* ${directives.optionsBegin} */
    /* ${directives.optionsEnd} */
};
</script>

<!-- ${directives.styleBeforeBegin} -->
<!-- ${directives.styleBeforeEnd} -->

<style scoped>
    /*公共，用于固定*/
    .lcdp_axe_main{height: 100%;overflow: auto}
    ${styles!}
</style>

<!-- ${directives.styleAfterBegin} -->
<!-- ${directives.styleAfterEnd} -->
