/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.uniui.uni;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.uniui.vistor.LabelVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class UniLabel
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.uniui.JXDMobileLabel";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_uniLabel");
    }

    public VoidVisitor visitor() {
        return new LabelVisitor();
    }

    public static UniLabel newComponent(JSONObject jsonObject) {
        UniLabel uniLabel = (UniLabel)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)UniLabel.class.getName()));
        Object backgroundImg = uniLabel.getInnerStyles().get("backgroundImageBack");
        uniLabel.getInnerStyles().remove("backgroundImageBack");
        uniLabel.getInnerStyles().put("backgroundImage", backgroundImg);
        uniLabel.getInnerStyles().put("layout", "flex");
        if (uniLabel.isAutoWidth()) {
            int left = uniLabel.getLeft();
            uniLabel.getStyles().put("maxWidth", "calc(375px - " + left + "px)");
            uniLabel.getStyles().put("overflow", "hidden");
            uniLabel.getStyles().put("textOverflow", "ellipsis");
            uniLabel.getInnerStyles().put("autoWidth", "max-content");
        }
        return uniLabel;
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("requireColor", "${prefix} .required{color:${val};}");
        map.put("letterSpacing", "${prefix}{letter-spacing: ${val}; text-indent: ${val}; word-break: break-all;}.jxd-shear{white-space: nowrap;overflow: hidden;text-overflow: ellipsis;}");
        map.put("borderTop", "${prefix}{border-top: ${val};}");
        map.put("borderTopColor", "${prefix}{border-top-color: ${val};}");
        map.put("borderLeft", "${prefix}{border-left: ${val};}");
        map.put("borderLeftColor", "${prefix}{border-left-color: ${val};}");
        map.put("borderRight", "${prefix}{border-right: ${val};}");
        map.put("borderRightColor", "${prefix}{border-right-color: ${val};}");
        map.put("borderBottom", "${prefix}{border-bottom: ${val};}");
        map.put("borderBottomColor", "${prefix}{border-bottom-color: ${val};}");
        map.put("borderRadius", "${prefix}{border-radius: ${val};}");
        map.put("backgroundColor", "${prefix}{background-color: ${val};}");
        map.put("backgroundImage", "${prefix}{background-image: ${val};}");
        map.put("backgroundPosition", "${prefix}{background-position: ${val};}");
        map.put("backgroundSize", "${prefix}{background-size: ${val};}");
        map.put("backgroundRepeat", "${prefix}{background-repeat: ${val};}");
        map.put("boxShadow", "${prefix}{box-shadow:${val};}");
        map.put("padding", "${prefix}{padding: ${val};}");
        map.put("vertical", "${prefix}{align-items:${val};}");
        map.put("textAlign", "${prefix}{justify-content:${val};text-align: ${val};}");
        map.put("layout", "${prefix}{display:${val};}");
        map.put("autoWidth", "${prefix}{width: ${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorder", "dynamicStyleTemplate");
        map.put("isBorderRadius", "dynamicStyleTemplate");
        map.put("isShadow", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("isBorder", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix}{border: none}";
            }
            return "";
        });
        map.put("isBorderRadius", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix}{border-radius: unset}";
            }
            return "";
        });
        map.put("isShadow", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix}{box-shadow: none}";
            }
            return "";
        });
        return (Function)map.get(key);
    }
}

