const result = [];
const seriesResult = [];
const detail = `{value}${unit!}`;
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
if (oldTitle) {
  const titleLength = oldTitle.length;
  const provideLength = numberOfRow;
  const rowNumber = Math.ceil(titleLength / provideLength);
  if (titleLength > provideLength) {
    for (let i = 0; i < rowNumber; i++) {
      let tempStr = ' ';
      const start = i * provideLength;
      const end = start + provideLength;
      if (i === rowNumber - 1) {
        tempStr = oldTitle.substring(start, titleLength);
      } else {
        tempStr = oldTitle.substring(start, end)+'\n';
      }
      newTitle += tempStr;
    }
  } else {
    newTitle = oldTitle;
  }
}
const echatrsTitle = {
  text: newTitle,
  textStyle: {
    color: '${titleColor!}',
    fontSize: '${titleFontSize!}',
    fontFamily: '${fontFamily!}',
    fontWeight: '${fontWeight!}',
    fontStyle: '${fontStyle!}',
  },
  left: '${titleAlign!}',
};
const echatrsTooltip = {
  formatter: `{a} <br/>{b} : {c}${unit}`,
  trigger: 'item',
  backgroundColor: '${tooltipBgColor!}',
  textStyle: {
    color: '${toolColor!}',
    fontSize: '${toolFontSize!}',
    fontFamily: '${toolFontFamily!}',
    fontWeight: '${toolFontWeight!}',
    fontStyle: '${toolFontStyle!}',
  },
};
return{
  title: echatrsTitle,
  tooltip: echatrsTooltip,
  series: [{
    name: '${pointerName!}',
    min: '${min!}',
    max: '${max!}',
    type: 'gauge',
    detail: {
      formatter: detail
    },
    data: [{
      value: ${optionData!}.valueData,
      name: ${optionData!}.nameData,
    }],
  }],
}