/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.low.code.api;

import com.jxdinfo.hussar.application.service.IUserEnvPortService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.devtools.invocation.service.CompileInvokeHelper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/user_env"})
public class UserEnvController {
    private static final Logger logger = LoggerFactory.getLogger(UserEnvController.class);
    @Autowired(required=false)
    private IUserEnvPortService userEnvPortService;
    @Autowired(required=false)
    private CompileInvokeHelper compileInvokeHelper;

    @GetMapping(value={"/isActive"})
    public ApiResponse<Boolean> isActive() {
        String mobilePort;
        if (!VfgModeTool.isRemote()) {
            return ApiResponse.success((Object)true);
        }
        Map userEnvPort = this.userEnvPortService.getUserEnvPortByUserId(BaseSecurityUtil.getUser().getUserId());
        if (ObjectUtils.isEmpty((Object)userEnvPort)) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u4e2a\u4eba\u5f00\u53d1\u73af\u5883\u7aef\u53e3\u5931\u8d25");
        }
        String backPort = ObjectUtils.isEmpty(userEnvPort.get("backPort")) ? "" : String.valueOf(userEnvPort.get("backPort"));
        String frontPort = ObjectUtils.isEmpty(userEnvPort.get("frontPort")) ? "" : String.valueOf(userEnvPort.get("frontPort"));
        String string = mobilePort = ObjectUtils.isEmpty(userEnvPort.get("mobilePort")) ? "" : String.valueOf(userEnvPort.get("mobilePort"));
        if (ObjectUtils.isEmpty((Object)backPort) || ObjectUtils.isEmpty((Object)frontPort) || ObjectUtils.isEmpty((Object)mobilePort)) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u4e2a\u4eba\u5f00\u53d1\u73af\u5883\u7aef\u53e3\u5931\u8d25");
        }
        ToolUtil.getLogger(UserEnvController.class).info("\u540e\u7aef\u7aef\u53e3\uff1a{}\uff0c\u524d\u7aef\u7aef\u53e3\uff1a{}, \u79fb\u52a8\u7aef\u7aef\u53e3: {}", new Object[]{backPort, frontPort, mobilePort});
        int[] ports = new int[]{Integer.parseInt(frontPort), Integer.parseInt(backPort), Integer.parseInt(mobilePort)};
        HashSet<Integer> runningProcesses = new HashSet<Integer>();
        String os = System.getProperty("os.name").toLowerCase();
        for (int port : ports) {
            try {
                String line;
                BufferedReader reader;
                Process process;
                if (os.contains("windows")) {
                    process = Runtime.getRuntime().exec("netstat -aon");
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        if (!line.contains(":" + port)) continue;
                        runningProcesses.add(port);
                        logger.info("\u5df2\u542f\u52a8\u7aef\u53e3:{}", (Object)port);
                    }
                    continue;
                }
                if (os.contains("linux") || os.contains("ubuntu") || os.contains("mac")) {
                    process = Runtime.getRuntime().exec("lsof -t -i:" + port);
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        Pattern pattern = Pattern.compile("\\d+$");
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.find()) continue;
                        runningProcesses.add(port);
                        logger.info("\u5df2\u542f\u52a8\u7aef\u53e3:{}", (Object)port);
                    }
                    continue;
                }
                return ApiResponse.success((Object)false);
            }
            catch (Exception e) {
                logger.info("\u67e5\u8be2\u72b6\u6001\u9519\u8bef:{}", (Object)e.getMessage());
            }
        }
        boolean status = runningProcesses.contains(Integer.parseInt(frontPort)) && runningProcesses.contains(Integer.parseInt(backPort)) && runningProcesses.contains(Integer.parseInt(mobilePort));
        return ApiResponse.success((Object)status);
    }
}

