/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.logic.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.JavaCodeFormatUtil;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.PublishCache;
import com.jxdinfo.hussar.formdesign.common.properties.AppIsolation;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.MergeResult;
import com.jxdinfo.hussar.formdesign.logic.code.LogicCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.logic.result.LogicCodeResult;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateResult;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFile;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFileType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LogicCodeMergeUtil {
    private static VersionManageService versionManageService = (VersionManageService)SpringContextUtil.getBean(VersionManageService.class);
    private static ResourcePathService resourcePathService = (ResourcePathService)SpringContextUtil.getBean(ResourcePathService.class);
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
    private static FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
    private static AppIsolation appIsolation = (AppIsolation)SpringContextUtil.getBean(AppIsolation.class);
    private static CodeMergeService codeMergeService = (CodeMergeService)SpringContextUtil.getBean(CodeMergeService.class);

    public static void render(LogicGenerateResult logicGenerateResult, PublishCtx publishCtx) throws IOException, LcdpException {
        ArrayList<LogicCodeResult> codeResults = new ArrayList<LogicCodeResult>();
        String api = logicGenerateResult.getApi();
        BaseFile baseFile = publishCtx.getBaseFile();
        List files = logicGenerateResult.getFiles();
        if (ToolUtil.isNotEmpty((Object)files)) {
            for (LogicGenerateFile file : files) {
                if ("HUSSAR_ENGINE".equals(publishCtx.getStrategy()) && !HussarUtils.equals((Object)LogicGenerateFileType.JS_API, (Object)file.getType())) continue;
                LogicCodeGenerateInfo logicCodeGenerateInfo = new LogicCodeGenerateInfo(file);
                codeResults.add(LogicCodeMergeUtil.mergeLogicCode(logicCodeGenerateInfo, baseFile));
            }
        }
        boolean isConflict = false;
        for (LogicCodeResult codeResult : codeResults) {
            if (!codeResult.isExistConflict()) continue;
            isConflict = true;
            break;
        }
        if (!isConflict) {
            LogicCodeMergeUtil.delayWrite(baseFile.getId());
        }
        publishCtx.addCodeResults(codeResults);
    }

    public static void renderAppIsolation(LogicGenerateResult logicGenerateResult, PublishCtx publishCtx) throws IOException, LcdpException {
        ArrayList<LogicCodeResult> codeResults = new ArrayList<LogicCodeResult>();
        String api = logicGenerateResult.getApi();
        BaseFile baseFile = publishCtx.getBaseFile();
        List files = logicGenerateResult.getFiles();
        if (ToolUtil.isNotEmpty((Object)files)) {
            for (LogicGenerateFile file : files) {
                if ("HUSSAR_ENGINE".equals(publishCtx.getStrategy()) && !HussarUtils.equals((Object)LogicGenerateFileType.JS_API, (Object)file.getType())) continue;
                if (HussarUtils.equals((Object)LogicGenerateFileType.JS_API, (Object)file.getType())) {
                    String workspace = formDesignProperties.getWorkspace();
                    String suffixPath = file.getPath().substring(workspace.length());
                    file.setPath(workspace + appIsolation.getAppIsolationCode() + "\\" + suffixPath);
                }
                LogicCodeGenerateInfo logicCodeGenerateInfo = new LogicCodeGenerateInfo(file);
                codeResults.add(LogicCodeMergeUtil.mergeLogicCode(logicCodeGenerateInfo, baseFile));
            }
        }
        boolean isConflict = false;
        for (LogicCodeResult codeResult : codeResults) {
            if (!codeResult.isExistConflict()) continue;
            isConflict = true;
            break;
        }
        if (!isConflict) {
            LogicCodeMergeUtil.delayWrite(baseFile.getId());
        }
        publishCtx.addCodeResults(codeResults);
    }

    private static LogicCodeResult mergeLogicCode(LogicCodeGenerateInfo logicCodeGenerateInfo, BaseFile baseFile) throws IOException, LcdpException {
        LogicCodeResult logicCodeResult = new LogicCodeResult();
        String absolutePath = logicCodeGenerateInfo.getPath();
        String mergeCode = "";
        String dataId = LogicCodeMergeUtil.getVersionFileKey(logicCodeGenerateInfo, baseFile);
        if (ToolUtil.isNotEmpty((Object)logicCodeGenerateInfo.getFileContent())) {
            Optional<String> currentCode;
            if ("js".equals(logicCodeGenerateInfo.getFileType())) {
                String jsPath = logicCodeGenerateInfo.getPath();
                currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(jsPath));
            } else {
                String currentPath = logicCodeGenerateInfo.getPath();
                currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(currentPath));
            }
            Optional<String> versionCode = Optional.ofNullable(versionManageService.getAncestorCodeById(dataId));
            if (currentCode.isPresent() && versionCode.isPresent()) {
                String pageName = baseFile.getName();
                String moduleRelatePath = fileMappingService.getFormatParentPath(baseFile.getId());
                String jsPath = resourcePathService.webProjectApi(new String[]{moduleRelatePath, pageName + formDesignProperties.getJsSuffix()}).getLocalPath();
                MergeResult mergeResult = codeMergeService.structuralMerge(jsPath, ExtractFileType.JS, versionCode.get(), currentCode.get(), logicCodeGenerateInfo.getFileContent(), false);
                if (mergeResult.isConflict()) {
                    logicCodeResult.setResultType(ResultBeanEnum.LOGIC_RESULT);
                    logicCodeResult.setExistConflict(true);
                    logicCodeResult.setMergeCode(mergeResult.getMergedCode());
                    logicCodeResult.setConflictCode(mergeResult.getConflictsCode());
                    logicCodeResult.setOriginCode(currentCode.get());
                    logicCodeResult.setNewCode(logicCodeGenerateInfo.getFileContent());
                    logicCodeResult.setLastPublish(mergeResult.getLastPublish());
                    logicCodeResult.setCurrentPublish(mergeResult.getCurrentPublish());
                    logicCodeResult.setCurrentFile(mergeResult.getCurrentFile());
                } else {
                    mergeCode = mergeResult.getMergedCode();
                }
                switch (logicCodeGenerateInfo.getFileType()) {
                    case "CONTROLLER": 
                    case "SERVICE_IMPL": 
                    case "SERVICE_INTERFACE": 
                    case "SERVICE_STANDALONE": 
                    case "DTO_POJO": 
                    case "MODEL_POJO": 
                    case "DAO_INTERFACE": 
                    case "controller": 
                    case "entity": 
                    case "service": 
                    case "serviceImpl": {
                        logicCodeResult.setType("java");
                        break;
                    }
                    case "DAO_MAPPER": 
                    case "mapper": 
                    case "xml": {
                        logicCodeResult.setType("xml");
                        break;
                    }
                    case "JS_API": 
                    case "js": {
                        logicCodeResult.setType("javascript");
                        break;
                    }
                }
            }
            if (!logicCodeResult.isExistConflict()) {
                String writeFile = ToolUtil.isEmpty((Object)mergeCode) ? logicCodeGenerateInfo.getFileContent() : mergeCode;
                absolutePath = LogicCodeMergeUtil.writeNoConflictCode(logicCodeGenerateInfo, baseFile, absolutePath, dataId, writeFile);
            } else {
                absolutePath = "js".equals(logicCodeGenerateInfo.getFileType()) ? logicCodeGenerateInfo.getPath() : logicCodeGenerateInfo.getPath();
            }
        }
        logicCodeResult.setFilePath(com.jxdinfo.hussar.formdesign.common.util.ToolUtil.pathFomatterByOS((String)absolutePath));
        logicCodeResult.setFileId(dataId);
        logicCodeResult.setId(baseFile.getId());
        return logicCodeResult;
    }

    private static void formatCode(LogicCodeGenerateInfo logicCodeGenerateInfo) {
        String fileType = logicCodeGenerateInfo.getFileType();
        if (com.jxdinfo.hussar.formdesign.common.util.ToolUtil.isNotEmpty((Object)fileType) && com.jxdinfo.hussar.formdesign.common.util.ToolUtil.isNotEmpty((Object)logicCodeGenerateInfo.getFileContent())) {
            if (fileType.equals("controller") || fileType.equals("entity") || fileType.equals("mapper") || fileType.equals("service") || fileType.equals("serviceImpl") || fileType.equals("queryEntity") || fileType.equals("vo")) {
                logicCodeGenerateInfo.setFileContent(JavaCodeFormatUtil.format((String)logicCodeGenerateInfo.getFileContent()));
            }
            if (fileType.equals("js")) {
                logicCodeGenerateInfo.setFileContent(CodeFormatter.formatterHtml((String)logicCodeGenerateInfo.getFileContent(), (String)"typescript"));
            }
        }
    }

    private static String getVersionFileKey(LogicCodeGenerateInfo logicCodeGenerateInfo, BaseFile baseFile) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(baseFile.getId());
        if (ToolUtil.isNotEmpty((Object)logicCodeGenerateInfo.getPageType()) && !"WebPage".equals(logicCodeGenerateInfo.getPageType()) && !"MobilePage".equals(logicCodeGenerateInfo.getPageType())) {
            stringBuilder.append(logicCodeGenerateInfo.getPageType());
        }
        stringBuilder.append(logicCodeGenerateInfo.getFileType());
        if (ToolUtil.isNotEmpty((Object)logicCodeGenerateInfo.getFileName())) {
            stringBuilder.append(logicCodeGenerateInfo.getFileName());
        }
        return stringBuilder.toString();
    }

    public static String writeNoConflictCode(LogicCodeGenerateInfo logicCodeGenerateInfo, BaseFile baseFile, String absolutePath, String dataId, String writeFile) throws LcdpException, IOException {
        absolutePath = "js".equals(logicCodeGenerateInfo.getFileType()) ? filePublishService.writeStringToFile(writeFile, logicCodeGenerateInfo.getPath(), baseFile.getId()) : filePublishService.writeStringToFile(writeFile, logicCodeGenerateInfo.getPath(), baseFile.getId());
        versionManageService.saveLastPublishCode(dataId, logicCodeGenerateInfo.getFileContent());
        versionManageService.saveLastFileCode(dataId, writeFile);
        return absolutePath;
    }

    public static void delayWrite(String logicId) throws IOException, LcdpException {
        PublishCache publishCache = filePublishService.getCacheById(logicId);
        if (HussarUtils.isNotEmpty((Object)publishCache.getFileList()) && publishCache.getFileList().size() > 0) {
            Map fileList = publishCache.getFileList();
            filePublishService.submitDeferredTasks(fileList);
        }
        filePublishService.deleteCacheById(logicId);
    }
}

