/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.logic.publish.controller;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.logic.publish.service.LogicPublishService;
import com.jxdinfo.hussar.formdesign.publish.service.PublishService;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/logic/publish"})
public class LogicPublishController {
    private final Logger logger = LoggerFactory.getLogger(LogicPublishController.class);
    private final LogicPublishService logicPublishService;
    private final PublishService publishService;

    @Autowired
    public LogicPublishController(PublishService publishService, LogicPublishService logicPublishService) {
        this.logicPublishService = logicPublishService;
        this.publishService = publishService;
    }

    @RequestMapping(value={"/logicPublish"})
    public FormDesignResponse<List<CodeResult>> publishLogic(@RequestParam String id) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        this.publishService.deleteCacheByIdBeforePublish(id);
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        speedCodeResponse.setData(this.logicPublishService.publishCode(id));
        speedCodeResponse.setErrorCode(HttpStatus.OK.value());
        ToolUtil.triggerGarbageCollect();
        long end = System.currentTimeMillis();
        String useTime = ToolUtil.timeBetween((long)start, (long)end);
        this.logger.info("\u53d1\u5e03\u903b\u8f91\u4ee3\u7801\u603b\u8017\u65f6\uff1a{}", (Object)useTime);
        return speedCodeResponse;
    }
}

