/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.logic.file.fileoperate.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.OperateFileVO;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.AggregationDataInfoService;
import com.jxdinfo.hussar.formdesign.logic.common.model.LogicInfo;
import com.jxdinfo.hussar.formdesign.logic.file.fileoperate.service.LogicInfoService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/logicinfo"})
public class LogicInfoController {
    private static final Logger logger = LoggerFactory.getLogger(LogicInfoController.class);
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private IndexStorageLockService indexStorageLockService;
    @Autowired
    private AggregationDataInfoService aggregationDataInfoService;
    @Qualifier(value="LogicInfoServiceImpl")
    @Autowired
    private LogicInfoService logicInfoService;

    @PostMapping(value={"/add"})
    public FormDesignResponse<LogicInfo> addDataInfo(@RequestBody LogicInfo logicInfo) throws IOException, LcdpException {
        this.logicInfoService.create(logicInfo);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/edit"})
    public FormDesignResponse<PageInfo> updateDataInfo(@RequestBody LogicInfo logicInfo) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(logicInfo.getId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        if (ToolUtil.isEmpty((Object)((Object)logicInfo)) || ToolUtil.isEmpty((Object)logicInfo.getName())) {
            logger.error("\u6587\u4ef6\uff08{}\uff09\u7684name\u4f20\u9012\u4e3a\u7a7a\uff0clogicInfo\u5185\u5bb9\u4e3a\uff1a{}", (Object)logicInfo.getId(), (Object)JSONObject.toJSONString((Object)((Object)logicInfo)));
        }
        this.logicInfoService.updateFileMeta(logicInfo);
        return new FormDesignResponse();
    }

    private FormDesignResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        SecurityUser user = BaseSecurityUtil.getUser();
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        if (ToolUtil.isEmpty((Object)user)) {
            speedCodeResponse.setErrorCode(400);
            speedCodeResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return speedCodeResponse;
        }
        if (this.formDesignProperties.isLockEnabled() && ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !userId.equals(user.getId()))) {
            speedCodeResponse.setErrorCode(403);
            speedCodeResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return speedCodeResponse;
        }
        return new FormDesignResponse();
    }

    @PostMapping(value={"/del"})
    public FormDesignResponse<PageInfo> deleteDataInfo(String id) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(id)).getErrorCode() != 200) {
            return sharedStorage;
        }
        this.logicInfoService.delete(id);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/copy"})
    public FormDesignResponse<PageInfo> copyDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        this.logicInfoService.copy(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return new FormDesignResponse();
    }

    @PostMapping(value={"/move"})
    public FormDesignResponse<PageInfo> moveDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(operateFileVO.getId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        this.logicInfoService.move(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return new FormDesignResponse();
    }

    @PostMapping(value={"/save"})
    public FormDesignResponse<PageInfo> saveDataInfo(@RequestBody LogicInfo logicInfo) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(logicInfo.getId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        this.aggregationDataInfoService.disposeQuoteRelation(logicInfo.getId(), logicInfo.getData());
        this.logicInfoService.updateFileData(logicInfo);
        return new FormDesignResponse();
    }
}

