/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.logic.publish.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.logic.ModelMethodArgumentDescription;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.logic.common.model.LogicInfo;
import com.jxdinfo.hussar.formdesign.logic.file.fileoperate.service.LogicInfoService;
import com.jxdinfo.hussar.logic.generator.resolver.LogicBackendExternalResolver;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasMetadata;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationRuntime;
import com.jxdinfo.hussar.logic.structure.resolve.logic.LogicReference;
import com.jxdinfo.hussar.logic.structure.resolve.logic.LogicReferenceCategory;
import com.jxdinfo.hussar.logic.structure.resolve.service.LogicBackendMethodParameter;
import com.jxdinfo.hussar.logic.structure.resolve.service.LogicBackendMethodReference;
import com.jxdinfo.hussar.logic.structure.resolve.service.LogicBackendServiceMethod;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaActualType;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaClassType;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaParameterizedType;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaPrimitiveType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicBackendExternalResolverImpl
implements LogicBackendExternalResolver {
    private final FileMappingService fileMappingService;
    private final FormDesignProperties formDesignProperties;

    @Autowired
    public LogicBackendExternalResolverImpl(FileMappingService fileMappingService, FormDesignProperties formDesignProperties) {
        this.fileMappingService = fileMappingService;
        this.formDesignProperties = formDesignProperties;
    }

    public String resolveCustomType(String customTypeName, LogicGenerateConfigure configure) {
        String className = "";
        String[] customTypeNameSplit = customTypeName.split(":", 3);
        if (ToolUtil.isNotEmpty((Object)customTypeNameSplit)) {
            if (LogicGenerationRuntime.ENGINE.equals((Object)configure.getRuntime()) && !"class".equals(customTypeNameSplit[0])) {
                return "<dynamic-entity>";
            }
            if ("model".equals(customTypeNameSplit[0])) {
                try {
                    return ModelProvideAdapter.adaptor((String)customTypeNameSplit[1]).getDataModelStructureJavaName(customTypeNameSplit[1], customTypeNameSplit[2]);
                }
                catch (LcdpException | IOException | CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            } else if ("struct".equals(customTypeNameSplit[0])) {
                try {
                    String name = HussarUtils.firstCharToUpper((String)((LogicInfo)((LogicInfoService)SpringUtil.getBean(LogicInfoService.class)).get(customTypeNameSplit[1])).getName());
                    String moduleRelatePath = this.fileMappingService.getFormatParentPath(customTypeNameSplit[1]);
                    return FileUtil.packagePath((String[])new String[]{this.formDesignProperties.getJavaPath(), moduleRelatePath, "datastructure"}) + "." + name;
                }
                catch (LcdpException | IOException e) {
                    e.printStackTrace();
                }
            } else if ("class".equals(customTypeNameSplit[0])) {
                return customTypeNameSplit[1];
            }
        }
        return className;
    }

    public LogicReference resolveLogic(String logicReference, LogicGenerateConfigure configure) {
        if (ToolUtil.isNotEmpty((Object)logicReference)) {
            String rootPath = this.formDesignProperties.getProjectAndCodePath();
            try {
                String dataPath = this.fileMappingService.getDataPath(logicReference);
                File file = new File(rootPath + dataPath);
                if (file.exists()) {
                    String jsonString = FileUtils.readFileToString((File)file, (String)"UTF-8");
                    JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
                    LogicCanvasComponent logic = (LogicCanvasComponent)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)LogicCanvasComponent.class.getName());
                    LogicCanvasMetadata meta = (LogicCanvasMetadata)ClassAdapter.jsonObjectToBean((JSONObject)this.fileMappingService.getJsonObjectById(logicReference), (String)LogicCanvasMetadata.class.getName());
                    LogicReference logicRef = new LogicReference();
                    logicRef.setId(logicReference);
                    logicRef.setCategory(LogicReferenceCategory.BACKEND);
                    logicRef.setName(meta.getName());
                    logicRef.setTitle(meta.getDesc());
                    logicRef.setModules(new ArrayList<String>(Collections.singletonList(this.fileMappingService.getFormatParentPath(logicReference))));
                    logicRef.setParams(logic.getParams());
                    logicRef.setResult(logic.getResult());
                    return logicRef;
                }
            }
            catch (LcdpException | IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public LogicBackendServiceMethod resolveModelMethod(LogicBackendMethodReference modelMethodReference, LogicGenerateConfigure configure) {
        String modelId = modelMethodReference.getModelId();
        String methodId = modelMethodReference.getMethodId();
        try {
            if (LogicGenerationRuntime.MVC.equals((Object)configure.getRuntime())) {
                String mvcServiceClass = ModelProvideAdapter.adaptor((String)modelId).getModelJavaName(modelMethodReference.getModelId(), "Service");
                String mvcServiceMethod = modelMethodReference.getMethodName();
                List<Object> mvcParameters = new ArrayList<LogicBackendMethodParameter>();
                List inParameter = ModelProvideAdapter.adaptor((String)modelId).analyticalMethodReferenceInParameter(modelId, modelMethodReference.getMethodType(), methodId);
                for (ModelMethodArgumentDescription argumentDescription : inParameter) {
                    String inParamName = argumentDescription.getName();
                    JavaActualType inJavaActualType = this.analyzeParam(argumentDescription, modelId, methodId);
                    if (ToolUtil.isEmpty((Object)inJavaActualType)) {
                        mvcParameters = Collections.emptyList();
                        break;
                    }
                    mvcParameters.add(LogicBackendMethodParameter.of((String)inParamName, (JavaActualType)inJavaActualType));
                }
                List outParameter = ModelProvideAdapter.adaptor((String)modelId).analyticalMethodReferenceOutParameter(modelId, modelMethodReference.getMethodType(), methodId);
                ModelMethodArgumentDescription outParam = (ModelMethodArgumentDescription)outParameter.get(0);
                JavaParameterizedType outJavaActualType = JavaParameterizedType.of((JavaClassType)JavaClassType.of((String)"com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse"), (JavaActualType[])new JavaActualType[]{this.analyzeParam(outParam, modelId, methodId)});
                return LogicBackendServiceMethod.mvcSignatureOf((String)mvcServiceClass, (String)mvcServiceMethod, (JavaActualType)outJavaActualType, mvcParameters);
            }
            String getOrPost = "post";
            if ("FormQuery".equals(modelMethodReference.getMethodType())) {
                getOrPost = "get";
            }
            String businessId = String.format("%s %s", getOrPost, FileUtil.posixPath((String[])new String[]{ModelProvideAdapter.adaptor((String)modelId).getApiPrefix(modelId), modelMethodReference.getMethodName()}));
            List inParameter = ModelProvideAdapter.adaptor((String)modelId).analyticalMethodReferenceInParameter(modelId, modelMethodReference.getMethodType(), methodId);
            List engineParameters = inParameter.stream().map(ModelMethodArgumentDescription::getName).collect(Collectors.toList());
            String heMethodInParamType = ModelProvideAdapter.adaptor((String)modelId).judgmentHEMethodInParam(modelId, methodId);
            if (ToolUtil.isNotEmpty((Object)heMethodInParamType) && "body".equals(heMethodInParamType)) {
                return LogicBackendServiceMethod.engineBodySignatureOf((String)businessId, (String)((String)engineParameters.get(0)));
            }
            if (ToolUtil.isNotEmpty((Object)heMethodInParamType) && "none".equals(heMethodInParamType)) {
                return LogicBackendServiceMethod.engineArgsSignatureOf((String)businessId, Collections.emptyList());
            }
            return LogicBackendServiceMethod.engineArgsSignatureOf((String)businessId, engineParameters);
        }
        catch (LcdpException | IOException | CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JavaActualType analyzeParam(ModelMethodArgumentDescription argumentDescription, String modelId, String methodId) throws LcdpException, IOException, CloneNotSupportedException {
        void var4_22;
        if (ToolUtil.isNotEmpty((Object)argumentDescription.getRule())) {
            String className = "";
            String rule = "";
            boolean isPageClass = false;
            switch (argumentDescription.getRule()) {
                case "model": 
                case "PageVo": 
                case "FlowModelDTO": {
                    rule = argumentDescription.getRule();
                    break;
                }
                case "PageModel": {
                    rule = "model";
                    isPageClass = true;
                    break;
                }
                case "dataSet": {
                    String dataSetId = ModelProvideAdapter.adaptor((String)modelId).getDataSetId(modelId, methodId);
                    rule = argumentDescription.getRule() + ":" + dataSetId;
                    break;
                }
                case "none": {
                    rule = "";
                }
            }
            if (!ToolUtil.isNotEmpty((Object)rule)) return null;
            className = ModelProvideAdapter.adaptor((String)modelId).getDataModelStructureJavaName(modelId, rule);
            if (isPageClass) {
                JavaParameterizedType javaParameterizedType = JavaParameterizedType.of((JavaClassType)JavaClassType.of((String)"com.baomidou.mybatisplus.extension.plugins.pagination.Page"), (JavaActualType[])new JavaActualType[]{JavaClassType.of((String)className)});
                return var4_22;
            } else {
                JavaClassType javaClassType = JavaClassType.of((String)className);
            }
            return var4_22;
        } else {
            switch (argumentDescription.getType()) {
                case "String": {
                    JavaClassType javaClassType = JavaClassType.of((String)String.class.getName());
                    return var4_22;
                }
                case "boolean": {
                    JavaPrimitiveType javaPrimitiveType = JavaPrimitiveType.BOOLEAN;
                    return var4_22;
                }
                case "Boolean": {
                    JavaClassType javaClassType = JavaClassType.of((String)Boolean.class.getName());
                    return var4_22;
                }
                case "List": {
                    String baseDataType = argumentDescription.getBaseDataType();
                    if ("String".equals(baseDataType)) {
                        JavaParameterizedType javaParameterizedType = JavaParameterizedType.of((JavaClassType)JavaClassType.of((String)List.class.getName()), (JavaActualType[])new JavaActualType[]{JavaClassType.of((String)String.class.getName())});
                        return var4_22;
                    }
                    JavaClassType javaClassType = JavaClassType.of((String)List.class.getName());
                    return var4_22;
                }
                default: {
                    return var4_22;
                }
            }
        }
    }
}

