/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.logic.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.logic.result.LogicCodeResult;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import java.io.IOException;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="LOGIC_RESULT_BEAN")
public class LogicCodeMergeServiceImpl
implements CodeMergeService {
    @Resource
    private VersionManageService versionManageService;
    @Resource
    private FilePublishService filePublishService;

    public void writeMergeCode(CodeResult result) throws IOException, LcdpException {
        if (result instanceof LogicCodeResult) {
            LogicCodeResult codeResult = (LogicCodeResult)result;
            String dataId = codeResult.getFileId();
            String currentFile = ToolUtil.textFomatterByOS((String)codeResult.getCurrentFile());
            String newContent = codeResult.getNewCode();
            String filePath = codeResult.getFilePath();
            this.filePublishService.writeStringToFile(currentFile, filePath);
            this.versionManageService.saveLastPublishCode(dataId, newContent);
            this.versionManageService.saveLastFileCode(dataId, currentFile);
        }
    }

    public CodeResult parseData(String s) {
        return (CodeResult)JSON.parseObject((String)s, LogicCodeResult.class);
    }
}

