/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.logic.publish.service.impl;

import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.logic.publish.service.LogicPublishService;
import com.jxdinfo.hussar.formdesign.publish.service.LogicQuotePublishService;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicQuotePublishServiceImpl
implements LogicQuotePublishService {
    private final SysQuoteRelationService sysQuoteRelationService;
    private final LogicPublishService logicPublishService;

    @Autowired
    public LogicQuotePublishServiceImpl(SysQuoteRelationService sysQuoteRelationService, LogicPublishService logicPublishService) {
        this.sysQuoteRelationService = sysQuoteRelationService;
        this.logicPublishService = logicPublishService;
    }

    public void referencePublish(PublishCtx<CodeResult> publishCtx) throws IOException, LcdpException, CloneNotSupportedException {
        Optional<Object> logicIdListOpt = Optional.ofNullable(this.sysQuoteRelationService.getQuoteIdList(publishCtx.getBaseFile().getId(), "BackendLogic").getData());
        if (logicIdListOpt.isPresent()) {
            List logicIds = publishCtx.setAndSiftPublishedResources((List)logicIdListOpt.get());
            for (String logicId : logicIds) {
                this.logicPublishService.publishLogicCode(logicId, publishCtx);
            }
        }
    }
}

