/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.logic.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelPublishAdapter;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.data.structure.publish.service.DataStructurePublishService;
import com.jxdinfo.hussar.formdesign.logic.publish.service.LogicBeforePublishService;
import com.jxdinfo.hussar.formdesign.logic.publish.service.LogicPublishService;
import com.jxdinfo.hussar.formdesign.logic.util.LogicCodeMergeUtil;
import com.jxdinfo.hussar.logic.engine.service.SourceService;
import com.jxdinfo.hussar.logic.generator.resolver.LogicBackendExternalResolver;
import com.jxdinfo.hussar.logic.generator.service.LogicGenerateService;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasMetadata;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateResult;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateSource;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationLanguage;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationPlatform;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationRuntime;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFile;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFileType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import com.jxdinfo.hussar.support.choreo.api.dto.ApiNamingDto;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataConfigService;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Service;

@Service
public class LogicPublishServiceImpl
implements LogicPublishService {
    @Resource
    private LogicGenerateService logicGenerateService;
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private LogicBeforePublishService logicBeforePublishService;
    @Resource
    private SourceService sourceService;
    @Resource
    private LogicBackendExternalResolver logicBackendExternalResolver;
    @Resource
    private EngineBussnessdataConfigService engineBussnessdataConfigService;
    @Resource
    private SysQuoteRelationService sysQuoteRelationService;
    @Resource
    private DataStructurePublishService dataStructurePublishService;

    @Override
    public List<CodeResult> publishCode(String logicId) throws IOException, LcdpException, CloneNotSupportedException {
        PublishCtx publishCtx = new PublishCtx();
        this.logicBeforePublishService.beforePublish(logicId, publishCtx);
        List<Object> codeResults = new ArrayList<CodeResult>();
        if (ToolUtil.isNotEmpty((Object)logicId)) {
            this.publishLogicCode(logicId, (PublishCtx<CodeResult>)publishCtx);
            boolean isConflict = false;
            for (CodeResult codeResult : publishCtx.getGenCodeResults()) {
                if (!codeResult.isExistConflict()) continue;
                isConflict = true;
                break;
            }
            if (!isConflict) {
                LogicCodeMergeUtil.delayWrite(publishCtx.getBaseFile().getId());
            }
            codeResults = publishCtx.getGenCodeResults();
        }
        return codeResults;
    }

    @Override
    public void publishLogicCode(String logicId, PublishCtx<CodeResult> publishCtx) throws IOException, LcdpException, CloneNotSupportedException {
        publishCtx.addPublishedResources(logicId);
        this.publishResource(logicId, publishCtx);
        LogicGenerateResult logicGenerateResult = this.structureAndPublish(logicId, publishCtx);
        if ("ORIGINAL".equals(publishCtx.getStrategy())) {
            LogicCodeMergeUtil.render(logicId, logicGenerateResult, publishCtx);
        } else {
            String api = logicGenerateResult.getApi();
            List parameterNames = logicGenerateResult.getParameterNames();
            LogicCodeMergeUtil.render(logicId, logicGenerateResult, publishCtx);
            for (LogicGenerateFile file : logicGenerateResult.getFiles()) {
                if (HussarUtils.equals((Object)LogicGenerateFileType.JS_API, (Object)file.getType())) continue;
                this.sourceService.saveOrUpdateProd(file.getId(), file.getContent());
                this.publishHE(file, api, parameterNames);
            }
        }
    }

    private LogicGenerateResult structureAndPublish(String logicId, PublishCtx publishCtx) throws LcdpException, IOException {
        LogicGenerateResult result = new LogicGenerateResult();
        if (ToolUtil.isNotEmpty((Object)logicId)) {
            String rootPath = this.formDesignProperties.getProjectAndCodePath();
            String dataPath = this.fileMappingService.getDataPath(logicId);
            File file = new File(rootPath + dataPath);
            if (file.exists()) {
                String jsonString = FileUtils.readFileToString((File)file, (String)"UTF-8");
                JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
                LogicCanvasComponent logic = (LogicCanvasComponent)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)LogicCanvasComponent.class.getName());
                LogicCanvasMetadata meta = (LogicCanvasMetadata)ClassAdapter.jsonObjectToBean((JSONObject)this.fileMappingService.getJsonObjectById(logicId), (String)LogicCanvasMetadata.class.getName());
                LogicGenerateSource source = new LogicGenerateSource();
                source.setModules(new ArrayList<String>(Collections.singletonList(this.fileMappingService.getFormatParentPath(logicId))));
                source.setMeta(meta);
                source.setRoot(logic);
                LogicGenerateConfigure configure = new LogicGenerateConfigure();
                configure.setBackendExternalResolver(this.logicBackendExternalResolver);
                configure.setBackendProjectSourceRoot(ToolUtil.pathFomatterByOS((String)(this.formDesignProperties.getBackProjectPath() + this.formDesignProperties.getJavaCodePath())));
                configure.setBackendApiPrefix("/");
                configure.setBackendPrefixPackage(this.formDesignProperties.getJavaPath());
                configure.setBackendControllerPackage("controller");
                configure.setBackendServiceInterfacePackage("service");
                configure.setBackendServiceImplPackage("service.impl");
                configure.setBackendDtoPackage("dto");
                configure.setBackendDaoPackage("dao");
                configure.setBackendMapperPackage("dao.mapper");
                configure.setFrontendProjectSourceRoot(this.formDesignProperties.getFrontProjectPath());
                configure.setFrontendProjectSourceRoot(ToolUtil.pathFomatterByOS((String)(this.formDesignProperties.getFrontProjectPath() + "\\src")));
                configure.setFrontendApiModule("pages\\index\\api");
                configure.setLanguage(LogicGenerationLanguage.JAVA);
                if ("ORIGINAL".equals(publishCtx.getStrategy())) {
                    configure.setRuntime(LogicGenerationRuntime.MVC);
                } else {
                    configure.setRuntime(LogicGenerationRuntime.ENGINE);
                }
                configure.setPlatform(LogicGenerationPlatform.LOW_CODE_PLATFORM);
                result = this.logicGenerateService.generate(source, configure);
            }
        }
        return result;
    }

    private void publishHE(LogicGenerateFile logicGenerateFile, String api, List<String> parameterNames) {
        PushBackCtx pushBackCtx = new PushBackCtx();
        ApiNamingDto apiNamingDto = new ApiNamingDto();
        NodeBusiness nodeBusiness = new NodeBusiness();
        String businessId = "POST " + api;
        apiNamingDto.setBusinessType("HTTP");
        apiNamingDto.setBusinessId(businessId);
        String serviceAndNodeName = logicGenerateFile.getId();
        apiNamingDto.setServiceName(serviceAndNodeName);
        nodeBusiness.setNodeName(serviceAndNodeName);
        nodeBusiness.setActionName("runLogic");
        nodeBusiness.setDataServiceCode("logicOption_runLogic");
        nodeBusiness.setDataServiceActionName("com.jxdinfo.hussar.formdesign.logic.publish.service.impl.EngineLogicParamServiceImpl");
        nodeBusiness.setNodeType("single");
        nodeBusiness.setJsonParams(JSON.toJSONString(parameterNames));
        pushBackCtx.addApiNaming(apiNamingDto);
        pushBackCtx.addNodeBusiness(nodeBusiness);
        this.engineBussnessdataConfigService.pushApi(pushBackCtx);
    }

    public void referencePublish(PublishCtx<CodeResult> publishCtx) throws IOException, LcdpException, CloneNotSupportedException {
        Optional<Object> logicIdListOpt = Optional.ofNullable(this.sysQuoteRelationService.getQuoteIdList(publishCtx.getBaseFile().getId(), "logic").getData());
        List logicIds = ((List)logicIdListOpt.get()).stream().distinct().collect(Collectors.toList());
        for (String logicId : logicIds) {
            publishCtx.addCodeResults(this.publishCode(logicId));
        }
    }

    public void publishResource(String logicId, PublishCtx<CodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        List modelIds = publishCtx.setAndSiftPublishedResources(this.getRelationIds(logicId, ToolUtil.firstToLower((String)"DataModel")));
        for (Object modelId : modelIds) {
            if (!this.fileMappingService.isFileExist((String)modelId)) continue;
            ModelPublishAdapter.sync((String)modelId);
            ModelPublishAdapter.adaptor((String)modelId, publishCtx);
        }
        List structIds = publishCtx.setAndSiftPublishedResources(this.getRelationIds(logicId, "dataStructure"));
        for (String structId : structIds) {
            this.dataStructurePublishService.publishStructureCode(structId, publishCtx);
        }
        List logicIds = publishCtx.setAndSiftPublishedResources(this.getRelationIds(logicId, "BackendLogic"));
        for (String id : logicIds) {
            this.publishLogicCode(id, publishCtx);
        }
    }

    public List<String> getRelationIds(String id, String type) {
        List<String> ids = new ArrayList<String>();
        Optional<Object> modelIdListOpt = Optional.ofNullable(this.sysQuoteRelationService.getQuoteIdList(id, type).getData());
        if (modelIdListOpt.isPresent()) {
            ids = ((List)modelIdListOpt.get()).stream().distinct().collect(Collectors.toList());
        }
        return ids;
    }
}

