/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class HTableLayoutVoidVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/hTableLayout/el_tableLayout.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderCellStylesAndClass(lcdpComponent);
        this.renderPropsData(lcdpComponent, ctx);
        this.renderSlotHidden(lcdpComponent, ctx);
        this.renderChildSlots(lcdpComponent);
        this.renderIsAutoHeight(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        lcdpComponent.addAttr(":props", lcdpComponent.getInstanceKey() + "PropsData");
        lcdpComponent.addAttr(":themeName", lcdpComponent.getInstanceKey() + "ThemeName");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealHiddenAttr(lcdpComponent, ctx);
    }

    private void renderSlotHidden(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr(":slotHidden", lcdpComponent.getInstanceKey() + "SlotHidden");
        ctx.addData(lcdpComponent.getInstanceKey() + "SlotHidden: []", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6743\u9650\u914d\u7f6e\u53d8\u91cf"));
    }

    private void renderCellStylesAndClass(LcdpComponent lcdpComponent) {
        JSONObject tableConfigs = (JSONObject)lcdpComponent.getProps().get("tableConfigs");
        JSONArray gridAreas = tableConfigs.getJSONArray("gridAreas");
        JSONArray tableCells = tableConfigs.getJSONArray("tableCells");
        for (Object o : tableCells) {
            JSONObject cell = (JSONObject)o;
            String name = cell.getString("slotName");
            StringBuilder cellClass = new StringBuilder("table-grid-container-cell ");
            StringBuilder cellStyles = new StringBuilder();
            if (ToolUtil.isNotEmpty((Object)cell.getString("background"))) {
                cellStyles.append("background:").append(cell.getString("background")).append(";");
            }
            if (ToolUtil.isNotEmpty((Object)cell.getString("alignItems"))) {
                cellStyles.append("justify-content:").append(cell.getString("alignItems")).append(";");
            }
            for (int i = 0; i < gridAreas.size(); ++i) {
                JSONArray area = (JSONArray)gridAreas.get(i);
                int cellIndex = area.indexOf((Object)name);
                if (cellIndex != -1 && i == 0) {
                    cellClass.append("table-layout-top-side ");
                    if (ToolUtil.isNotEmpty((Object)cell.getString("borderTop"))) {
                        cellStyles.append("border-top:").append(cell.getString("borderTop")).append(";");
                    }
                }
                if (cellIndex != -1 && i == gridAreas.size() - 1) {
                    cellClass.append("table-layout-bottom-side ");
                }
                if (cellIndex != -1 && ToolUtil.isNotEmpty((Object)cell.getString("borderBottom"))) {
                    cellStyles.append("border-bottom:").append(cell.getString("borderBottom")).append(";");
                } else if (cellIndex != -1 && i != gridAreas.size() - 1) {
                    JSONArray nextRow = (JSONArray)gridAreas.get(i + 1);
                    String bottomCellName = nextRow.get(cellIndex).toString();
                    JSONObject bottomCell = (JSONObject)tableCells.stream().filter(tableCell -> JSON.parseObject((String)JSON.toJSONString((Object)tableCell)).getString("slotName").equals(bottomCellName)).collect(Collectors.toList()).get(0);
                    if (ToolUtil.isNotEmpty((Object)bottomCell.getString("borderTop"))) {
                        cellStyles.append("border-bottom:").append(bottomCell.getString("borderTop")).append(";");
                    }
                }
                if (cellIndex == 0) {
                    cellClass.append("table-layout-left-side ");
                }
                if (cellIndex != -1 && ToolUtil.isNotEmpty((Object)cell.getString("borderLeft"))) {
                    cellStyles.append("border-left:").append(cell.getString("borderLeft")).append(";");
                } else if (cellIndex > 0) {
                    String leftCellName = area.get(cellIndex - 1).toString();
                    JSONObject leftCell = (JSONObject)tableCells.stream().filter(tableCell -> JSON.parseObject((String)JSON.toJSONString((Object)tableCell)).getString("slotName").equals(leftCellName)).collect(Collectors.toList()).get(0);
                    if (ToolUtil.isNotEmpty((Object)leftCell.getString("borderRight"))) {
                        cellStyles.append("border-left:").append(leftCell.getString("borderRight")).append(";");
                    }
                }
                if (area.lastIndexOf((Object)name) != area.size() - 1) continue;
                cellClass.append("table-layout-right-side ");
                if (!ToolUtil.isNotEmpty((Object)cell.getString("borderRight"))) continue;
                cellStyles.append("border-right:").append(cell.getString("borderRight")).append(";");
            }
            cell.put("cellStyles", (Object)cellStyles.toString());
        }
        lcdpComponent.addRenderParam("tableCells", (Object)tableCells);
    }

    public void renderChildSlots(LcdpComponent lcdpComponent) {
        ArrayList<String> childComponent = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)lcdpComponent.getChildrenComponents())) {
            for (String k : lcdpComponent.getChildrenComponents().keySet()) {
                childComponent.add(k);
            }
        }
        lcdpComponent.addRenderParam("childComponent", childComponent);
    }

    public void renderIsAutoHeight(LcdpComponent lcdpComponent, Ctx ctx) {
        if (ToolUtil.isNotEmpty((Object)lcdpComponent.isAutoHeight()) && lcdpComponent.isAutoHeight()) {
            ctx.addData(lcdpComponent.getInstanceKey() + "IsAutoHeight: true", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u662f\u5426\u9ad8\u5ea6\u81ea\u9002\u5e94"));
        } else {
            ctx.addData(lcdpComponent.getInstanceKey() + "IsAutoHeight: false", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u662f\u5426\u9ad8\u5ea6\u81ea\u9002\u5e94"));
        }
        lcdpComponent.addAttr(":isAutoHeight", lcdpComponent.getInstanceKey() + "IsAutoHeight");
    }

    public void renderPropsData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(lcdpComponent.getProps());
        if (props.containsKey("exegesis")) {
            props.remove("exegesis");
        }
        String propsData = "";
        if (props.size() != 0) {
            HashMap<String, HashMap<String, String>> renderParams = new HashMap<String, HashMap<String, String>>();
            renderParams.put("propsMap", props);
            for (String key : props.keySet()) {
                String value = props.get(key).toString();
                if (props.get(key) instanceof String) {
                    value = "'" + value + "'";
                }
                props.put(key, value);
            }
            propsData = propsData + RenderUtil.renderTemplate((String)"template/elementui/element/hTableLayout/h-table-layout-props-data.ftl", renderParams);
        }
        ctx.addData(lcdpComponent.getInstanceKey() + "PropsData: {" + propsData + " }", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"prop\u53d8\u91cf"));
        String styleSchemeClassName = lcdpComponent.getStyleSchemeClassName();
        ctx.addData(lcdpComponent.getInstanceKey() + "ThemeName: '" + styleSchemeClassName + "'", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"themeName\u5c5e\u6027"));
    }
}

