/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.util;

public class Paths {
    public static String stripTrailingSeparator(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        int i = path.length();
        if (path.charAt(path.length() - 1) != '/') {
            return path;
        }
        while (path.charAt(--i - 1) == '/') {
        }
        return path.substring(0, i);
    }

    public static int compare(byte[] aPath, int aPos, int aEnd, int aMode, byte[] bPath, int bPos, int bEnd, int bMode) {
        int cmp = Paths.coreCompare(aPath, aPos, aEnd, aMode, bPath, bPos, bEnd, bMode);
        if (cmp == 0) {
            cmp = Paths.lastPathChar(aMode) - Paths.lastPathChar(bMode);
        }
        return cmp;
    }

    public static int compareSameName(byte[] aPath, int aPos, int aEnd, byte[] bPath, int bPos, int bEnd, int bMode) {
        return Paths.coreCompare(aPath, aPos, aEnd, 16384, bPath, bPos, bEnd, bMode);
    }

    private static int coreCompare(byte[] aPath, int aPos, int aEnd, int aMode, byte[] bPath, int bPos, int bEnd, int bMode) {
        while (aPos < aEnd && bPos < bEnd) {
            int cmp;
            if ((cmp = (aPath[aPos++] & 0xFF) - (bPath[bPos++] & 0xFF)) == 0) continue;
            return cmp;
        }
        if (aPos < aEnd) {
            return (aPath[aPos] & 0xFF) - Paths.lastPathChar(bMode);
        }
        if (bPos < bEnd) {
            return Paths.lastPathChar(aMode) - (bPath[bPos] & 0xFF);
        }
        return 0;
    }

    private static int lastPathChar(int mode) {
        if ((mode & 0xF000) == 16384) {
            return 47;
        }
        return 0;
    }

    private Paths() {
    }
}

