/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.util;

import com.jxdinfo.hussar.formdesign.jgit.annotations.Nullable;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.errors.CommandFailedException;
import com.jxdinfo.hussar.formdesign.jgit.errors.ConfigInvalidException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.lib.StoredConfig;
import com.jxdinfo.hussar.formdesign.jgit.util.FS;
import com.jxdinfo.hussar.formdesign.jgit.util.FileUtils;
import com.jxdinfo.hussar.formdesign.jgit.util.ProcessResult;
import com.jxdinfo.hussar.formdesign.jgit.util.QuotedString;
import com.jxdinfo.hussar.formdesign.jgit.util.StringUtils;
import com.jxdinfo.hussar.formdesign.jgit.util.SystemReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FS_POSIX
extends FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS_POSIX.class);
    private static final String DEFAULT_GIT_LOCATION = "/usr/bin/git";
    private static final int DEFAULT_UMASK = 18;
    private volatile int umask = -1;
    private static final Map<FileStore, Boolean> CAN_HARD_LINK = new ConcurrentHashMap<FileStore, Boolean>();
    private volatile AtomicFileCreation supportsAtomicFileCreation = AtomicFileCreation.UNDEFINED;

    protected FS_POSIX() {
    }

    protected FS_POSIX(FS src) {
        super(src);
        if (src instanceof FS_POSIX) {
            this.umask = ((FS_POSIX)src).umask;
        }
    }

    @Override
    public FS newInstance() {
        return new FS_POSIX(this);
    }

    public void setUmask(int umask) {
        this.umask = umask;
    }

    private int umask() {
        int u = this.umask;
        if (u == -1) {
            this.umask = u = FS_POSIX.readUmask();
        }
        return u;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int readUmask() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "umask"}, null, null);
            try (BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset().name()));){
                String s;
                if (p.waitFor() == 0 && (s = lineRead.readLine()) != null && s.matches("0?\\d{3}")) {
                    int n2 = Integer.parseInt(s, 8);
                    return n2;
                }
                int n = 18;
                return n;
            }
        }
        catch (Exception e) {
            return 18;
        }
    }

    @Override
    protected File discoverGitExe() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_POSIX.searchPath(path, "git");
        if (SystemReader.getInstance().isMacOS()) {
            String w;
            if ((gitExe == null || DEFAULT_GIT_LOCATION.equals(gitExe.getPath())) && FS_POSIX.searchPath(path, "bash") != null) {
                try {
                    w = FS_POSIX.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
                    if (!StringUtils.isEmptyOrNull(w)) {
                        gitExe = new File(w);
                    }
                }
                catch (CommandFailedException e) {
                    LOG.warn(e.getMessage());
                }
            }
            if (gitExe != null && DEFAULT_GIT_LOCATION.equals(gitExe.getPath())) {
                try {
                    w = FS_POSIX.readPipe(this.userHome(), new String[]{"xcode-select", "-p"}, Charset.defaultCharset().name());
                    if (StringUtils.isEmptyOrNull(w)) {
                        gitExe = null;
                    } else {
                        File realGitExe = new File(new File(w), DEFAULT_GIT_LOCATION.substring(1));
                        if (!realGitExe.exists()) {
                            gitExe = null;
                        }
                    }
                }
                catch (CommandFailedException e) {
                    gitExe = null;
                }
            }
        }
        return gitExe;
    }

    @Override
    public boolean isCaseSensitive() {
        return !SystemReader.getInstance().isMacOS();
    }

    @Override
    public boolean supportsExecute() {
        return true;
    }

    @Override
    public boolean canExecute(File f) {
        return FileUtils.canExecute(f);
    }

    @Override
    public boolean setExecute(File f, boolean canExecute) {
        if (!this.isFile(f)) {
            return false;
        }
        if (!canExecute) {
            return f.setExecutable(false, false);
        }
        try {
            Path path = FileUtils.toPath(f);
            Set<PosixFilePermission> pset = Files.getPosixFilePermissions(path, new LinkOption[0]);
            pset.add(PosixFilePermission.OWNER_EXECUTE);
            int mask = this.umask();
            FS_POSIX.apply(pset, mask, PosixFilePermission.GROUP_EXECUTE, 8);
            FS_POSIX.apply(pset, mask, PosixFilePermission.OTHERS_EXECUTE, 1);
            Files.setPosixFilePermissions(path, pset);
            return true;
        }
        catch (IOException e) {
            boolean debug = Boolean.parseBoolean(SystemReader.getInstance().getProperty("jgit.fs.debug"));
            if (debug) {
                System.err.println(e);
            }
            return false;
        }
    }

    private static void apply(Set<PosixFilePermission> set, int umask, PosixFilePermission perm, int test) {
        if ((umask & test) == 0) {
            set.add(perm);
        } else {
            set.remove((Object)perm);
        }
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(4 + args.length);
        argv.add("sh");
        argv.add("-c");
        argv.add(cmd + " \"$@\"");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    @Override
    String shellQuote(String cmd) {
        return QuotedString.BOURNE.quote(cmd);
    }

    @Override
    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args, OutputStream outRedirect, OutputStream errRedirect, String stdinArgs) throws JGitInternalException {
        return this.internalRunHookIfPresent(repository, hookName, args, outRedirect, errRedirect, stdinArgs);
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return false;
    }

    @Override
    public void setHidden(File path, boolean hidden) throws IOException {
    }

    @Override
    public FS.Attributes getAttributes(File path) {
        return FileUtils.getFileAttributesPosix(this, path);
    }

    @Override
    public File normalize(File file) {
        return FileUtils.normalize(file);
    }

    @Override
    public String normalize(String name) {
        return FileUtils.normalize(name);
    }

    @Override
    public boolean supportsAtomicCreateNewFile() {
        if (this.supportsAtomicFileCreation == AtomicFileCreation.UNDEFINED) {
            try {
                StoredConfig config = SystemReader.getInstance().getUserConfig();
                String value = config.getString("core", null, "supportsatomicfilecreation");
                this.supportsAtomicFileCreation = value != null ? (StringUtils.toBoolean(value) ? AtomicFileCreation.SUPPORTED : AtomicFileCreation.NOT_SUPPORTED) : AtomicFileCreation.SUPPORTED;
            }
            catch (ConfigInvalidException | IOException e) {
                LOG.warn(JGitText.get().assumeAtomicCreateNewFile, (Throwable)e);
                this.supportsAtomicFileCreation = AtomicFileCreation.SUPPORTED;
            }
        }
        return this.supportsAtomicFileCreation == AtomicFileCreation.SUPPORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public boolean createNewFile(File lock) throws IOException {
        boolean bl;
        Path link;
        block16: {
            boolean bl2;
            block15: {
                if (!lock.createNewFile()) {
                    return false;
                }
                if (this.supportsAtomicCreateNewFile()) {
                    return true;
                }
                Path lockPath = lock.toPath();
                link = null;
                FileStore store = null;
                try {
                    store = Files.getFileStore(lockPath);
                }
                catch (SecurityException e) {
                    return true;
                }
                try {
                    Boolean canLink = CAN_HARD_LINK.computeIfAbsent(store, s -> Boolean.TRUE);
                    if (Boolean.FALSE.equals(canLink)) {
                        boolean bl3 = true;
                        return bl3;
                    }
                    link = Files.createLink(Paths.get(lock.getAbsolutePath() + ".lnk", new String[0]), lockPath);
                    Integer nlink = (Integer)Files.getAttribute(lockPath, "unix:nlink", new LinkOption[0]);
                    if (nlink > 2) {
                        LOG.warn(MessageFormat.format(JGitText.get().failedAtomicFileCreation, lockPath, nlink));
                        bl2 = false;
                        if (link == null) return bl2;
                        break block15;
                    }
                    if (nlink < 2) {
                        CAN_HARD_LINK.put(store, Boolean.FALSE);
                    }
                    bl = true;
                    if (link == null) return bl;
                    break block16;
                }
                catch (IllegalArgumentException | UnsupportedOperationException e) {
                    CAN_HARD_LINK.put(store, Boolean.FALSE);
                    boolean bl4 = true;
                    return bl4;
                }
            }
            Files.delete(link);
            return bl2;
        }
        Files.delete(link);
        return bl;
        finally {
            if (link != null) {
                Files.delete(link);
            }
        }
    }

    @Override
    public FS.LockToken createNewFileAtomic(File file) throws IOException {
        Path path;
        try {
            path = file.toPath();
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException | InvalidPathException e) {
            return FS_POSIX.token(false, null);
        }
        if (this.supportsAtomicCreateNewFile()) {
            return FS_POSIX.token(true, null);
        }
        Path link = null;
        FileStore store = null;
        try {
            store = Files.getFileStore(path);
        }
        catch (SecurityException e) {
            return FS_POSIX.token(true, null);
        }
        try {
            Boolean canLink = CAN_HARD_LINK.computeIfAbsent(store, s -> Boolean.TRUE);
            if (Boolean.FALSE.equals(canLink)) {
                return FS_POSIX.token(true, null);
            }
            link = Files.createLink(Paths.get(FS_POSIX.uniqueLinkPath(file), new String[0]), path);
            Integer nlink = (Integer)Files.getAttribute(path, "unix:nlink", new LinkOption[0]);
            if (nlink > 2) {
                LOG.warn(MessageFormat.format(JGitText.get().failedAtomicFileCreation, path, nlink));
                return FS_POSIX.token(false, link);
            }
            if (nlink < 2) {
                CAN_HARD_LINK.put(store, Boolean.FALSE);
            }
            return FS_POSIX.token(true, link);
        }
        catch (IllegalArgumentException | SecurityException | UnsupportedOperationException | FileSystemException e) {
            CAN_HARD_LINK.put(store, Boolean.FALSE);
            return FS_POSIX.token(true, link);
        }
    }

    private static FS.LockToken token(boolean created, @Nullable Path p) {
        return p != null && Files.exists(p, new LinkOption[0]) ? new FS.LockToken(created, Optional.of(p)) : new FS.LockToken(created, Optional.empty());
    }

    private static String uniqueLinkPath(File file) {
        UUID id = UUID.randomUUID();
        return file.getAbsolutePath() + "." + Long.toHexString(id.getMostSignificantBits()) + Long.toHexString(id.getLeastSignificantBits());
    }

    private static enum AtomicFileCreation {
        SUPPORTED,
        NOT_SUPPORTED,
        UNDEFINED;

    }
}

