/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.revwalk;

import com.jxdinfo.hussar.formdesign.jgit.annotations.Nullable;
import com.jxdinfo.hussar.formdesign.jgit.errors.CorruptObjectException;
import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.errors.MissingObjectException;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.Constants;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectInserter;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectReader;
import com.jxdinfo.hussar.formdesign.jgit.lib.PersonIdent;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevObject;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.util.MutableInteger;
import com.jxdinfo.hussar.formdesign.jgit.util.RawParseUtils;
import com.jxdinfo.hussar.formdesign.jgit.util.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;

public class RevTag
extends RevObject {
    private static final byte[] hSignature = Constants.encodeASCII("-----BEGIN PGP SIGNATURE-----");
    private RevObject object;
    private byte[] buffer;
    private String tagName;

    public static RevTag parse(byte[] raw) throws CorruptObjectException {
        return RevTag.parse(new RevWalk((ObjectReader)null), raw);
    }

    public static RevTag parse(RevWalk rw, byte[] raw) throws CorruptObjectException {
        try (ObjectInserter.Formatter fmt = new ObjectInserter.Formatter();){
            RevTag r = rw.lookupTag(fmt.idFor(4, raw));
            r.parseCanonical(rw, raw);
            r.buffer = raw;
            RevTag revTag = r;
            return revTag;
        }
    }

    protected RevTag(AnyObjectId id) {
        super(id);
    }

    @Override
    void parseHeaders(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.parseCanonical(walk, walk.getCachedBytes(this));
    }

    @Override
    void parseBody(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (this.buffer == null) {
            this.buffer = walk.getCachedBytes(this);
            if ((this.flags & 1) == 0) {
                this.parseCanonical(walk, this.buffer);
            }
        }
    }

    void parseCanonical(RevWalk walk, byte[] rawTag) throws CorruptObjectException {
        MutableInteger pos = new MutableInteger();
        pos.value = 53;
        int oType = Constants.decodeTypeString(this, rawTag, (byte)10, pos);
        walk.idBuffer.fromString(rawTag, 7);
        this.object = walk.lookupAny(walk.idBuffer, oType);
        int p = pos.value += 4;
        int nameEnd = RawParseUtils.nextLF(rawTag, p) - 1;
        this.tagName = RawParseUtils.decode(StandardCharsets.UTF_8, rawTag, p, nameEnd);
        if (walk.isRetainBody()) {
            this.buffer = rawTag;
        }
        this.flags |= 1;
    }

    @Override
    public final int getType() {
        return 4;
    }

    public final PersonIdent getTaggerIdent() {
        byte[] raw = this.buffer;
        int nameB = RawParseUtils.tagger(raw, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw, nameB);
    }

    private static int nextStart(byte[] prefix, byte[] buffer, int from) {
        int stop = buffer.length - prefix.length + 1;
        int ptr = from;
        if (ptr > 0) {
            ptr = RawParseUtils.nextLF(buffer, ptr - 1);
        }
        while (ptr < stop) {
            int lineStart = ptr;
            boolean found = true;
            for (byte element : prefix) {
                if (element == buffer[ptr++]) continue;
                found = false;
                break;
            }
            if (found) {
                return lineStart;
            }
            while ((ptr = RawParseUtils.nextLF(buffer, ptr)) < stop && buffer[ptr] == 10) {
            }
        }
        return -1;
    }

    private int getSignatureStart() {
        int newStart;
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.tagMessage(raw, 0);
        if (msgB < 0) {
            return msgB;
        }
        int start = RevTag.nextStart(hSignature, raw, msgB);
        if (start < 0) {
            return start;
        }
        int next = RawParseUtils.nextLF(raw, start);
        while (next < raw.length && (newStart = RevTag.nextStart(hSignature, raw, next)) >= 0) {
            start = newStart;
            next = RawParseUtils.nextLF(raw, start);
        }
        return start;
    }

    @Nullable
    public final byte[] getRawGpgSignature() {
        byte[] raw = this.buffer;
        int start = this.getSignatureStart();
        if (start < 0) {
            return null;
        }
        return Arrays.copyOfRange(raw, start, raw.length);
    }

    public final String getFullMessage() {
        int end;
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.tagMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        int signatureStart = this.getSignatureStart();
        int n = end = signatureStart < 0 ? raw.length : signatureStart;
        if (end == msgB) {
            return "";
        }
        return RawParseUtils.decode(this.guessEncoding(), raw, msgB, end);
    }

    public final String getShortMessage() {
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.tagMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        int msgE = RawParseUtils.endOfParagraph(raw, msgB);
        int signatureStart = this.getSignatureStart();
        if (signatureStart >= msgB && msgE > signatureStart) {
            msgE = signatureStart;
            if (msgE > msgB) {
                --msgE;
            }
            if (msgB == msgE) {
                return "";
            }
        }
        String str = RawParseUtils.decode(this.guessEncoding(), raw, msgB, msgE);
        if (RevCommit.hasLF(raw, msgB, msgE)) {
            str = StringUtils.replaceLineBreaksWithSpace(str);
        }
        return str;
    }

    private Charset guessEncoding() {
        try {
            return RawParseUtils.parseEncoding(this.buffer);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return StandardCharsets.UTF_8;
        }
    }

    public final RevObject getObject() {
        return this.object;
    }

    public final String getTagName() {
        return this.tagName;
    }

    public final byte[] getRawBuffer() {
        return this.buffer;
    }

    public final void disposeBody() {
        this.buffer = null;
    }
}

