/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.merge;

import com.jxdinfo.hussar.formdesign.jgit.lib.Config;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectInserter;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.merge.MergeStrategy;
import com.jxdinfo.hussar.formdesign.jgit.merge.Merger;
import java.io.IOException;

public class StrategyOneSided
extends MergeStrategy {
    private final String strategyName;
    private final int treeIndex;

    protected StrategyOneSided(String name, int index) {
        this.strategyName = name;
        this.treeIndex = index;
    }

    @Override
    public String getName() {
        return this.strategyName;
    }

    @Override
    public Merger newMerger(Repository db) {
        return new OneSide(db, this.treeIndex);
    }

    @Override
    public Merger newMerger(Repository db, boolean inCore) {
        return new OneSide(db, this.treeIndex);
    }

    @Override
    public Merger newMerger(ObjectInserter inserter, Config config) {
        return new OneSide(inserter, this.treeIndex);
    }

    static class OneSide
    extends Merger {
        private final int treeIndex;

        protected OneSide(Repository local, int index) {
            super(local);
            this.treeIndex = index;
        }

        protected OneSide(ObjectInserter inserter, int index) {
            super(inserter);
            this.treeIndex = index;
        }

        @Override
        protected boolean mergeImpl() throws IOException {
            return this.treeIndex < this.sourceTrees.length;
        }

        @Override
        public ObjectId getResultTreeId() {
            return this.sourceTrees[this.treeIndex];
        }

        @Override
        public ObjectId getBaseCommitId() {
            return null;
        }
    }
}

